/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.path;

import de.danielbechler.diff.selector.BeanPropertyElementSelector;
import de.danielbechler.diff.selector.CollectionItemElementSelector;
import de.danielbechler.diff.selector.ElementSelector;
import de.danielbechler.diff.selector.MapKeyElementSelector;
import de.danielbechler.diff.selector.RootElementSelector;
import de.danielbechler.util.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class NodePath
implements Comparable<NodePath> {
    private final List<ElementSelector> elementSelectors;

    private NodePath(List<ElementSelector> elementSelectors) {
        this.elementSelectors = Collections.unmodifiableList(elementSelectors);
    }

    public boolean isParentOf(NodePath nodePath) {
        List<ElementSelector> otherElementSelectors = nodePath.getElementSelectors();
        if (this.elementSelectors.size() < otherElementSelectors.size()) {
            return otherElementSelectors.subList(0, this.elementSelectors.size()).equals(this.elementSelectors);
        }
        return false;
    }

    public List<ElementSelector> getElementSelectors() {
        return this.elementSelectors;
    }

    public boolean isChildOf(NodePath nodePath) {
        List<ElementSelector> otherElementSelectors = nodePath.getElementSelectors();
        if (this.elementSelectors.size() > otherElementSelectors.size()) {
            return this.elementSelectors.subList(0, otherElementSelectors.size()).equals(otherElementSelectors);
        }
        return false;
    }

    public ElementSelector getLastElementSelector() {
        return this.elementSelectors.get(this.elementSelectors.size() - 1);
    }

    public int hashCode() {
        return this.elementSelectors.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodePath that = (NodePath)o;
        return this.elementSelectors.equals(that.elementSelectors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<ElementSelector> iterator = this.elementSelectors.iterator();
        ElementSelector previousElementSelector = null;
        while (iterator.hasNext()) {
            ElementSelector elementSelector = iterator.next();
            if (elementSelector instanceof RootElementSelector) {
                sb.append("/");
            } else if (elementSelector instanceof CollectionItemElementSelector || elementSelector instanceof MapKeyElementSelector) {
                sb.append(elementSelector);
            } else if (previousElementSelector instanceof RootElementSelector) {
                sb.append(elementSelector);
            } else {
                sb.append('/');
                sb.append(elementSelector);
            }
            previousElementSelector = elementSelector;
        }
        return sb.toString();
    }

    @Override
    public int compareTo(NodePath that) {
        int distance = this.getElementSelectors().size() - that.getElementSelectors().size();
        if (distance == 0) {
            return this.matches(that) ? 0 : 1;
        }
        if (distance > 0) {
            return 1;
        }
        return -1;
    }

    public boolean matches(NodePath nodePath) {
        return nodePath.equals(this);
    }

    public static AppendableBuilder startBuildingFrom(NodePath nodePath) {
        Assert.notNull(nodePath, "propertyPath");
        return new AppendableBuilderImpl(new ArrayList<ElementSelector>(nodePath.getElementSelectors()));
    }

    public static NodePath with(String propertyName, String ... additionalPropertyNames) {
        return NodePath.startBuilding().propertyName(propertyName, additionalPropertyNames).build();
    }

    public static AppendableBuilder startBuilding() {
        LinkedList<ElementSelector> elementSelectors1 = new LinkedList<ElementSelector>();
        elementSelectors1.add(RootElementSelector.getInstance());
        return new AppendableBuilderImpl(elementSelectors1);
    }

    public static NodePath withRoot() {
        return NodePath.startBuilding().build();
    }

    private static final class AppendableBuilderImpl
    implements AppendableBuilder {
        private final List<ElementSelector> elementSelectors;

        public AppendableBuilderImpl(List<ElementSelector> elementSelectors) {
            Assert.notEmpty(elementSelectors, "elementSelectors");
            this.elementSelectors = new LinkedList<ElementSelector>(elementSelectors);
        }

        @Override
        public AppendableBuilder element(ElementSelector elementSelector) {
            Assert.notNull(elementSelector, "elementSelector");
            this.elementSelectors.add(elementSelector);
            return this;
        }

        @Override
        public AppendableBuilder propertyName(String name, String ... names) {
            this.elementSelectors.add(new BeanPropertyElementSelector(name));
            for (String s : names) {
                this.elementSelectors.add(new BeanPropertyElementSelector(s));
            }
            return this;
        }

        @Override
        public <T> AppendableBuilder collectionItem(T item) {
            this.elementSelectors.add(new CollectionItemElementSelector(item));
            return this;
        }

        @Override
        public <K> AppendableBuilder mapKey(K key) {
            Assert.notNull(key, "key");
            this.elementSelectors.add(new MapKeyElementSelector(key));
            return this;
        }

        @Override
        public NodePath build() {
            if (this.elementSelectors.isEmpty()) {
                throw new IllegalStateException("A property path cannot be empty");
            }
            if (!(this.elementSelectors.get(0) instanceof RootElementSelector)) {
                throw new IllegalStateException("A property path must start with a root element");
            }
            if (this.elementCount(RootElementSelector.class) > 1) {
                throw new IllegalStateException("A property path cannot contain multiple root elements");
            }
            return new NodePath(this.elementSelectors);
        }

        private int elementCount(Class<? extends ElementSelector> type) {
            assert (type != null) : "Type must not be null";
            int count = 0;
            for (ElementSelector elementSelector : this.elementSelectors) {
                if (!type.isAssignableFrom(elementSelector.getClass())) continue;
                ++count;
            }
            return count;
        }
    }

    public static interface AppendableBuilder {
        public AppendableBuilder element(ElementSelector var1);

        public AppendableBuilder propertyName(String var1, String ... var2);

        public <T> AppendableBuilder collectionItem(T var1);

        public <K> AppendableBuilder mapKey(K var1);

        public NodePath build();
    }
}

