/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.plugins.database.ConnectionPoolingSupport;
import org.rhq.plugins.database.DatabaseComponent;
import org.rhq.plugins.database.DatabasePluginUtil;
import org.rhq.plugins.database.PooledConnectionProvider;
import org.rhq.plugins.postgres.PostgresServerComponent;

public class PostgresUserComponent
implements DatabaseComponent<PostgresServerComponent<?>>,
ConnectionPoolingSupport,
MeasurementFacet,
ConfigurationFacet,
DeleteResourceFacet {
    private ResourceContext<PostgresServerComponent<?>> resourceContext;

    public void start(ResourceContext<PostgresServerComponent<?>> resourceContext) {
        this.resourceContext = resourceContext;
    }

    public void stop() {
        this.resourceContext = null;
    }

    public boolean supportsConnectionPooling() {
        return true;
    }

    public PooledConnectionProvider getPooledConnectionProvider() {
        return ((PostgresServerComponent)this.resourceContext.getParentResourceComponent()).getPooledConnectionProvider();
    }

    public String getUserName() {
        return this.resourceContext.getPluginConfiguration().getSimpleValue("userName", null);
    }

    public AvailabilityType getAvailability() {
        if (DatabasePluginUtil.getSingleNumericQueryValue((ResourceComponent)this, (String)"SELECT COUNT(*) FROM PG_ROLES WHERE rolname = ?", (Object[])new Object[]{this.getUserName()}) == 1.0) {
            return AvailabilityType.UP;
        }
        return AvailabilityType.DOWN;
    }

    public Connection getConnection() {
        return ((PostgresServerComponent)this.resourceContext.getParentResourceComponent()).getConnection();
    }

    public void removeConnection() {
        ((PostgresServerComponent)this.resourceContext.getParentResourceComponent()).removeConnection();
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        Map values = DatabasePluginUtil.getNumericQueryValues((ResourceComponent)this, (String)"SELECT (SELECT COUNT(*) FROM pg_stat_activity where usename = ? AND current_query != '<IDLE>') AS active,\n  (SELECT COUNT(*) FROM pg_stat_activity WHERE usename = ?) AS total", (Object[])new Object[]{this.getUserName(), this.getUserName()});
        for (MeasurementScheduleRequest request : metrics) {
            report.addData(new MeasurementDataNumeric(request, (Double)values.get(request.getName())));
        }
    }

    public Configuration loadResourceConfiguration() throws Exception {
        Configuration configuration;
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getPooledConnectionProvider().getPooledConnection();
            statement = connection.prepareStatement("SELECT * FROM PG_ROLES WHERE rolname = ?");
            statement.setString(1, this.getUserName());
            resultSet = statement.executeQuery();
            resultSet.next();
            Configuration config = new Configuration();
            config.put((Property)new PropertySimple("user", (Object)resultSet.getString("rolname")));
            config.put((Property)new PropertySimple("canLogin", (Object)resultSet.getBoolean("rolcanlogin")));
            config.put((Property)new PropertySimple("inheritRights", (Object)resultSet.getBoolean("rolinherit")));
            config.put((Property)new PropertySimple("superuser", (Object)resultSet.getBoolean("rolsuper")));
            config.put((Property)new PropertySimple("canCreateDatabaseObjects", (Object)resultSet.getBoolean("rolcreatedb")));
            config.put((Property)new PropertySimple("canCreateRoles", (Object)resultSet.getBoolean("rolcreaterole")));
            config.put((Property)new PropertySimple("canModifyCatalogDirectly", (Object)resultSet.getBoolean("rolcatupdate")));
            config.put((Property)new PropertySimple("connectionLimit", (Object)resultSet.getInt("rolconnlimit")));
            configuration = config;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw e;
            }
            catch (Throwable throwable) {
                DatabasePluginUtil.safeClose((Connection)connection, statement, resultSet);
                throw throwable;
            }
        }
        DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement, (ResultSet)resultSet);
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        Configuration config = report.getConfiguration();
        String sql = PostgresUserComponent.getUserSQL(config, UpdateType.ALTER);
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.getPooledConnectionProvider().getPooledConnection();
            statement = this.getConnection().createStatement();
            statement.executeUpdate(sql);
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        catch (SQLException e) {
            try {
                report.setErrorMessageFromThrowable((Throwable)e);
            }
            catch (Throwable throwable) {
                DatabasePluginUtil.safeClose((Connection)connection, statement);
                throw throwable;
            }
            DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement);
        }
        DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement);
    }

    public static String getUserSQL(Configuration config, UpdateType type) {
        int connectionLimit = -1;
        PropertySimple connLimit = config.getSimple("connectionLimit");
        if (connLimit != null && connLimit.getIntegerValue() != null) {
            connectionLimit = connLimit.getIntegerValue();
        }
        String sql = type.name() + " USER " + config.getSimpleValue("user", null) + " ";
        if (type != UpdateType.DROP) {
            String password = config.getSimpleValue("password", null);
            if (password != null && password.length() != 0) {
                sql = sql + " WITH PASSWORD '" + config.getSimpleValue("password", null) + "' ";
            }
            sql = sql + (config.getSimple("canCreateDatabaseObjects").getBooleanValue() != false ? "CREATEDB " : "NOCREATEDB ");
            sql = sql + (config.getSimple("canCreateRoles").getBooleanValue() != false ? "CREATEUSER " : "NOCREATEUSER ");
            sql = sql + (connectionLimit > -1 ? "CONNECTION LIMIT " + connectionLimit : "");
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteResource() throws Exception {
        String sql = "DROP USER " + this.resourceContext.getResourceKey();
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.getPooledConnectionProvider().getPooledConnection();
            statement = this.getConnection().createStatement();
            statement.executeUpdate(sql);
        }
        catch (Throwable throwable) {
            DatabasePluginUtil.safeClose((Connection)connection, statement);
            throw throwable;
        }
        DatabasePluginUtil.safeClose((Connection)connection, (Statement)statement);
    }

    public static enum UpdateType {
        CREATE,
        ALTER,
        DROP;

    }
}

