/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.parser;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.scribble.context.DefaultModuleLoader;
import org.scribble.context.ModuleLoader;
import org.scribble.logging.IssueLogger;
import org.scribble.model.Module;
import org.scribble.parser.ProtocolParser;
import org.scribble.resources.Resource;
import org.scribble.resources.ResourceLocator;

public class ProtocolModuleLoader
extends DefaultModuleLoader
implements ModuleLoader {
    private static final Logger LOG = Logger.getLogger(ProtocolModuleLoader.class.getName());
    private ResourceLocator _locator = null;
    private IssueLogger _logger = null;
    private ProtocolParser _parser = null;

    public ProtocolModuleLoader(ProtocolParser parser, ResourceLocator locator, IssueLogger logger) {
        this._parser = parser;
        this._locator = locator;
        this._logger = logger;
    }

    public Module loadModule(String module) {
        String relativePath;
        Resource resource;
        Module ret = super.loadModule(module);
        if (ret == null && (resource = this._locator.getResource(relativePath = module.replace('.', File.separatorChar) + ".scr")) != null) {
            try {
                ret = this._parser.parse(resource, this, this._logger);
                if (ret != null) {
                    this.registerModule(ret);
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to parse imported module '" + module + "'", e);
            }
        }
        return ret;
    }
}

