/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.parser;

import java.io.IOException;
import java.io.InputStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.scribble.context.ModuleLoader;
import org.scribble.logging.IssueLogger;
import org.scribble.model.Module;
import org.scribble.parser.antlr.ProtocolTreeAdaptor;
import org.scribble.parser.antlr.ScribbleLexer;
import org.scribble.parser.antlr.ScribbleParser;
import org.scribble.resources.Resource;

public class ProtocolParser {
    public Module parse(Resource resource, ModuleLoader loader, IssueLogger logger) throws IOException {
        Module ret = null;
        try {
            InputStream is = resource.getInputStream();
            byte[] b = new byte[is.available()];
            is.read(b);
            is.close();
            String document = new String(b);
            ScribbleLexer lex = new ScribbleLexer((CharStream)new ANTLRStringStream(document));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
            ScribbleParser parser = new ScribbleParser((TokenStream)tokens);
            ProtocolTreeAdaptor adaptor = new ProtocolTreeAdaptor();
            adaptor.setParser(parser);
            parser.setDocument(document);
            parser.setTreeAdaptor(adaptor);
            parser.setLogger(logger);
            parser.module();
            if (!parser.isErrorOccurred()) {
                ret = adaptor.getModule();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

