/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.auth;

import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.impl.aesh.cmd.security.SecurityCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.SecurityCommandActivator;
import org.jboss.as.cli.impl.aesh.cmd.security.auth.AbstractMgmtDisableAuthenticationCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthFactorySpec;
import org.jboss.as.cli.impl.aesh.cmd.security.model.DefaultResourceNames;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ManagementInterfaces;
import org.jboss.dmr.ModelNode;

@CommandDefinition(name="disable-sasl-management", description="", activator=SecurityCommandActivator.class)
public class ManagementDisableSASLCommand
extends AbstractMgmtDisableAuthenticationCommand {
    @Option(name="management-interface", hasValue=true, completer=SecurityCommand.OptionCompleters.ManagementInterfaceCompleter.class)
    String managementInterface;

    public ManagementDisableSASLCommand() {
        super(AuthFactorySpec.SASL);
    }

    @Override
    public String getEnabledFactory(CommandContext ctx) throws Exception {
        return ManagementInterfaces.getManagementInterfaceSaslFactoryName(this.managementInterface, ctx);
    }

    @Override
    protected ModelNode disableFactory(CommandContext context) throws Exception {
        if (this.managementInterface == null) {
            this.managementInterface = DefaultResourceNames.getDefaultManagementInterfaceName(context);
        }
        ModelNode request = ManagementInterfaces.disableSASL(context, this.managementInterface);
        return request;
    }

    @Override
    protected String getSecuredEndpoint(CommandContext ctx) {
        if (this.managementInterface == null) {
            this.managementInterface = DefaultResourceNames.getDefaultManagementInterfaceName(ctx);
        }
        return "management " + this.managementInterface;
    }
}

