/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui.component;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class HelpButton
extends JButton {
    private JScrollPane helpScroller;

    public HelpButton(String helpFile) {
        super("Help");
        try {
            this.readHelpFile(helpFile);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Unable to read " + helpFile);
            return;
        }
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane helpPane = new JOptionPane(HelpButton.this.helpScroller, -1, -1);
                JDialog dialog = helpPane.createDialog(HelpButton.this, "Help");
                dialog.setResizable(true);
                dialog.setModal(false);
                dialog.setSize(dialog.getHeight(), HelpButton.this.helpScroller.getWidth() + 10);
                dialog.setVisible(true);
            }
        });
    }

    private void readHelpFile(String helpFile) throws IOException {
        InputStream in = this.getClass().getResourceAsStream("/help/" + helpFile);
        JEditorPane helpText = new JEditorPane();
        helpText.read(in, (Object)null);
        helpText.setEditable(false);
        this.helpScroller = new JScrollPane(helpText);
    }
}

