/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.CharacterHandlerMap;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.ParsingContext;

public class ExpressionBaseState
extends DefaultParsingState {
    private final boolean resolveSystemProperties;
    private final boolean exceptionIfNotResolved;
    private CharacterHandler resolvingEntranceHandler = new CharacterHandler(){

        @Override
        public void handle(ParsingContext ctx) throws CommandFormatException {
            ctx.resolveExpression(ExpressionBaseState.this.resolveSystemProperties, ExpressionBaseState.this.exceptionIfNotResolved);
            ExpressionBaseState.super.getEnterHandler().handle(ctx);
        }
    };

    public ExpressionBaseState(String id) {
        this(id, true);
    }

    public ExpressionBaseState(String id, boolean enterLeaveContent, CharacterHandlerMap enterStateHandlers) {
        super(id, enterLeaveContent, enterStateHandlers);
        this.resolveSystemProperties = true;
        this.exceptionIfNotResolved = true;
        this.putExpressionHandler();
    }

    public ExpressionBaseState(String id, boolean resolveSystemProperties) {
        this(id, resolveSystemProperties, true);
    }

    public ExpressionBaseState(String id, boolean resolveSystemProperties, boolean exceptionIfNotResolved) {
        super(id);
        this.resolveSystemProperties = resolveSystemProperties;
        this.exceptionIfNotResolved = exceptionIfNotResolved;
        this.putExpressionHandler();
    }

    protected void putExpressionHandler() {
        this.putHandler('$', new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                int originalLength = ctx.getInput().length();
                ctx.resolveExpression(ExpressionBaseState.this.resolveSystemProperties, ExpressionBaseState.this.exceptionIfNotResolved);
                char resolvedCh = ctx.getCharacter();
                if (resolvedCh == '$' && originalLength == ctx.getInput().length()) {
                    ExpressionBaseState.this.getDefaultHandler().handle(ctx);
                } else {
                    ExpressionBaseState.this.getHandler(resolvedCh).handle(ctx);
                }
            }
        });
    }

    @Override
    public CharacterHandler getEnterHandler() {
        return this.resolvingEntranceHandler;
    }
}

