/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.embedded;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.cli.CliEvent;
import org.jboss.as.cli.CliEventListener;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.embedded.Contexts;
import org.jboss.as.cli.embedded.EmbeddedProcessLaunch;
import org.jboss.as.cli.embedded.EnvironmentRestorer;
import org.jboss.as.cli.embedded.StopEmbeddedHostControllerHandler;
import org.jboss.as.cli.embedded.ThreadContextsModelControllerClient;
import org.jboss.as.cli.embedded.ThreadLocalContextSelector;
import org.jboss.as.cli.embedded.UncloseablePrintStream;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.DefaultFilenameTabCompleter;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.handlers.WindowsFilenameTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.FileSystemPathArgument;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextSelector;
import org.jboss.logmanager.PropertyConfigurator;
import org.jboss.modules.ModuleLoader;
import org.jboss.stdio.NullOutputStream;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;
import org.wildfly.core.embedded.EmbeddedManagedProcess;
import org.wildfly.core.embedded.EmbeddedProcessFactory;
import org.wildfly.core.embedded.EmbeddedProcessStartException;
import org.wildfly.core.embedded.HostController;
import org.wildfly.security.manager.WildFlySecurityManager;

class EmbedHostControllerHandler
extends CommandHandlerWithHelp {
    private static final String ECHO = "echo";
    private static final String DISCARD_STDOUT = "discard";
    private static final String DOMAIN_CONFIG = "--domain-config";
    private static final String HOST_CONFIG = "--host-config";
    private final AtomicReference<EmbeddedProcessLaunch> hostControllerReference;
    private ArgumentWithValue jbossHome;
    private ArgumentWithValue stdOutHandling;
    private ArgumentWithValue domainConfig;
    private ArgumentWithValue hostConfig;
    private ArgumentWithValue dashC;
    private ArgumentWithValue timeout;

    static EmbedHostControllerHandler create(AtomicReference<EmbeddedProcessLaunch> hostControllerReference, CommandContext ctx, boolean modular) {
        FilenameTabCompleter pathCompleter;
        EmbedHostControllerHandler result = new EmbedHostControllerHandler(hostControllerReference);
        FilenameTabCompleter filenameTabCompleter = pathCompleter = Util.isWindows() ? new WindowsFilenameTabCompleter(ctx) : new DefaultFilenameTabCompleter(ctx);
        if (!modular) {
            result.jbossHome = new FileSystemPathArgument((CommandHandlerWithArguments)result, pathCompleter, "--jboss-home");
        }
        result.stdOutHandling = new ArgumentWithValue((CommandHandlerWithArguments)result, new SimpleTabCompleter(new String[]{ECHO, DISCARD_STDOUT}), "--std-out");
        result.domainConfig = new ArgumentWithValue(result, DOMAIN_CONFIG);
        result.hostConfig = new ArgumentWithValue(result, HOST_CONFIG);
        result.dashC = new ArgumentWithValue(result, "-c");
        result.dashC.addCantAppearAfter(result.domainConfig);
        result.domainConfig.addCantAppearAfter(result.dashC);
        result.timeout = new ArgumentWithValue(result, "--timeout");
        return result;
    }

    private EmbedHostControllerHandler(AtomicReference<EmbeddedProcessLaunch> hostControllerReference) {
        super("embed-host-controller", false);
        assert (hostControllerReference != null);
        this.hostControllerReference = hostControllerReference;
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        return ctx.getModelControllerClient() == null;
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        List<String> args;
        ParsedCommandLine parsedCmd = ctx.getParsedCommandLine();
        File jbossHome = this.getJBossHome(parsedCmd);
        String domainXml = this.domainConfig.getValue(parsedCmd);
        if (domainXml == null) {
            domainXml = this.dashC.getValue(parsedCmd);
        }
        if ((this.domainConfig.isPresent(parsedCmd) || this.dashC.isPresent(parsedCmd)) && (domainXml == null || domainXml.isEmpty())) {
            throw new CommandFormatException("The --domain-config (or -c) parameter requires a value.");
        }
        String hostXml = this.hostConfig.getValue(parsedCmd);
        if (this.hostConfig.isPresent(parsedCmd) && (hostXml == null || hostXml.isEmpty())) {
            throw new CommandFormatException("The --host-config parameter requires a value.");
        }
        Long bootTimeout = null;
        String timeoutString = this.timeout.getValue(parsedCmd);
        if (this.timeout.isPresent(parsedCmd) && (timeoutString == null || timeoutString.isEmpty())) {
            throw new CommandFormatException("The --timeout parameter requires a value.");
        }
        if (timeoutString != null) {
            bootTimeout = TimeUnit.SECONDS.toNanos(Long.parseLong(timeoutString));
        }
        String stdOutString = this.stdOutHandling.getValue(parsedCmd);
        if (this.stdOutHandling.isPresent(parsedCmd)) {
            if (stdOutString == null || stdOutString.isEmpty()) {
                throw new CommandFormatException("The --std-out parameter requires a value { echo, discard }.");
            }
            if (!stdOutString.equals(ECHO) && !stdOutString.equals(DISCARD_STDOUT)) {
                throw new CommandFormatException("The --std-out parameter should be one of { echo, discard }.");
            }
        }
        if (!(args = parsedCmd.getOtherProperties()).isEmpty() && args.size() != 0) {
            throw new CommandFormatException("The command accepts 0 unnamed argument(s) but received: " + args);
        }
        EnvironmentRestorer restorer = new EnvironmentRestorer();
        boolean ok = false;
        ThreadLocalContextSelector contextSelector = null;
        try {
            Contexts defaultContexts = restorer.getDefaultContexts();
            StdioContext discardStdoutContext = null;
            if (!ECHO.equalsIgnoreCase(this.stdOutHandling.getValue(parsedCmd))) {
                UncloseablePrintStream nullStream = new UncloseablePrintStream((OutputStream)NullOutputStream.getInstance());
                StdioContext currentContext = defaultContexts.getStdioContext();
                discardStdoutContext = StdioContext.create((InputStream)currentContext.getIn(), (PrintStream)nullStream, (PrintStream)currentContext.getErr());
            }
            LogContext embeddedLogContext = LogContext.create();
            this.configureLogContext(embeddedLogContext, jbossHome, ctx);
            Contexts localContexts = new Contexts(embeddedLogContext, discardStdoutContext);
            contextSelector = new ThreadLocalContextSelector(localContexts, defaultContexts);
            contextSelector.pushLocal();
            StdioContext.setStdioContextSelector((StdioContextSelector)contextSelector);
            LogContext.setLogContextSelector((LogContextSelector)contextSelector);
            ArrayList<String> cmdsList = new ArrayList<String>();
            if (domainXml != null && domainXml.trim().length() > 0) {
                cmdsList.add(DOMAIN_CONFIG);
                cmdsList.add(domainXml.trim());
            }
            if (hostXml != null && hostXml.trim().length() > 0) {
                cmdsList.add(HOST_CONFIG);
                cmdsList.add(hostXml.trim());
            }
            String[] cmds = cmdsList.toArray(new String[cmdsList.size()]);
            HostController hostController = this.jbossHome == null ? EmbeddedProcessFactory.createHostController((ModuleLoader)ModuleLoader.forClass(this.getClass()), (File)jbossHome, (String[])cmds) : EmbeddedProcessFactory.createHostController((String)jbossHome.getAbsolutePath(), null, null, (String[])cmds);
            hostController.start();
            this.hostControllerReference.set(new EmbeddedProcessLaunch((EmbeddedManagedProcess)hostController, restorer, true));
            ThreadContextsModelControllerClient mcc = new ThreadContextsModelControllerClient(hostController.getModelControllerClient(), contextSelector);
            if (bootTimeout == null || bootTimeout > 0L) {
                long expired = bootTimeout == null ? Long.MAX_VALUE : System.nanoTime() + bootTimeout;
                String localName = "master";
                String status = "starting";
                ModelNode getNameOp = new ModelNode();
                getNameOp.get("operation").set("read-attribute");
                getNameOp.get("name").set("local-host-name");
                ModelNode getStateOp = new ModelNode();
                getStateOp.get("operation").set("read-attribute");
                ModelNode address = getStateOp.get("address");
                address.add("host", localName);
                getStateOp.get("name").set("host-state");
                do {
                    try {
                        ModelNode nameResponse = mcc.execute(getNameOp);
                        if (Util.isSuccess(nameResponse)) {
                            localName = nameResponse.get("result").asString();
                            address.set("host", localName);
                            ModelNode stateResponse = mcc.execute(getStateOp);
                            if (Util.isSuccess(stateResponse)) {
                                status = stateResponse.get("result").asString();
                            }
                        }
                    }
                    catch (Exception nameResponse) {
                        // empty catch block
                    }
                    if (!"starting".equals(status)) break;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new CommandLineException("Interrupted while waiting for embedded server to start");
                    }
                } while (System.nanoTime() < expired);
                if ("starting".equals(status)) {
                    assert (bootTimeout != null);
                    StopEmbeddedHostControllerHandler.cleanup(this.hostControllerReference);
                    throw new CommandLineException("Embedded host controller did not exit 'starting' status within " + TimeUnit.NANOSECONDS.toSeconds(bootTimeout) + " seconds");
                }
            }
            ctx.bindClient(mcc);
            ctx.addEventListener(new CliEventListener(){

                @Override
                public void cliEvent(CliEvent event, CommandContext ctx) {
                    if (event == CliEvent.DISCONNECTED) {
                        StopEmbeddedHostControllerHandler.cleanup(EmbedHostControllerHandler.this.hostControllerReference);
                    }
                }
            });
            ok = true;
        }
        catch (RuntimeException | EmbeddedProcessStartException e) {
            throw new CommandLineException("Cannot start embedded Host Controller", e);
        }
        finally {
            if (!ok) {
                ctx.disconnectController();
                restorer.restoreEnvironment();
            } else if (contextSelector != null) {
                contextSelector.restore(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureLogContext(LogContext embeddedLogContext, File jbossHome, CommandContext ctx) {
        File standaloneDir = new File(jbossHome, "domain");
        File configDir = new File(standaloneDir, "configuration");
        File logDir = new File(standaloneDir, "log");
        File bootLog = new File(logDir, "server.log");
        File loggingProperties = new File(configDir, "logging.properties");
        if (loggingProperties.exists()) {
            WildFlySecurityManager.setPropertyPrivileged((String)"org.jboss.boot.log.file", (String)bootLog.getAbsolutePath());
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(loggingProperties);
                new PropertyConfigurator(embeddedLogContext).configure((InputStream)fis);
            }
            catch (IOException e) {
                try {
                    ctx.printLine("Unable to configure embedded host controller logging from " + loggingProperties);
                }
                catch (Throwable throwable) {
                    StreamUtils.safeClose(fis);
                    throw throwable;
                }
                StreamUtils.safeClose((Closeable)fis);
            }
            StreamUtils.safeClose((Closeable)fis);
        }
    }

    private File getJBossHome(ParsedCommandLine parsedCmd) throws CommandLineException {
        String jbossHome;
        String string = jbossHome = this.jbossHome == null ? null : this.jbossHome.getValue(parsedCmd);
        if (jbossHome == null || jbossHome.length() == 0) {
            jbossHome = WildFlySecurityManager.getEnvPropertyPrivileged((String)"JBOSS_HOME", null);
            if (jbossHome == null || jbossHome.length() == 0) {
                if (this.jbossHome != null) {
                    throw new CommandLineException("Missing configuration value for --jboss-home and environment variable JBOSS_HOME is not set");
                }
                throw new CommandLineException("Environment variable JBOSS_HOME is not set");
            }
            return EmbedHostControllerHandler.validateJBossHome(jbossHome, "environment variable JBOSS_HOME");
        }
        return EmbedHostControllerHandler.validateJBossHome(jbossHome, "argument --jboss-home");
    }

    private static File validateJBossHome(String jbossHome, String source) throws CommandLineException {
        File f = new File(jbossHome);
        if (!f.exists()) {
            throw new CommandLineException(String.format("File %s specified by %s does not exist", jbossHome, source));
        }
        if (!f.isDirectory()) {
            throw new CommandLineException(String.format("File %s specified by %s is not a directory", jbossHome, source));
        }
        return f;
    }
}

