/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.OperationCommand;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class OperationRequestHandler
implements CommandHandler,
OperationCommand {
    @Override
    public boolean isBatchMode(CommandContext ctx) {
        return true;
    }

    @Override
    public void handle(CommandContext ctx) throws CommandLineException {
        ModelNode opDescOutcome;
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            throw new CommandFormatException("You are disconnected at the moment. Type 'connect' to connect to the server or 'help' for the list of supported commands.");
        }
        ModelNode request = (ModelNode)ctx.get("OP_REQ");
        if (request == null) {
            throw new CommandLineException("Parsed request isn't available.");
        }
        if (ctx.getConfig().isValidateOperationRequests() && (opDescOutcome = Util.validateRequest(ctx, request)) != null) {
            Util.replaceFilePathsWithBytes(request, opDescOutcome);
        }
        try {
            ModelNode result = client.execute(request);
            if (!Util.isSuccess(result)) {
                throw new CommandLineException(result.toString());
            }
            ctx.printLine(result.toString());
        }
        catch (NoSuchElementException e) {
            throw new CommandLineException("ModelNode request is incomplete", e);
        }
        catch (CancellationException e) {
            throw new CommandLineException("The result couldn't be retrieved (perhaps the task was cancelled", e);
        }
        catch (IOException e) {
            ctx.disconnectController();
            throw new CommandLineException("Communication error", e);
        }
        catch (RuntimeException e) {
            throw new CommandLineException("Failed to execute operation.", e);
        }
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        return true;
    }

    @Override
    public ModelNode buildRequest(CommandContext ctx) throws CommandFormatException {
        return ((DefaultCallbackHandler)ctx.getParsedCommandLine()).toOperationRequest(ctx);
    }

    @Override
    public CommandArgument getArgument(CommandContext ctx, String name) {
        return null;
    }

    @Override
    public boolean hasArgument(CommandContext ctx, String name) {
        return false;
    }

    @Override
    public boolean hasArgument(CommandContext ctx, int index) {
        return false;
    }

    public List<CommandArgument> getArguments(CommandContext ctx) {
        return Collections.emptyList();
    }
}

