/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.command.container;

import java.io.IOException;
import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.parser.CommandLineParser;
import org.jboss.aesh.cl.parser.CommandLineParserException;
import org.jboss.aesh.cl.validator.CommandValidatorException;
import org.jboss.aesh.cl.validator.OptionValidatorException;
import org.jboss.aesh.console.AeshContext;
import org.jboss.aesh.console.InvocationProviders;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.container.CommandContainer;
import org.jboss.aesh.console.command.container.CommandContainerResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.parser.AeshLine;

public abstract class DefaultCommandContainer<C extends Command>
implements CommandContainer<C> {
    @Override
    public CommandContainerResult executeCommand(AeshLine line, InvocationProviders invocationProviders, AeshContext aeshContext, CommandInvocation commandInvocation) throws CommandLineParserException, OptionValidatorException, CommandValidatorException, IOException, InterruptedException {
        CommandLine<Command> commandLine = this.getParser().parse(line, false);
        commandLine.getParser().getCommandPopulator().populateObject(commandLine, invocationProviders, aeshContext, true);
        if (commandLine.getParser().getProcessedCommand().getValidator() != null && !commandLine.hasOptionWithOverrideRequired()) {
            commandLine.getParser().getProcessedCommand().getValidator().validate(commandLine.getParser().getCommand());
        }
        CommandResult result = commandLine.getParser().getCommand().execute(commandInvocation);
        return new CommandContainerResult(commandLine.getParser().getProcessedCommand().getResultHandler(), result);
    }

    @Override
    public String printHelp(String childCommandName) {
        if (this.getParser().isGroupCommand() && childCommandName.contains(" ")) {
            CommandLineParser<Command> child;
            String[] names = childCommandName.split(" ");
            if (names.length > 1 && names[1].length() > 0 && (child = this.getParser().getChildParser(names[1])) != null) {
                return child.printHelp();
            }
            return "Child command " + names[1] + " not found.";
        }
        return this.getParser().printHelp();
    }
}

