/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.helpers.domain.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.jboss.as.controller.client.helpers.domain.DeploymentAction;
import org.jboss.as.controller.client.helpers.domain.DeploymentPlan;
import org.jboss.as.controller.client.helpers.domain.ServerGroupDeploymentPlan;
import org.jboss.as.controller.client.helpers.domain.impl.DeploymentActionImpl;
import org.jboss.as.controller.client.helpers.domain.impl.DeploymentSetPlanImpl;

public class DeploymentPlanImpl
implements DeploymentPlan,
Serializable {
    private static final long serialVersionUID = -7652253540766375101L;
    private final DeploymentSetPlanImpl delegate;
    private final boolean rollbackAcrossGroups;

    DeploymentPlanImpl(DeploymentSetPlanImpl delegate, boolean rollbackAcrossGroups) {
        this.delegate = delegate;
        this.rollbackAcrossGroups = rollbackAcrossGroups;
    }

    @Override
    public UUID getId() {
        return this.delegate.getId();
    }

    public DeploymentAction getLastAction() {
        return this.delegate.getLastAction();
    }

    @Override
    public List<DeploymentAction> getDeploymentActions() {
        return this.delegate.getDeploymentActions();
    }

    @Override
    public boolean isSingleServerRollback() {
        return this.delegate.isRollback();
    }

    @Override
    public boolean isRollbackAcrossGroups() {
        return this.rollbackAcrossGroups;
    }

    @Override
    public long getGracefulShutdownTimeout() {
        return this.delegate.getGracefulShutdownTimeout();
    }

    @Override
    public boolean isGracefulShutdown() {
        return this.delegate.isGracefulShutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public List<Set<ServerGroupDeploymentPlan>> getServerGroupDeploymentPlans() {
        return this.delegate.getServerGroupDeploymentPlans();
    }

    List<DeploymentActionImpl> getDeploymentActionImpls() {
        List<DeploymentAction> actions = this.delegate.getDeploymentActions();
        ArrayList<DeploymentActionImpl> cast = new ArrayList<DeploymentActionImpl>(actions.size());
        for (DeploymentAction action : actions) {
            cast.add((DeploymentActionImpl)DeploymentActionImpl.class.cast(action));
        }
        return cast;
    }
}

