/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui.metacommand;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTabbedPane;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.as.cli.gui.ManagementModel;
import org.jboss.as.cli.gui.ManagementModelNode;
import org.jboss.as.cli.gui.component.ButtonTabComponent;

public class ExploreNodeAction
extends AbstractAction {
    private ManagementModelNode node;
    private CliGuiContext cliGuiCtx;

    public ExploreNodeAction(CliGuiContext cliGuiCtx) {
        super(ExploreNodeAction.calcActionName(cliGuiCtx));
        this.node = ExploreNodeAction.findSelectedNode(cliGuiCtx);
        this.cliGuiCtx = cliGuiCtx;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        JTabbedPane tabs = this.cliGuiCtx.getTabs();
        int newTabIndex = tabs.getSelectedIndex() + 1;
        ManagementModelNode newRoot = this.node.clone();
        tabs.insertTab(ExploreNodeAction.calcTabName(this.node), null, new ManagementModel(newRoot, this.cliGuiCtx), newRoot.addressPath(), newTabIndex);
        tabs.setTabComponentAt(newTabIndex, new ButtonTabComponent(tabs));
        tabs.setSelectedIndex(newTabIndex);
    }

    public ManagementModelNode getSelectedNode() {
        return this.node;
    }

    private static String calcActionName(CliGuiContext cliGuiCtx) {
        ManagementModelNode node = ExploreNodeAction.findSelectedNode(cliGuiCtx);
        if (node == null) {
            return "Explore selected node";
        }
        return "Explore " + ExploreNodeAction.calcTabName(node);
    }

    private static ManagementModelNode findSelectedNode(CliGuiContext cliGuiCtx) {
        Component selectedComponent = cliGuiCtx.getTabs().getSelectedComponent();
        if (selectedComponent == null) {
            return null;
        }
        if (!(selectedComponent instanceof ManagementModel)) {
            return null;
        }
        return ((ManagementModel)selectedComponent).getSelectedNode();
    }

    private static String calcTabName(ManagementModelNode node) {
        ManagementModelNode.UserObject usrObj = (ManagementModelNode.UserObject)node.getUserObject();
        if (usrObj.isGeneric()) {
            return node.toString();
        }
        if (usrObj.isLeaf()) {
            return usrObj.getName();
        }
        return node.toString();
    }
}

