/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.impl.ArgumentWithValue;

public class EchoDMRHandler
extends CommandHandlerWithHelp {
    public EchoDMRHandler() {
        super("echo-dmr");
        new ArgumentWithValue(this, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                char ch;
                String cmd;
                int cmdStart;
                int wordCount;
                boolean skipWS;
                String originalLine = ctx.getParsedCommandLine().getOriginalLine();
                if (Character.isWhitespace(originalLine.charAt(0))) {
                    skipWS = true;
                    wordCount = 0;
                } else {
                    skipWS = false;
                    wordCount = 1;
                }
                for (cmdStart = 1; cmdStart < originalLine.length(); ++cmdStart) {
                    if (skipWS) {
                        if (Character.isWhitespace(originalLine.charAt(cmdStart))) continue;
                        skipWS = false;
                        if (++wordCount != 2) continue;
                        break;
                    }
                    if (!Character.isWhitespace(originalLine.charAt(cmdStart))) continue;
                    skipWS = true;
                }
                if (wordCount == 1) {
                    cmd = "";
                } else {
                    if (wordCount != 2) {
                        return -1;
                    }
                    cmd = originalLine.substring(cmdStart);
                }
                int cmdResult = ctx.getDefaultCommandCompleter().complete(ctx, cmd, cmd.length(), candidates);
                if (cmdResult < 0) {
                    return cmdResult;
                }
                int escapeCorrection = 0;
                int start = originalLine.length() - 1 - buffer.length();
                while (start - escapeCorrection >= 0 && !Character.isWhitespace(ch = originalLine.charAt(start - escapeCorrection)) && ch != '=') {
                    ++escapeCorrection;
                }
                return buffer.length() + escapeCorrection - (cmd.length() - cmdResult);
            }
        }, Integer.MAX_VALUE, "--line"){};
    }

    @Override
    protected void recognizeArguments(CommandContext ctx) throws CommandFormatException {
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandFormatException {
        String argsStr = ctx.getArgumentsString();
        if (argsStr == null) {
            throw new CommandFormatException("Missing the command or operation to translate to DMR.");
        }
        ctx.printLine(ctx.buildRequest(argsStr).toString());
    }
}

