/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.batch;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.batch.BatchedCommand;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.impl.FileSystemPathArgument;

public class BatchHandler
extends CommandHandlerWithHelp {
    private final ArgumentWithoutValue l = new ArgumentWithoutValue(this, "-l");
    private final ArgumentWithValue name;
    private final ArgumentWithValue file;

    public BatchHandler(CommandContext ctx) {
        super("batch");
        this.l.setExclusive(true);
        this.name = new ArgumentWithValue((CommandHandlerWithArguments)this, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                int nextCharIndex;
                BatchManager batchManager = ctx.getBatchManager();
                Set<String> names = batchManager.getHeldbackNames();
                if (names.isEmpty()) {
                    return -1;
                }
                for (nextCharIndex = 0; nextCharIndex < buffer.length() && Character.isWhitespace(buffer.charAt(nextCharIndex)); ++nextCharIndex) {
                }
                String chunk = buffer.substring(nextCharIndex).trim();
                for (String name : names) {
                    if (name == null || !name.startsWith(chunk)) continue;
                    candidates.add(name);
                }
                Collections.sort(candidates);
                return nextCharIndex;
            }
        }, 0, "--name");
        this.name.setExclusive(true);
        FilenameTabCompleter pathCompleter = FilenameTabCompleter.newCompleter(ctx);
        this.file = new FileSystemPathArgument((CommandHandlerWithArguments)this, pathCompleter, "--file");
        this.file.setExclusive(true);
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        boolean activated;
        BatchManager batchManager = ctx.getBatchManager();
        boolean list = this.l.isPresent(ctx.getParsedCommandLine());
        String path = this.file.getValue(ctx.getParsedCommandLine());
        String name = this.name.getValue(ctx.getParsedCommandLine());
        if (list) {
            if (path != null || name != null) {
                throw new CommandFormatException("-l is exclusive, neither --file nor name can appear with -l.");
            }
            Set<String> heldbackNames = batchManager.getHeldbackNames();
            if (!heldbackNames.isEmpty()) {
                ArrayList<String> names = new ArrayList<String>(heldbackNames.size());
                for (String heldbackName : heldbackNames) {
                    names.add(heldbackName == null ? "<unnamed>" : heldbackName);
                }
                Collections.sort(names);
                for (String heldbackName : names) {
                    ctx.printLine(heldbackName);
                }
            }
            return;
        }
        if (batchManager.isBatchActive()) {
            throw new CommandLineException("Can't start a new batch while in batch mode.");
        }
        if (path != null) {
            if (name != null) {
                throw new CommandFormatException("Either --file or name argument can be specified at a time.");
            }
            File f = new File(path);
            if (!f.exists()) {
                throw new CommandLineException("File " + f.getAbsolutePath() + " does not exist.");
            }
            File currentDir = ctx.getCurrentDir();
            File baseDir = f.getParentFile();
            if (baseDir != null) {
                ctx.setCurrentDir(baseDir);
            }
            BufferedReader reader = null;
            try {
                reader = Files.newBufferedReader(f.toPath(), StandardCharsets.UTF_8);
                String line = reader.readLine();
                batchManager.activateNewBatch();
                Batch batch = batchManager.getActiveBatch();
                while (line != null) {
                    if (!(line = line.trim()).isEmpty() && line.charAt(0) != '#') {
                        batch.add(ctx.toBatchedCommand(line));
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                batchManager.discardActiveBatch();
                throw new CommandLineException("Failed to read file " + f.getAbsolutePath(), e);
            }
            catch (CommandFormatException e) {
                batchManager.discardActiveBatch();
                throw new CommandLineException("Failed to create batch from " + f.getAbsolutePath(), e);
            }
            finally {
                if (baseDir != null) {
                    ctx.setCurrentDir(currentDir);
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return;
        }
        if (batchManager.isHeldback(name)) {
            activated = batchManager.activateHeldbackBatch(name);
            if (activated) {
                String msg = name == null ? "Re-activated batch" : "Re-activated batch '" + name + "'";
                ctx.printLine(msg);
                List<BatchedCommand> batch = batchManager.getActiveBatch().getCommands();
                if (!batch.isEmpty()) {
                    for (int i = 0; i < batch.size(); ++i) {
                        BatchedCommand cmd = batch.get(i);
                        ctx.printLine("#" + (i + 1) + ' ' + cmd.getCommand());
                    }
                }
            }
        } else {
            if (name != null) {
                throw new CommandLineException("'" + name + "' not found among the held back batches.");
            }
            activated = batchManager.activateNewBatch();
        }
        if (!activated) {
            throw new CommandLineException("Failed to activate batch.");
        }
    }
}

