/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.util.List;
import org.jboss.as.cli.ArgumentValueConverter;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.parsing.ExpressionBaseState;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.ParsingState;
import org.jboss.as.cli.parsing.ParsingStateCallbackHandler;
import org.jboss.as.cli.parsing.StateParser;
import org.jboss.as.cli.parsing.WordCharacterHandler;
import org.jboss.dmr.ModelNode;

public class ArgumentWithValue
extends ArgumentWithoutValue {
    private static final ParsingState DEFAULT_EXPRESSION_STATE;
    private final CommandLineCompleter valueCompleter;
    private final ArgumentValueConverter valueConverter;
    protected final ParsingState initialState;

    public ArgumentWithValue(CommandHandlerWithArguments handler, String fullName) {
        this(handler, null, ArgumentValueConverter.DEFAULT, fullName, null);
    }

    public ArgumentWithValue(CommandHandlerWithArguments handler, CommandLineCompleter valueCompleter, String fullName) {
        this(handler, valueCompleter, ArgumentValueConverter.DEFAULT, fullName, null);
    }

    public ArgumentWithValue(CommandHandlerWithArguments handler, CommandLineCompleter valueCompleter, ArgumentValueConverter valueConverter, String fullName) {
        this(handler, valueCompleter, valueConverter, fullName, null);
    }

    public ArgumentWithValue(CommandHandlerWithArguments handler, int index, String fullName) {
        this(handler, null, index, fullName);
    }

    public ArgumentWithValue(CommandHandlerWithArguments handler, CommandLineCompleter valueCompleter, int index, String fullName) {
        super(handler, index, fullName);
        this.valueCompleter = valueCompleter;
        this.valueConverter = ArgumentValueConverter.DEFAULT;
        this.initialState = this.initParsingState();
    }

    public ArgumentWithValue(CommandHandlerWithArguments handler, CommandLineCompleter valueCompleter, ArgumentValueConverter valueConverter, String fullName, String shortName) {
        super(handler, fullName, shortName);
        this.valueCompleter = valueCompleter;
        this.valueConverter = valueConverter;
        this.initialState = this.initParsingState();
    }

    protected ParsingState initParsingState() {
        return DEFAULT_EXPRESSION_STATE;
    }

    @Override
    public CommandLineCompleter getValueCompleter() {
        return this.valueCompleter;
    }

    @Override
    public String getValue(ParsedCommandLine args, boolean required) throws CommandFormatException {
        return this.getResolvedValue(args, required);
    }

    public String getResolvedValue(ParsedCommandLine parsedLine, boolean required) throws CommandFormatException {
        String value = this.getOriginalValue(parsedLine, required);
        return ArgumentWithValue.resolveValue(value, this.initialState);
    }

    public static String resolveValue(String value) throws CommandFormatException {
        return ArgumentWithValue.resolveValue(value, DEFAULT_EXPRESSION_STATE);
    }

    public static String resolveValue(String value, ParsingState initialState) throws CommandFormatException {
        if (value == null) {
            return null;
        }
        final StringBuilder buf = new StringBuilder();
        StateParser.parse(value, new ParsingStateCallbackHandler(){

            @Override
            public void enteredState(ParsingContext ctx) throws CommandFormatException {
            }

            @Override
            public void leavingState(ParsingContext ctx) throws CommandFormatException {
            }

            @Override
            public void character(ParsingContext ctx) throws CommandFormatException {
                buf.append(ctx.getCharacter());
            }
        }, initialState);
        return buf.toString();
    }

    public String getOriginalValue(ParsedCommandLine parsedLine, boolean required) throws CommandFormatException {
        String value = null;
        if (parsedLine.hasProperties()) {
            List<String> others;
            if (this.index >= 0 && (others = parsedLine.getOtherProperties()).size() > this.index) {
                return others.get(this.index);
            }
            value = parsedLine.getPropertyValue(this.fullName);
            if (value == null && this.shortName != null) {
                value = parsedLine.getPropertyValue(this.shortName);
            }
        }
        if (required && value == null && !this.isPresent(parsedLine)) {
            StringBuilder buf = new StringBuilder();
            buf.append("Required argument ");
            buf.append('\'').append(this.fullName).append('\'');
            buf.append(" is missing.");
            throw new CommandFormatException(buf.toString());
        }
        return value;
    }

    public ModelNode toModelNode(CommandContext ctx) throws CommandFormatException {
        ParsedCommandLine parsedLine = ctx.getParsedCommandLine();
        String value = this.getOriginalValue(parsedLine, false);
        if (value == null) {
            return null;
        }
        return this.valueConverter.fromString(ctx, value);
    }

    @Override
    public boolean isValueRequired() {
        return true;
    }

    @Override
    public boolean isValueComplete(ParsedCommandLine args) throws CommandFormatException {
        if (!this.isPresent(args)) {
            return false;
        }
        if (this.index >= 0) {
            int size = args.getOtherProperties().size();
            if (this.index >= size) {
                return false;
            }
            if (this.index < size - 1) {
                return true;
            }
            return !args.getOtherProperties().get(this.index).equals(args.getLastParsedPropertyValue());
        }
        if (this.fullName.equals(args.getLastParsedPropertyName())) {
            return false;
        }
        return this.shortName == null || !this.shortName.equals(args.getLastParsedPropertyName());
    }

    public ArgumentValueConverter getValueConverter() {
        return this.valueConverter;
    }

    static {
        ExpressionBaseState state = new ExpressionBaseState("EXPR", true, false);
        state.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_ON);
        DEFAULT_EXPRESSION_STATE = state;
    }
}

