/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.ServiceLoader;
import org.jboss.marshalling.ByteBufferInput;
import org.jboss.marshalling.ByteBufferOutput;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteInputStream;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ByteOutputStream;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Externalizer;
import org.jboss.marshalling.InputStreamByteInput;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.OutputStreamByteOutput;
import org.jboss.marshalling.ProviderDescriptor;
import org.jboss.marshalling.StreamHeader;
import org.jboss.marshalling.Unmarshaller;

public final class Marshalling {
    private static final StreamHeader NULL_STREAM_HEADER = new StreamHeader(){

        @Override
        public void readHeader(ByteInput input) throws IOException {
        }

        @Override
        public void writeHeader(ByteOutput output) throws IOException {
        }

        public String toString() {
            return "Null StreamHeader";
        }
    };
    private static final ClassExternalizerFactory NULL_CLASS_EXTERNALIZER_FACTORY = new ClassExternalizerFactory(){

        @Override
        public Externalizer getExternalizer(Class<?> type) {
            return null;
        }

        public String toString() {
            return "Null class externalizer factory";
        }
    };
    private static final ObjectResolver NULL_OBJECT_RESOLVER = new ObjectResolver(){

        @Override
        public Object readResolve(Object replacement) {
            return replacement;
        }

        @Override
        public Object writeReplace(Object original) {
            return original;
        }

        public String toString() {
            return "Null object resolver";
        }
    };
    private static final ObjectTable NULL_OBJECT_TABLE = new ObjectTable(){

        @Override
        public ObjectTable.Writer getObjectWriter(Object object) {
            return null;
        }

        @Override
        public Object readObject(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
            return null;
        }

        public String toString() {
            return "Null object table";
        }
    };
    private static final ClassTable NULL_CLASS_TABLE = new ClassTable(){

        @Override
        public ClassTable.Writer getClassWriter(Class<?> clazz) {
            return null;
        }

        @Override
        public Class<?> readClass(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
            return null;
        }

        public String toString() {
            return "Null class table";
        }
    };
    private static final OptionalDataExceptionCreateAction OPTIONAL_DATA_EXCEPTION_CREATE_ACTION = new OptionalDataExceptionCreateAction();

    private Marshalling() {
    }

    @Deprecated
    public static MarshallerFactory getMarshallerFactory(String name) {
        return Marshalling.loadMarshallerFactory(AccessController.doPrivileged(new PrivilegedAction<ServiceLoader<ProviderDescriptor>>(){

            @Override
            public ServiceLoader<ProviderDescriptor> run() {
                return ServiceLoader.load(ProviderDescriptor.class);
            }
        }), name);
    }

    public static MarshallerFactory getMarshallerFactory(String name, final ClassLoader classLoader) {
        return Marshalling.loadMarshallerFactory(AccessController.doPrivileged(new PrivilegedAction<ServiceLoader<ProviderDescriptor>>(){

            @Override
            public ServiceLoader<ProviderDescriptor> run() {
                return ServiceLoader.load(ProviderDescriptor.class, classLoader);
            }
        }), name);
    }

    public static MarshallerFactory getProvidedMarshallerFactory(String name) {
        return Marshalling.loadMarshallerFactory(AccessController.doPrivileged(new PrivilegedAction<ServiceLoader<ProviderDescriptor>>(){

            @Override
            public ServiceLoader<ProviderDescriptor> run() {
                return ServiceLoader.load(ProviderDescriptor.class, Marshalling.class.getClassLoader());
            }
        }), name);
    }

    private static MarshallerFactory loadMarshallerFactory(ServiceLoader<ProviderDescriptor> loader, String name) {
        for (ProviderDescriptor descriptor : loader) {
            if (!name.equals(descriptor.getName())) continue;
            return descriptor.getMarshallerFactory();
        }
        return null;
    }

    public static StreamHeader nullStreamHeader() {
        return NULL_STREAM_HEADER;
    }

    public static StreamHeader streamHeader(byte[] headerBytes) {
        return new StaticStreamHeader(headerBytes);
    }

    public static void readFully(ByteInput input, byte[] dest) throws IOException {
        Marshalling.readFully(input, dest, 0, dest.length);
    }

    public static void readFully(ByteInput input, byte[] dest, int offs, int len) throws IOException {
        while (len > 0) {
            int r = input.read(dest, offs, len);
            if (r == -1) {
                throw new EOFException();
            }
            len -= r;
            offs += r;
        }
    }

    public static ByteInput createByteInput(ByteBuffer buffer) {
        return new ByteBufferInput(buffer);
    }

    public static ByteInput createByteInput(InputStream inputStream) {
        return inputStream instanceof ByteInput ? (ByteInput)((Object)inputStream) : new InputStreamByteInput(inputStream);
    }

    public static InputStream createInputStream(ByteInput byteInput) {
        return byteInput instanceof InputStream ? (InputStream)((Object)byteInput) : new ByteInputStream(byteInput);
    }

    public static ByteOutput createByteOutput(ByteBuffer buffer) {
        return new ByteBufferOutput(buffer);
    }

    public static ByteOutput createByteOutput(OutputStream outputStream) {
        return outputStream instanceof ByteOutput ? (ByteOutput)((Object)outputStream) : new OutputStreamByteOutput(outputStream);
    }

    public static OutputStream createOutputStream(ByteOutput byteOutput) {
        return byteOutput instanceof OutputStream ? (OutputStream)((Object)byteOutput) : new ByteOutputStream(byteOutput);
    }

    public static ClassExternalizerFactory nullClassExternalizerFactory() {
        return NULL_CLASS_EXTERNALIZER_FACTORY;
    }

    public static ObjectResolver nullObjectResolver() {
        return NULL_OBJECT_RESOLVER;
    }

    public static ObjectTable nullObjectTable() {
        return NULL_OBJECT_TABLE;
    }

    public static ClassTable nullClassTable() {
        return NULL_CLASS_TABLE;
    }

    public static OptionalDataException createOptionalDataException(boolean eof) {
        OptionalDataException optionalDataException = Marshalling.createOptionalDataException();
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        StackTraceElement[] copyStackTrace = new StackTraceElement[stackTrace.length - 1];
        System.arraycopy(stackTrace, 1, copyStackTrace, 0, copyStackTrace.length);
        optionalDataException.setStackTrace(copyStackTrace);
        optionalDataException.eof = eof;
        return optionalDataException;
    }

    public static OptionalDataException createOptionalDataException(int length) {
        OptionalDataException optionalDataException = Marshalling.createOptionalDataException();
        optionalDataException.length = length;
        return optionalDataException;
    }

    private static OptionalDataException createOptionalDataException() {
        return AccessController.doPrivileged(OPTIONAL_DATA_EXCEPTION_CREATE_ACTION);
    }

    private static final class OptionalDataExceptionCreateAction
    implements PrivilegedAction<OptionalDataException> {
        private final Constructor<OptionalDataException> constructor = AccessController.doPrivileged(new PrivilegedAction<Constructor<OptionalDataException>>(){

            @Override
            public Constructor<OptionalDataException> run() {
                try {
                    Constructor<OptionalDataException> constructor = OptionalDataException.class.getDeclaredConstructor(Boolean.TYPE);
                    constructor.setAccessible(true);
                    return constructor;
                }
                catch (NoSuchMethodException e) {
                    throw new NoSuchMethodError(e.getMessage());
                }
            }
        });

        private OptionalDataExceptionCreateAction() {
        }

        @Override
        public OptionalDataException run() {
            try {
                return this.constructor.newInstance(Boolean.FALSE);
            }
            catch (InstantiationException e) {
                throw new InstantiationError(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Error invoking constructor", e);
            }
        }
    }

    private static final class StaticStreamHeader
    implements StreamHeader,
    Serializable {
        private final byte[] headerBytes;
        private static final long serialVersionUID = 8465784729867667872L;

        public StaticStreamHeader(byte[] bytes) {
            this.headerBytes = bytes;
        }

        @Override
        public void readHeader(ByteInput input) throws IOException {
            byte[] buf = new byte[this.headerBytes.length];
            Marshalling.readFully(input, buf);
            if (!Arrays.equals(buf, this.headerBytes)) {
                throw new StreamCorruptedException("Header is incorrect (expected " + Arrays.toString(this.headerBytes) + ", got " + Arrays.toString(buf) + ")");
            }
        }

        @Override
        public void writeHeader(ByteOutput output) throws IOException {
            output.write(this.headerBytes);
        }

        public String toString() {
            return "static StreamHeader@" + Integer.toHexString(this.hashCode()) + " (" + this.headerBytes.length + " bytes)";
        }
    }
}

