/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.source;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.charset.Charset;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedActionException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.interfaces.ClearPassword;

public final class CommandCredentialSource
implements CredentialSource {
    private final Function<ProcessBuilder, ProcessBuilder> builderProcessor;
    private final PasswordFactory passwordFactory;
    private final AccessControlContext context;
    private final Charset outputCharset;

    CommandCredentialSource(Builder builder) throws GeneralSecurityException {
        this.builderProcessor = builder.builderProcessor;
        this.passwordFactory = builder.passwordFactoryFactory.create();
        this.context = AccessController.getContext();
        this.outputCharset = builder.outputCharset;
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
        return credentialType == PasswordCredential.class ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
        Process process;
        if (credentialType != PasswordCredential.class) {
            return null;
        }
        ProcessBuilder processBuilder = this.builderProcessor.apply(new ProcessBuilder(new String[0]));
        processBuilder.redirectOutput(ProcessBuilder.Redirect.PIPE);
        try {
            process = AccessController.doPrivileged(processBuilder::start);
        }
        catch (PrivilegedActionException e) {
            try {
                throw e.getCause();
            }
            catch (IOException | Error | RuntimeException e2) {
                throw e2;
            }
            catch (Throwable throwable) {
                throw new UndeclaredThrowableException(throwable);
            }
        }
        try {
            int exitCode;
            String line;
            process.getOutputStream().close();
            process.getErrorStream().close();
            InputStream output = process.getInputStream();
            Object object = null;
            try (BufferedReader outputReader = new BufferedReader(new InputStreamReader(output, this.outputCharset));){
                line = outputReader.readLine();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (output != null) {
                    if (object != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        output.close();
                    }
                }
            }
            try {
                exitCode = process.waitFor();
            }
            catch (InterruptedException e) {
                process.destroyForcibly();
                while (process.isAlive()) {
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Thread.currentThread().interrupt();
                throw ElytronMessages.log.credentialCommandInterrupted();
            }
            if (ElytronMessages.log.isTraceEnabled()) {
                ElytronMessages.log.tracef("Exit code from password command = %d", (Object)exitCode);
            }
            if (line == null) {
                object = null;
                return (C)object;
            }
            object = (Credential)credentialType.cast(new PasswordCredential(ClearPassword.createRaw("clear", line.toCharArray())));
            return (C)object;
        }
        finally {
            process.destroyForcibly();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        Charset outputCharset = Charset.defaultCharset();
        SecurityFactory<PasswordFactory> passwordFactoryFactory = () -> PasswordFactory.getInstance("clear");
        Function<ProcessBuilder, ProcessBuilder> builderProcessor = Function.identity();

        Builder() {
        }

        public Builder addCommand(String commandString) {
            Assert.checkNotNullParam("commandString", commandString);
            Assert.checkNotEmptyParam("commandString", commandString);
            this.builderProcessor = this.builderProcessor.andThen(pb -> {
                pb.command().add(commandString);
                return pb;
            });
            return this;
        }

        public Builder addCommand(Supplier<String> commandStringSupplier) {
            Assert.checkNotNullParam("commandString", commandStringSupplier);
            this.builderProcessor = this.builderProcessor.andThen(pb -> {
                String string = (String)commandStringSupplier.get();
                if (string != null && !string.isEmpty()) {
                    pb.command().add(string);
                }
                return pb;
            });
            return this;
        }

        public Builder addCommand(Consumer<Consumer<String>> consumer) {
            Assert.checkNotNullParam("commandString", consumer);
            this.builderProcessor = this.builderProcessor.andThen(pb -> {
                consumer.accept(string -> pb.command().add(Assert.checkNotEmptyParam("string", Assert.checkNotNullParam("string", string))));
                return pb;
            });
            return this;
        }

        public Builder addEnvironment(String key, String value) {
            Assert.checkNotNullParam("key", key);
            Assert.checkNotEmptyParam("key", key);
            Assert.checkNotNullParam("value", value);
            Assert.checkNotEmptyParam("value", value);
            this.builderProcessor = this.builderProcessor.andThen(pb -> {
                pb.environment().put(key, value);
                return pb;
            });
            return this;
        }

        public Builder addEnvironment(Consumer<BiConsumer<String, String>> consumer) {
            Assert.checkNotNullParam("consumer", consumer);
            this.builderProcessor = this.builderProcessor.andThen(pb -> {
                consumer.accept((key, value) -> pb.environment().put(Assert.checkNotEmptyParam("key", Assert.checkNotNullParam("key", key)), Assert.checkNotEmptyParam("value", Assert.checkNotNullParam("value", value))));
                return pb;
            });
            return this;
        }

        public Builder removeEnvironment(String key) {
            Assert.checkNotNullParam("key", key);
            Assert.checkNotEmptyParam("key", key);
            this.builderProcessor = this.builderProcessor.andThen(pb -> {
                pb.environment().remove(key);
                return pb;
            });
            return this;
        }

        public Builder setWorkingDirectory(File directory) {
            Assert.checkNotNullParam("directory", directory);
            this.builderProcessor = this.builderProcessor.andThen(pb -> pb.directory(directory));
            return this;
        }

        public Builder setPasswordFactoryProvider(Provider provider) {
            Assert.checkNotNullParam("provider", provider);
            this.passwordFactoryFactory = () -> PasswordFactory.getInstance("clear", provider);
            return this;
        }

        public Builder setOutputCharset(Charset charset) {
            Assert.checkNotNullParam("charset", charset);
            this.outputCharset = charset;
            return this;
        }

        public CommandCredentialSource build() throws GeneralSecurityException {
            return new CommandCredentialSource(this);
        }
    }
}

