/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.AvailableRealmsCallback;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;
import org.wildfly.security.util.CodePointIterator;

public final class LegacyRealmListSaslServerFactory
extends AbstractDelegatingSaslServerFactory {
    public static final char DEFAULT_DELIMITER = ' ';
    public static final char DEFAULT_ESCAPE_CHARACTER = '\\';
    private final int escapeCharacter;
    private final int[] delims;

    public LegacyRealmListSaslServerFactory(SaslServerFactory delegate) {
        this(delegate, '\\', 32);
    }

    public LegacyRealmListSaslServerFactory(SaslServerFactory delegate, char escapeCharacter, String delims) {
        super(delegate);
        Assert.checkNotNullParam("escapeCharacter", Character.valueOf(escapeCharacter));
        Assert.checkNotNullParam("delims", delims);
        this.escapeCharacter = escapeCharacter;
        this.delims = delims.chars().toArray();
    }

    public LegacyRealmListSaslServerFactory(SaslServerFactory delegate, char escapeCharacter, int ... delims) {
        super(delegate);
        this.escapeCharacter = Assert.checkNotNullParam("escapeCharacter", Character.valueOf(escapeCharacter)).charValue();
        this.delims = Assert.checkNotNullParam("delims", delims);
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        String[] realms = null;
        AvailableRealmsCallback availableRealmsCallback = new AvailableRealmsCallback();
        try {
            cbh.handle(new Callback[]{availableRealmsCallback});
            realms = availableRealmsCallback.getRealmNames();
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
        }
        catch (SaslException e) {
            throw e;
        }
        catch (IOException e) {
            throw ElytronMessages.log.mechCallbackHandlerFailedForUnknownReason(mechanism, e).toSaslException();
        }
        if (realms == null) {
            realms = new String[]{serverName};
        }
        final String realmList = LegacyRealmListSaslServerFactory.arrayToRealmListProperty(realms, this.escapeCharacter, this.delims);
        HashMap<String, Object> newProps = new HashMap<String, Object>(props){

            @Override
            public Object get(Object key) {
                Object value = super.get(key);
                if (key.equals("com.sun.security.sasl.digest.realm") && value == null) {
                    value = realmList;
                    this.put("com.sun.security.sasl.digest.realm", value);
                }
                return value;
            }
        };
        return this.delegate.createSaslServer(mechanism, protocol, serverName, newProps, cbh);
    }

    static String arrayToRealmListProperty(String[] realms) {
        return LegacyRealmListSaslServerFactory.arrayToRealmListProperty(realms, 92, 32);
    }

    static String arrayToRealmListProperty(String[] realms, int escapeCharacter, int ... delims) {
        if (realms == null) {
            return null;
        }
        int[] escapeCharacterAndDelims = Arrays.copyOf(delims, delims.length + 1);
        escapeCharacterAndDelims[escapeCharacterAndDelims.length - 1] = escapeCharacter;
        StringBuilder realmList = new StringBuilder();
        for (int i = 0; i < realms.length; ++i) {
            if (i != 0) {
                LegacyRealmListSaslServerFactory.addDelims(realmList, delims);
            }
            CodePointIterator cpi = CodePointIterator.ofString(realms[i]);
            CodePointIterator di = cpi.delimitedBy(escapeCharacterAndDelims);
            while (cpi.hasNext()) {
                if (di.hasNext()) {
                    di.drainTo(realmList);
                    continue;
                }
                realmList.append((char)escapeCharacter);
                realmList.append((char)cpi.next());
            }
        }
        return realmList.toString();
    }

    private static void addDelims(StringBuilder realmList, int ... delims) {
        for (int delim : delims) {
            realmList.append((char)delim);
        }
    }
}

