/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.deployment;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.AccessRequirements;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.CommandWithPermissions;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.Permissions;
import org.jboss.as.cli.impl.aesh.cmd.security.ControlledCommandActivator;
import org.jboss.as.cli.util.StrictSizeTable;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;
import org.wildfly.core.cli.command.aesh.activator.HideOptionActivator;

@CommandDefinition(name="list", description="", activator=ControlledCommandActivator.class)
public class ListCommand
extends CommandWithPermissions {
    @Deprecated
    @Option(hasValue=false, activator=HideOptionActivator.class)
    private boolean help;
    @Option(name="l", hasValue=false, shortName=108)
    private boolean l;

    ListCommand(CommandContext ctx, Permissions permissions) {
        super(ctx, AccessRequirements.listAccess(permissions), permissions);
    }

    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        if (this.help) {
            commandInvocation.println(commandInvocation.getHelpInfo("deployment list"));
            return CommandResult.SUCCESS;
        }
        ListCommand.listDeployments(commandInvocation.getCommandContext(), this.l);
        return CommandResult.SUCCESS;
    }

    public static void listDeployments(CommandContext ctx, boolean l) throws CommandException {
        if (!l) {
            ListCommand.printList(ctx, Util.getDeployments(ctx.getModelControllerClient()), l);
            return;
        }
        ModelControllerClient client = ctx.getModelControllerClient();
        List<String> names = Util.getDeployments(client);
        if (names.isEmpty()) {
            return;
        }
        StrictSizeTable table = new StrictSizeTable(names.size());
        List descriptions = ListCommand.getDeploymentDescriptions(ctx, names).asPropertyList();
        for (Property prop : descriptions) {
            ModelNode step = prop.getValue();
            if (step.hasDefined("result")) {
                ModelNode result = step.get("result");
                table.addCell("name", result.get("name").asString());
                table.addCell("runtime-name", result.get("runtime-name").asString());
                if (result.has("enabled")) {
                    table.addCell("enabled", result.get("enabled").asString());
                }
                if (result.has("persistent")) {
                    table.addCell("persistent", result.get("persistent").asString());
                }
                if (result.has("status")) {
                    table.addCell("status", result.get("status").asString());
                }
            }
            if (table.isAtLastRow()) continue;
            table.nextRow();
        }
        ctx.printLine(table.toString());
    }

    private static void printList(CommandContext ctx, Collection<String> list, boolean l) {
        if (l) {
            for (String item : list) {
                ctx.printLine(item);
            }
        } else {
            ctx.printColumns(list);
        }
    }

    private static ModelNode getDeploymentDescriptions(CommandContext ctx, List<String> names) throws CommandException {
        ModelNode result;
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        for (String name : names) {
            ModelNode deploymentResource = ListCommand.buildReadDeploymentResourceRequest(name);
            if (deploymentResource == null) continue;
            steps.add(deploymentResource);
        }
        try {
            result = ctx.getModelControllerClient().execute(composite);
        }
        catch (IOException e) {
            throw new CommandException("Failed to execute operation request.", (Throwable)e);
        }
        if (!result.hasDefined("result")) {
            return null;
        }
        return result.get("result");
    }

    private static ModelNode buildReadDeploymentResourceRequest(String name) {
        ModelNode request = new ModelNode();
        ModelNode address = request.get("address");
        address.add("deployment", name);
        request.get("operation").set("read-resource");
        request.get("include-runtime").set(true);
        return request;
    }
}

