/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui.metacommand;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.as.cli.gui.component.DeploymentChooser;
import org.jboss.as.cli.gui.component.HelpButton;
import org.jboss.as.cli.gui.component.ServerGroupChooser;

public class UndeployCommandDialog
extends JDialog
implements ActionListener {
    private CliGuiContext cliGuiCtx;
    private ServerGroupChooser serverGroupChooser;
    private DeploymentChooser deploymentChooser;
    private JCheckBox keepContent = new JCheckBox("Keep Content");
    private JCheckBox allRelevantServerGroups = new JCheckBox("All RelevantServer Groups");

    public UndeployCommandDialog(CliGuiContext cliGuiCtx) {
        super(cliGuiCtx.getMainWindow(), "undeploy", Dialog.ModalityType.APPLICATION_MODAL);
        this.cliGuiCtx = cliGuiCtx;
        this.serverGroupChooser = new ServerGroupChooser(cliGuiCtx);
        this.deploymentChooser = new DeploymentChooser(cliGuiCtx, cliGuiCtx.isStandalone());
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout(10, 10));
        contentPane.add((Component)this.makeInputPanel(), "Center");
        this.setRelevantServerGroupsListener();
        contentPane.add((Component)this.makeButtonPanel(), "South");
        this.pack();
        this.setResizable(false);
    }

    private void setRelevantServerGroupsListener() {
        this.allRelevantServerGroups.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UndeployCommandDialog.this.serverGroupChooser.setEnabled(!UndeployCommandDialog.this.allRelevantServerGroups.isSelected());
            }
        });
    }

    private JPanel makeInputPanel() {
        JPanel inputPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        if (!this.deploymentChooser.hasDeployments()) {
            inputPanel.add((Component)new JLabel("NO DEPLOYMENTS AVAILABLE TO UNDEPLOY"), gbc);
            return inputPanel;
        }
        inputPanel.add((Component)this.deploymentChooser, gbc);
        inputPanel.add((Component)this.keepContent, gbc);
        if (!this.cliGuiCtx.isStandalone()) {
            inputPanel.add(Box.createVerticalStrut(30), gbc);
            inputPanel.add((Component)this.serverGroupChooser, gbc);
            inputPanel.add((Component)this.allRelevantServerGroups, gbc);
        }
        return inputPanel;
    }

    private JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton ok = new JButton("OK");
        ok.addActionListener(this);
        ok.setMnemonic(10);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                UndeployCommandDialog.this.dispose();
            }
        });
        if (this.deploymentChooser.hasDeployments()) {
            buttonPanel.add(ok);
        }
        buttonPanel.add(cancel);
        buttonPanel.add(new HelpButton("undeploy.txt"));
        return buttonPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        StringBuilder builder = new StringBuilder("undeploy  ");
        String name = this.deploymentChooser.getSelectedDeployment();
        builder.append(name);
        if (this.keepContent.isSelected()) {
            builder.append("  --keep-content");
        }
        if (!this.cliGuiCtx.isStandalone()) {
            this.addDomainParams(builder);
        }
        JTextComponent cmdText = this.cliGuiCtx.getCommandLine().getCmdText();
        cmdText.setText(builder.toString());
        this.dispose();
        cmdText.requestFocus();
    }

    private void addDomainParams(StringBuilder builder) {
        if (!this.allRelevantServerGroups.isSelected()) {
            builder.append(this.serverGroupChooser.getCmdLineArg());
        } else {
            builder.append("  --all-relevant-server-groups");
        }
    }
}

