/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.api;

import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class NamedPredicate<T>
implements Predicate<T> {
    private static final Predicate<String> IS_NOT_NEGATED;
    private static final Predicate<String> IS_NEGATED_AND_NOT_SINGLE;
    private final String name;
    private final Predicate<T> predicate;

    public NamedPredicate(String name, Predicate<T> predicate) {
        this.name = name;
        this.predicate = predicate;
    }

    public NamedPredicate(Predicate<T> predicate) {
        this("", predicate);
    }

    @Override
    public boolean test(T t) {
        return this.predicate.test(t);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public NamedPredicate<T> or(Predicate<? super T> otherPredicate) {
        String otherName = "";
        if (otherPredicate instanceof NamedPredicate) {
            otherName = ((NamedPredicate)otherPredicate).getName();
        }
        return new NamedPredicate<T>(this.skipFirstIfAlwaysTrueOrFalse() + otherName, this.predicate.or(otherPredicate));
    }

    @Override
    public NamedPredicate<T> and(Predicate<? super T> otherPredicate) {
        String otherName = "";
        if (otherPredicate instanceof NamedPredicate) {
            otherName = ((NamedPredicate)otherPredicate).getName();
        }
        return new NamedPredicate<T>(this.skipFirstIfAlwaysTrueOrFalse() + otherName, this.predicate.and(otherPredicate));
    }

    @Override
    public NamedPredicate<T> negate() {
        String newName = IS_NEGATED_AND_NOT_SINGLE.test(this.name) || IS_NOT_NEGATED.test(this.name) ? "!(" + this.name + ")" : this.name.substring(2, this.name.length() - 1);
        return new NamedPredicate<T>(newName, this.predicate.negate());
    }

    public String getName() {
        return this.name;
    }

    private String skipFirstIfAlwaysTrueOrFalse() {
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            return this.name + ",";
        }
        return "";
    }

    static {
        Predicate<String> startsWithNegationAndBracket = name -> name.startsWith("!(");
        Predicate<String> endsWithBracket = name -> name.endsWith(")");
        Predicate<String> isNotSingle = name -> name.contains(",");
        IS_NOT_NEGATED = startsWithNegationAndBracket.negate().and(endsWithBracket.negate());
        IS_NEGATED_AND_NOT_SINGLE = IS_NOT_NEGATED.negate().and(isNotSingle);
    }
}

