/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.api.assertion;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import pl.pojo.tester.api.ClassAndFieldPredicatePair;
import pl.pojo.tester.api.FieldPredicate;
import pl.pojo.tester.api.PackageFilter;
import pl.pojo.tester.api.assertion.AbstractAssertion;
import pl.pojo.tester.api.assertion.MultiClassAssertion;
import pl.pojo.tester.api.assertion.SingleClassAssertion;
import pl.pojo.tester.internal.preconditions.ParameterPreconditions;
import pl.pojo.tester.internal.utils.ClassLoader;

public final class Assertions {
    private Assertions() {
    }

    public static AbstractAssertion assertPojoMethodsFor(String qualifiedClassName) {
        ParameterPreconditions.checkNotBlank("qualifiedClassName", qualifiedClassName);
        Class<?> clazz = ClassLoader.loadClass(qualifiedClassName);
        return Assertions.assertPojoMethodsFor(clazz);
    }

    public static AbstractAssertion assertPojoMethodsFor(Class<?> clazz) {
        ParameterPreconditions.checkNotNull("clazz", clazz);
        Predicate<String> predicateAcceptingAllFields = FieldPredicate.includeAllFields(clazz);
        return Assertions.assertPojoMethodsFor(clazz, predicateAcceptingAllFields);
    }

    public static AbstractAssertion assertPojoMethodsFor(String qualifiedClassName, Predicate<String> fieldPredicate) {
        ParameterPreconditions.checkNotBlank("qualifiedClassName", qualifiedClassName);
        ParameterPreconditions.checkNotNull("fieldPredicate", fieldPredicate);
        Class<?> clazz = ClassLoader.loadClass(qualifiedClassName);
        return Assertions.assertPojoMethodsFor(clazz, fieldPredicate);
    }

    public static AbstractAssertion assertPojoMethodsFor(Class<?> clazz, Predicate<String> fieldPredicate) {
        ParameterPreconditions.checkNotNull("clazz", clazz);
        ParameterPreconditions.checkNotNull("fieldPredicate", fieldPredicate);
        ClassAndFieldPredicatePair classAndFieldPredicatePair = new ClassAndFieldPredicatePair(clazz, fieldPredicate);
        return Assertions.assertPojoMethodsFor(classAndFieldPredicatePair, new ClassAndFieldPredicatePair[0]);
    }

    public static AbstractAssertion assertPojoMethodsFor(ClassAndFieldPredicatePair baseClassAndFieldPredicatePair, ClassAndFieldPredicatePair ... classAndFieldPredicatePairs) {
        ParameterPreconditions.checkNotNull("baseClassAndFieldPredicatePair", baseClassAndFieldPredicatePair);
        return new SingleClassAssertion(baseClassAndFieldPredicatePair, classAndFieldPredicatePairs);
    }

    public static AbstractAssertion assertPojoMethodsForAll(String ... qualifiedClassNames) {
        ParameterPreconditions.checkNotBlank("qualifiedClassNames", qualifiedClassNames);
        Class[] classesAndFieldPredicatesPairs = (Class[])Arrays.stream(qualifiedClassNames).map(ClassLoader::loadClass).toArray(Class[]::new);
        return Assertions.assertPojoMethodsForAll(classesAndFieldPredicatesPairs);
    }

    public static AbstractAssertion assertPojoMethodsForAll(PackageFilter packageFilter) {
        ParameterPreconditions.checkNotNull("packageFilter", packageFilter);
        return Assertions.assertPojoMethodsForAll(packageFilter.getClasses());
    }

    public static AbstractAssertion assertPojoMethodsForAll(Class ... classes) {
        ParameterPreconditions.checkNotNull("classes", classes);
        ClassAndFieldPredicatePair[] classesAndFieldPredicatesPairs = (ClassAndFieldPredicatePair[])Arrays.stream(classes).map(ClassAndFieldPredicatePair::new).toArray(ClassAndFieldPredicatePair[]::new);
        return Assertions.assertPojoMethodsForAll(classesAndFieldPredicatesPairs);
    }

    public static AbstractAssertion assertPojoMethodsForAll(ClassAndFieldPredicatePair ... classesAndFieldPredicatesPairs) {
        ParameterPreconditions.checkNotNull("classesAndFieldPredicatesPairs", classesAndFieldPredicatesPairs);
        List<ClassAndFieldPredicatePair> classAndFieldPredicatePairs = Arrays.asList(classesAndFieldPredicatesPairs);
        return new MultiClassAssertion(classAndFieldPredicatePairs);
    }
}

