/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.assertion.hashcode;

import pl.pojo.tester.internal.assertion.hashcode.AbstractHashCodeAssertionError;
import pl.pojo.tester.internal.assertion.hashcode.ConsistentHashCodeAssertionError;
import pl.pojo.tester.internal.assertion.hashcode.EqualHashCodeAssertionError;
import pl.pojo.tester.internal.assertion.hashcode.NotEqualHashCodeAssertionError;

public class HashCodeAssertions {
    private final Object objectUnderAssert;
    private final Class<?> classUnderTest;

    public HashCodeAssertions(Object objectUnderAssert) {
        this.objectUnderAssert = objectUnderAssert;
        this.classUnderTest = objectUnderAssert.getClass();
    }

    public void isConsistent() {
        int result2;
        int result1 = this.objectUnderAssert.hashCode();
        boolean result = result1 == (result2 = this.objectUnderAssert.hashCode());
        this.checkResult(result, new ConsistentHashCodeAssertionError(this.classUnderTest, this.objectUnderAssert, result1, result2));
    }

    public void returnsSameValueFor(Object otherObject) {
        int result2;
        int result1 = this.objectUnderAssert.hashCode();
        boolean result = result1 == (result2 = otherObject.hashCode());
        this.checkResult(result, new EqualHashCodeAssertionError(this.classUnderTest, this.objectUnderAssert, otherObject, result1, result2));
    }

    public void returnsDifferentValueFor(Object otherObject) {
        int result2;
        int result1 = this.objectUnderAssert.hashCode();
        boolean result = result1 == (result2 = otherObject.hashCode());
        this.checkResult(!result, new NotEqualHashCodeAssertionError(this.classUnderTest, this.objectUnderAssert, otherObject, result1, result2));
    }

    private void checkResult(boolean pass, AbstractHashCodeAssertionError errorToThrow) {
        if (!pass) {
            throw errorToThrow;
        }
    }
}

