/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.field;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.pojo.tester.internal.utils.FieldUtils;

public abstract class AbstractFieldValueChanger<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFieldValueChanger.class);
    private AbstractFieldValueChanger next;

    public void changeFieldsValues(Object sourceObject, Object targetObject, List<Field> fieldsToChange) {
        fieldsToChange.forEach(eachField -> this.checkAndChange(sourceObject, targetObject, (Field)eachField));
        this.callNextValuesChanger(sourceObject, targetObject, fieldsToChange);
    }

    public boolean areDifferentValues(T sourceValue, T targetValue) {
        return !Objects.equals(sourceValue, targetValue);
    }

    public AbstractFieldValueChanger attachNext(AbstractFieldValueChanger abstractFieldValueChanger) {
        if (this.next == null) {
            this.next = abstractFieldValueChanger;
            LOGGER.debug("Attaching {} to {}", (Object)abstractFieldValueChanger.getClass().getCanonicalName(), (Object)this.getClass().getCanonicalName());
        } else {
            this.next.attachNext(abstractFieldValueChanger);
        }
        return this;
    }

    public T increaseValue(T value) {
        if (this.canChange(value.getClass())) {
            T increasedValue = this.increaseValue(value, value.getClass());
            LOGGER.debug("Changing value of type {} from '{}' to '{}' ({})", new Object[]{value.getClass(), value, increasedValue, this});
            return increasedValue;
        }
        if (this.next != null) {
            return this.next.increaseValue(value);
        }
        LOGGER.debug("Could not change value '{}' ot type {} by any field value changer", value, value.getClass());
        return value;
    }

    protected abstract T increaseValue(T var1, Class<?> var2);

    protected abstract boolean canChange(Class<?> var1);

    protected Class<T> getGenericTypeClass() {
        Type type = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
    }

    private void checkAndChange(Object sourceObject, Object targetObject, Field field) {
        if (this.canChange(field.getType())) {
            this.changeFieldValue(sourceObject, targetObject, field);
        }
    }

    private void callNextValuesChanger(Object sourceObject, Object targetObject, List<Field> fieldsToChange) {
        if (this.next != null) {
            this.next.changeFieldsValues(sourceObject, targetObject, fieldsToChange);
        }
    }

    private void changeFieldValue(Object sourceObject, Object targetObject, Field field) {
        Object targetFieldValue;
        Object sourceFieldValue = FieldUtils.getValue(sourceObject, field);
        if (!this.areDifferentValues(sourceFieldValue, targetFieldValue = FieldUtils.getValue(targetObject, field))) {
            Object increasedValue = this.increaseValue(targetFieldValue, field.getType());
            LOGGER.debug("Changing value of type {} from '{}' to '{}' ({})", new Object[]{field.getType(), sourceFieldValue, increasedValue, this});
            FieldUtils.setValue(targetObject, field, increasedValue);
        }
    }
}

