/*
 * Decompiled with CFR 0.152.
 */
package pl.pojo.tester.internal.tester;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import pl.pojo.tester.api.ClassAndFieldPredicatePair;
import pl.pojo.tester.internal.field.AbstractFieldValueChanger;
import pl.pojo.tester.internal.tester.AbstractTester;
import pl.pojo.tester.internal.utils.FieldUtils;
import pl.pojo.tester.internal.utils.MethodUtils;

public class GetterTester
extends AbstractTester {
    public GetterTester() {
    }

    public GetterTester(AbstractFieldValueChanger abstractFieldValueChanger) {
        super(abstractFieldValueChanger);
    }

    @Override
    public void test(ClassAndFieldPredicatePair baseClassAndFieldPredicatePair, ClassAndFieldPredicatePair ... classAndFieldPredicatePairs) {
        Class<?> testedClass = baseClassAndFieldPredicatePair.getClazz();
        List<Field> fields = FieldUtils.getFields(testedClass, baseClassAndFieldPredicatePair.getFieldsPredicate());
        List<GetterAndFieldPair> getterAndFieldPairs = this.findGettersForFields(testedClass, fields);
        Object instance = this.objectGenerator.createNewInstance(testedClass);
        getterAndFieldPairs.forEach(eachPair -> this.testGetter((GetterAndFieldPair)eachPair, instance));
    }

    private void testGetter(GetterAndFieldPair eachPair, Object instance) {
        Method getter = eachPair.getGetter();
        Field field = eachPair.getField();
        this.testAssertions.assertThatGetMethodFor(instance).willGetValueFromField(getter, field);
    }

    private List<GetterAndFieldPair> findGettersForFields(Class<?> testedClass, List<Field> fields) {
        return fields.stream().map(fieldName -> this.findSetterAndGetterPairForField(testedClass, (Field)fieldName)).collect(Collectors.toList());
    }

    private GetterAndFieldPair findSetterAndGetterPairForField(Class<?> testedClass, Field field) {
        Method getter = MethodUtils.findGetterFor(testedClass, field);
        return new GetterAndFieldPair(getter, field);
    }

    private class GetterAndFieldPair {
        private final Method getter;
        private final Field field;

        public GetterAndFieldPair(Method getter, Field field) {
            this.getter = getter;
            this.field = field;
        }

        public Method getGetter() {
            return this.getter;
        }

        public Field getField() {
            return this.field;
        }
    }
}

