/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.jruby;

import com.sun.script.jruby.JRubyScriptEngineFactory;
import java.io.File;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.ReadonlyAccessor;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyScriptEngine
extends AbstractScriptEngine
implements Compilable,
Invocable {
    private ScriptEngineFactory factory;
    private Ruby runtime;

    public JRubyScriptEngine() {
        this.init(System.getProperty("com.sun.script.jruby.loadpath"));
    }

    public JRubyScriptEngine(String loadPath) {
        this.init(loadPath);
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        Node node = this.compileScript(script, this.context);
        return new JRubyCompiledScript(node);
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        Node node = this.compileScript(reader, this.context);
        return new JRubyCompiledScript(node);
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.invokeImpl(null, name, args, Object.class);
    }

    @Override
    public Object invokeMethod(Object obj, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        if (obj == null) {
            throw new IllegalArgumentException("script object is null");
        }
        return this.invokeImpl(obj, name, args, Object.class);
    }

    @Override
    public <T> T getInterface(Object obj, Class<T> clazz) {
        if (obj == null) {
            throw new IllegalArgumentException("script object is null");
        }
        return this.makeInterface(obj, clazz);
    }

    @Override
    public <T> T getInterface(Class<T> clazz) {
        return this.makeInterface(null, clazz);
    }

    private <T> T makeInterface(Object obj, Class<T> clazz) {
        if (clazz == null || !clazz.isInterface()) {
            throw new IllegalArgumentException("interface Class expected");
        }
        final Object thiz = obj;
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
                return JRubyScriptEngine.this.invokeImpl(thiz, m.getName(), args, m.getReturnType());
            }
        });
    }

    @Override
    public synchronized Object eval(String str, ScriptContext ctx) throws ScriptException {
        Node node = this.compileScript(str, ctx);
        return this.evalNode(node, ctx);
    }

    @Override
    public synchronized Object eval(Reader reader, ScriptContext ctx) throws ScriptException {
        Node node = this.compileScript(reader, ctx);
        return this.evalNode(node, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptEngineFactory getFactory() {
        JRubyScriptEngine jRubyScriptEngine = this;
        synchronized (jRubyScriptEngine) {
            if (this.factory == null) {
                this.factory = new JRubyScriptEngineFactory();
            }
        }
        return this.factory;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    void setFactory(ScriptEngineFactory factory) {
        this.factory = factory;
    }

    private Object rubyToJava(IRubyObject value) {
        return this.rubyToJava(value, Object.class);
    }

    private Object rubyToJava(IRubyObject value, Class type) {
        return JavaUtil.convertArgument((Object)Java.ruby_to_java((IRubyObject)value, (IRubyObject)value, (Block)Block.NULL_BLOCK), (Class)type);
    }

    private IRubyObject javaToRuby(Object value) {
        if (value instanceof IRubyObject) {
            return (IRubyObject)value;
        }
        IRubyObject result = JavaUtil.convertJavaToRuby((Ruby)this.runtime, (Object)value);
        if (result instanceof JavaObject) {
            return this.runtime.getModule("JavaUtilities").callMethod(this.runtime.getCurrentContext(), "wrap", result);
        }
        return result;
    }

    private synchronized Node compileScript(String script, ScriptContext ctx) throws ScriptException {
        GlobalVariables oldGlobals = this.runtime.getGlobalVariables();
        try {
            this.setGlobalVariables(ctx);
            String filename = (String)ctx.getAttribute("javax.script.filename");
            if (filename == null) {
                filename = "<unknown>";
            }
            Node node = this.runtime.parse(script, filename, null);
            return node;
        }
        catch (Exception exp) {
            throw new ScriptException(exp);
        }
        finally {
            if (oldGlobals != null) {
                this.setGlobalVariables(oldGlobals);
            }
        }
    }

    private synchronized Node compileScript(Reader reader, ScriptContext ctx) throws ScriptException {
        GlobalVariables oldGlobals = this.runtime.getGlobalVariables();
        try {
            this.setGlobalVariables(ctx);
            String filename = (String)ctx.getAttribute("javax.script.filename");
            if (filename == null) {
                filename = "<unknown>";
            }
            Node node = this.runtime.parse(reader, filename, null);
            return node;
        }
        catch (Exception exp) {
            throw new ScriptException(exp);
        }
        finally {
            if (oldGlobals != null) {
                this.setGlobalVariables(oldGlobals);
            }
        }
    }

    private void setGlobalVariables(final ScriptContext ctx) {
        ctx.setAttribute("context", ctx, 100);
        this.setGlobalVariables(new GlobalVariables(this.runtime){
            GlobalVariables parent;
            {
                super(x0);
                this.parent = JRubyScriptEngine.this.runtime.getGlobalVariables();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void define(String name, IAccessor accessor) {
                assert (name != null);
                assert (accessor != null);
                assert (name.startsWith("$"));
                ScriptContext scriptContext = ctx;
                synchronized (scriptContext) {
                    Bindings engineScope = ctx.getBindings(100);
                    engineScope.put(name, (Object)new GlobalVariable(accessor));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void defineReadonly(String name, IAccessor accessor) {
                assert (name != null);
                assert (accessor != null);
                assert (name.startsWith("$"));
                ScriptContext scriptContext = ctx;
                synchronized (scriptContext) {
                    Bindings engineScope = ctx.getBindings(100);
                    engineScope.put(name, (Object)new GlobalVariable((IAccessor)new ReadonlyAccessor(name, accessor)));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isDefined(String name) {
                assert (name != null);
                assert (name.startsWith("$"));
                ScriptContext scriptContext = ctx;
                synchronized (scriptContext) {
                    String modifiedName = name.substring(1);
                    boolean defined = ctx.getAttributesScope(modifiedName) != -1;
                    return defined ? true : this.parent.isDefined(name);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void alias(String name, String oldName) {
                assert (name != null);
                assert (oldName != null);
                assert (name.startsWith("$"));
                assert (oldName.startsWith("$"));
                if (JRubyScriptEngine.this.runtime.getSafeLevel() >= 4) {
                    throw JRubyScriptEngine.this.runtime.newSecurityError("Insecure: can't alias global variable");
                }
                ScriptContext scriptContext = ctx;
                synchronized (scriptContext) {
                    int scope = ctx.getAttributesScope(name);
                    if (scope == -1) {
                        scope = 100;
                    }
                    IRubyObject value = this.get(oldName);
                    ctx.setAttribute(name, JRubyScriptEngine.this.rubyToJava(value), scope);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject get(String name) {
                assert (name != null);
                assert (name.startsWith("$"));
                ScriptContext scriptContext = ctx;
                synchronized (scriptContext) {
                    String modifiedName = name.substring(1);
                    int scope = ctx.getAttributesScope(modifiedName);
                    if (scope == -1) {
                        return this.parent.get(name);
                    }
                    Object obj = ctx.getAttribute(modifiedName, scope);
                    if (obj instanceof IAccessor) {
                        return ((IAccessor)obj).getValue();
                    }
                    return JRubyScriptEngine.this.javaToRuby(obj);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject set(String name, IRubyObject value) {
                assert (name != null);
                assert (name.startsWith("$"));
                if (JRubyScriptEngine.this.runtime.getSafeLevel() >= 4) {
                    throw JRubyScriptEngine.this.runtime.newSecurityError("Insecure: can't change global variable value");
                }
                ScriptContext scriptContext = ctx;
                synchronized (scriptContext) {
                    String modifiedName = name.substring(1);
                    int scope = ctx.getAttributesScope(modifiedName);
                    if (scope == -1) {
                        scope = 100;
                    }
                    IRubyObject oldValue = this.get(name);
                    Object obj = ctx.getAttribute(modifiedName, scope);
                    if (obj instanceof IAccessor) {
                        ((IAccessor)obj).setValue(value);
                    } else {
                        ctx.setAttribute(modifiedName, JRubyScriptEngine.this.rubyToJava(value), scope);
                    }
                    return oldValue;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Iterator getNames() {
                ArrayList<String> list = new ArrayList<String>();
                ScriptContext scriptContext = ctx;
                synchronized (scriptContext) {
                    for (int scope : ctx.getScopes()) {
                        Bindings b = ctx.getBindings(scope);
                        if (b == null) continue;
                        for (String key : b.keySet()) {
                            list.add(key);
                        }
                    }
                }
                Iterator names = this.parent.getNames();
                while (names.hasNext()) {
                    list.add((String)names.next());
                }
                return Collections.unmodifiableList(list).iterator();
            }
        });
    }

    private void setGlobalVariables(GlobalVariables globals) {
        this.runtime.setGlobalVariables(globals);
    }

    private synchronized Object evalNode(Node node, ScriptContext ctx) throws ScriptException {
        GlobalVariables oldGlobals = this.runtime.getGlobalVariables();
        try {
            this.setGlobalVariables(ctx);
            Object object = this.rubyToJava(this.runtime.eval(node));
            return object;
        }
        catch (Exception exp) {
            throw new ScriptException(exp);
        }
        finally {
            if (oldGlobals != null) {
                this.setGlobalVariables(oldGlobals);
            }
        }
    }

    private void init(String loadPath) {
        this.runtime = Ruby.getDefaultInstance();
        if (loadPath == null) {
            loadPath = System.getProperty("java.class.path");
        }
        List<String> list = Arrays.asList(loadPath.split(File.pathSeparator));
        this.runtime.getLoadService().init(list);
        this.runtime.getLoadService().require("java");
    }

    private Object invokeImpl(Object obj, String method, Object[] args, Class returnType) throws ScriptException {
        if (method == null) {
            throw new NullPointerException("method name is null");
        }
        try {
            IRubyObject rubyRecv = obj != null ? JavaUtil.convertJavaToRuby((Ruby)this.runtime, (Object)obj) : this.runtime.getTopSelf();
            IRubyObject[] rubyArgs = JavaUtil.convertJavaArrayToRuby((Ruby)this.runtime, (Object[])args);
            IRubyObject javaUtilities = this.runtime.getObject().getConstant("JavaUtilities");
            for (int i = 0; i < rubyArgs.length; ++i) {
                IRubyObject tmp = rubyArgs[i];
                if (!(tmp instanceof JavaObject)) continue;
                rubyArgs[i] = javaUtilities.callMethod(this.runtime.getCurrentContext(), "wrap", tmp);
            }
            IRubyObject result = rubyRecv.callMethod(this.runtime.getCurrentContext(), method, rubyArgs);
            return this.rubyToJava(result, returnType);
        }
        catch (Exception exp) {
            throw new ScriptException(exp);
        }
    }

    private class JRubyCompiledScript
    extends CompiledScript {
        private Node node;

        JRubyCompiledScript(Node node) {
            this.node = node;
        }

        @Override
        public ScriptEngine getEngine() {
            return JRubyScriptEngine.this;
        }

        @Override
        public Object eval(ScriptContext ctx) throws ScriptException {
            return JRubyScriptEngine.this.evalNode(this.node, ctx);
        }
    }
}

