/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.jruby;

import com.sun.script.jruby.JRubyScriptEngine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;

public class JRubyScriptEngineFactory
implements ScriptEngineFactory {
    private static List<String> names = new ArrayList<String>(2);
    private static List<String> extensions;
    private static List<String> mimeTypes;

    @Override
    public String getEngineName() {
        return "jruby";
    }

    @Override
    public String getEngineVersion() {
        return "0.9.8";
    }

    @Override
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    public String getLanguageName() {
        return "ruby";
    }

    @Override
    public String getLanguageVersion() {
        return "1.8.4";
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        StringBuilder buf = new StringBuilder();
        buf.append('$');
        buf.append(obj);
        buf.append('.');
        buf.append(m);
        buf.append('(');
        if (args.length != 0) {
            int i;
            for (i = 0; i < args.length - 1; ++i) {
                buf.append('$');
                buf.append(args[i] + ", ");
            }
            buf.append('$');
            buf.append(args[i]);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return names;
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        StringBuilder buf = new StringBuilder();
        buf.append("print('");
        int len = toDisplay.length();
        block4: for (int i = 0; i < len; ++i) {
            char ch = toDisplay.charAt(i);
            switch (ch) {
                case '\'': {
                    buf.append("\\'");
                    continue block4;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block4;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        buf.append("')");
        return buf.toString();
    }

    @Override
    public String getParameter(String key) {
        if (key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.name")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (key.equals("THREADING")) {
            return "MULTITHREADED";
        }
        return null;
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < statements.length; ++i) {
            buf.append(statements[i]);
            buf.append(";\n");
        }
        return buf.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        JRubyScriptEngine engine = new JRubyScriptEngine();
        engine.setFactory(this);
        return engine;
    }

    static {
        names.add("jruby");
        names.add("ruby");
        names = Collections.unmodifiableList(names);
        extensions = new ArrayList<String>(1);
        extensions.add("rb");
        extensions = Collections.unmodifiableList(extensions);
        mimeTypes = new ArrayList<String>(0);
        mimeTypes = Collections.unmodifiableList(mimeTypes);
    }
}

