/*
 * Decompiled with CFR 0.152.
 */
package hex.steam;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import hex.steam.SteamMessageSender;
import hex.steam.SteamMessenger;
import hex.steam.SteamWebsocketServlet;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;

public class SteamMessageExchange
implements SteamMessageSender {
    private static final Logger LOG = Logger.getLogger(SteamMessageExchange.class);
    private static final Type MAP_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private final Gson gson = new Gson();
    private final SteamWebsocketServlet servlet;
    private final List<SteamMessenger> messengers;

    SteamMessageExchange(SteamWebsocketServlet servlet) {
        this.servlet = servlet;
        ArrayList<SteamMessenger> res = new ArrayList<SteamMessenger>();
        for (SteamMessenger l : ServiceLoader.load(SteamMessenger.class)) {
            res.add(l);
        }
        this.messengers = Collections.unmodifiableList(res);
    }

    public void onConnected() {
        for (SteamMessenger listener : this.messengers) {
            try {
                listener.onConnectionStateChange(this);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while onConnected event.", (Throwable)e);
            }
        }
    }

    public void onConnectionClosed() {
        for (SteamMessenger listener : this.messengers) {
            try {
                listener.onConnectionStateChange(null);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while onConnectionClosed event.", (Throwable)e);
            }
        }
    }

    public void distributeMessage(String message) {
        Map<String, String> parsedMessage = Collections.unmodifiableMap((Map)this.gson.fromJson(message, MAP_TYPE));
        for (SteamMessenger listener : this.messengers) {
            if (parsedMessage.get("_type") != null) {
                try {
                    listener.onMessage(parsedMessage);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while processing steam message.", (Throwable)e);
                }
                continue;
            }
            LOG.error((Object)("Received message from steam without type: " + message));
        }
    }

    @Override
    public void sendMessage(Map<String, String> message) throws IOException {
        this.servlet.sendMessage(this.gson.toJson(message));
    }
}

