/*
 * Decompiled with CFR 0.152.
 */
package water.k8s;

import java.util.Collection;
import water.init.AbstractEmbeddedH2OConfig;
import water.init.EmbeddedConfigProvider;
import water.k8s.H2OCluster;
import water.k8s.KubernetesEmbeddedConfig;

public class KubernetesEmbeddedConfigProvider
implements EmbeddedConfigProvider {
    private boolean runningOnKubernetes = false;
    private KubernetesEmbeddedConfig kubernetesEmbeddedConfig;

    public void init() {
        this.runningOnKubernetes = H2OCluster.isRunningOnKubernetes();
        if (!this.runningOnKubernetes) {
            return;
        }
        Collection nodeIPs = H2OCluster.resolveNodeIPs();
        this.kubernetesEmbeddedConfig = new KubernetesEmbeddedConfig(nodeIPs);
    }

    public boolean isActive() {
        return this.runningOnKubernetes;
    }

    public AbstractEmbeddedH2OConfig getConfig() {
        return this.kubernetesEmbeddedConfig;
    }
}

