/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.vlayout;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PointF;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;
import com.alibaba.android.vlayout.OrientationHelperEx;
import com.alibaba.android.vlayout.layout.LayoutChunkResult;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

class ExposeLinearLayoutManagerEx
extends LinearLayoutManager {
    private static final String TAG = "ExposeLLManagerEx";
    private static final boolean DEBUG = false;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int INVALID_OFFSET = Integer.MIN_VALUE;
    private static final float MAX_SCROLL_FACTOR = 0.33f;
    protected LayoutState mLayoutState;
    private OrientationHelperEx mOrientationHelper;
    private boolean mLastStackFromEnd;
    private boolean mShouldReverseLayoutExpose = false;
    private int mCurrentPendingScrollPosition = -1;
    private int mPendingScrollPositionOffset = Integer.MIN_VALUE;
    protected Bundle mCurrentPendingSavedState = null;
    private final AnchorInfo mAnchorInfo;
    private final ChildHelperWrapper mChildHelperWrapper;
    private final Method mEnsureLayoutStateMethod;
    protected int recycleOffset;
    private RecyclerView mRecyclerView;
    private Object[] emptyArgs = new Object[0];
    private LayoutChunkResult layoutChunkResultCache = new LayoutChunkResult();
    static final int FLAG_INVALID = 4;
    static final int FLAG_UPDATED = 2;
    private static Field vhField = null;
    private static Method vhSetFlags = null;

    public ExposeLinearLayoutManagerEx(Context context) {
        this(context, 1, false);
    }

    public ExposeLinearLayoutManagerEx(Context context, int orientation, boolean reverseLayout) {
        super(context, orientation, reverseLayout);
        this.mAnchorInfo = new AnchorInfo();
        this.setOrientation(orientation);
        this.setReverseLayout(reverseLayout);
        this.mChildHelperWrapper = new ChildHelperWrapper((RecyclerView.LayoutManager)this);
        try {
            this.mEnsureLayoutStateMethod = LinearLayoutManager.class.getDeclaredMethod("ensureLayoutState", new Class[0]);
            this.mEnsureLayoutStateMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        try {
            Method setItemPrefetchEnabledMethod = RecyclerView.LayoutManager.class.getDeclaredMethod("setItemPrefetchEnabled", Boolean.TYPE);
            if (setItemPrefetchEnabledMethod != null) {
                setItemPrefetchEnabledMethod.invoke((Object)this, false);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public Parcelable onSaveInstanceState() {
        if (this.mCurrentPendingSavedState != null) {
            return new Bundle(this.mCurrentPendingSavedState);
        }
        Bundle state = new Bundle();
        if (this.getChildCount() > 0) {
            boolean didLayoutFromEnd = this.mLastStackFromEnd ^ this.mShouldReverseLayoutExpose;
            state.putBoolean("AnchorLayoutFromEnd", didLayoutFromEnd);
            if (didLayoutFromEnd) {
                View refChild = this.getChildClosestToEndExpose();
                state.putInt("AnchorOffset", this.mOrientationHelper.getEndAfterPadding() - this.mOrientationHelper.getDecoratedEnd(refChild));
                state.putInt("AnchorPosition", this.getPosition(refChild));
            } else {
                View refChild = this.getChildClosestToStartExpose();
                state.putInt("AnchorPosition", this.getPosition(refChild));
                state.putInt("AnchorOffset", this.mOrientationHelper.getDecoratedStart(refChild) - this.mOrientationHelper.getStartAfterPadding());
            }
        } else {
            state.putInt("AnchorPosition", -1);
        }
        return state;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            this.mCurrentPendingSavedState = (Bundle)state;
            this.requestLayout();
        }
    }

    public void setOrientation(int orientation) {
        super.setOrientation(orientation);
        this.mOrientationHelper = null;
    }

    public void setRecycleOffset(int recycleOffset) {
        this.recycleOffset = recycleOffset;
    }

    private void myResolveShouldLayoutReverse() {
        this.mShouldReverseLayoutExpose = this.getOrientation() == 1 || !this.isLayoutRTL() ? this.getReverseLayout() : !this.getReverseLayout();
    }

    public PointF computeScrollVectorForPosition(int targetPosition) {
        int direction;
        if (this.getChildCount() == 0) {
            return null;
        }
        int firstChildPos = this.getPosition(this.getChildAt(0));
        int n = direction = targetPosition < firstChildPos != this.mShouldReverseLayoutExpose ? -1 : 1;
        if (this.getOrientation() == 0) {
            return new PointF((float)direction, 0.0f);
        }
        return new PointF(0.0f, (float)direction);
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        int endOffset;
        int startOffset;
        View existing;
        int extraForStart;
        int extraForEnd;
        boolean before;
        if (this.mCurrentPendingSavedState != null && this.mCurrentPendingSavedState.getInt("AnchorPosition") >= 0) {
            this.mCurrentPendingScrollPosition = this.mCurrentPendingSavedState.getInt("AnchorPosition");
        }
        this.ensureLayoutStateExpose();
        this.mLayoutState.mRecycle = false;
        this.myResolveShouldLayoutReverse();
        this.mAnchorInfo.reset();
        this.mAnchorInfo.mLayoutFromEnd = this.mShouldReverseLayoutExpose ^ this.getStackFromEnd();
        this.updateAnchorInfoForLayoutExpose(state, this.mAnchorInfo);
        int extra = this.getExtraLayoutSpace(state);
        boolean bl = before = state.getTargetScrollPosition() < this.mAnchorInfo.mPosition;
        if (before == this.mShouldReverseLayoutExpose) {
            extraForEnd = extra;
            extraForStart = 0;
        } else {
            extraForStart = extra;
            extraForEnd = 0;
        }
        extraForStart += this.mOrientationHelper.getStartAfterPadding();
        extraForEnd += this.mOrientationHelper.getEndPadding();
        if (state.isPreLayout() && this.mCurrentPendingScrollPosition != -1 && this.mPendingScrollPositionOffset != Integer.MIN_VALUE && (existing = this.findViewByPosition(this.mCurrentPendingScrollPosition)) != null) {
            int upcomingOffset;
            int current;
            if (this.mShouldReverseLayoutExpose) {
                current = this.mOrientationHelper.getEndAfterPadding() - this.mOrientationHelper.getDecoratedEnd(existing);
                upcomingOffset = current - this.mPendingScrollPositionOffset;
            } else {
                current = this.mOrientationHelper.getDecoratedStart(existing) - this.mOrientationHelper.getStartAfterPadding();
                upcomingOffset = this.mPendingScrollPositionOffset - current;
            }
            if (upcomingOffset > 0) {
                extraForStart += upcomingOffset;
            } else {
                extraForEnd -= upcomingOffset;
            }
        }
        this.onAnchorReady(state, this.mAnchorInfo);
        this.detachAndScrapAttachedViews(recycler);
        this.mLayoutState.mIsPreLayout = state.isPreLayout();
        this.mLayoutState.mOnRefresLayout = true;
        if (this.mAnchorInfo.mLayoutFromEnd) {
            this.updateLayoutStateToFillStartExpose(this.mAnchorInfo);
            this.mLayoutState.mExtra = extraForStart;
            this.fill(recycler, this.mLayoutState, state, false);
            startOffset = this.mLayoutState.mOffset;
            if (this.mLayoutState.mAvailable > 0) {
                extraForEnd += this.mLayoutState.mAvailable;
            }
            this.updateLayoutStateToFillEndExpose(this.mAnchorInfo);
            this.mLayoutState.mExtra = extraForEnd;
            this.mLayoutState.mCurrentPosition += this.mLayoutState.mItemDirection;
            this.fill(recycler, this.mLayoutState, state, false);
            endOffset = this.mLayoutState.mOffset;
        } else {
            this.updateLayoutStateToFillEndExpose(this.mAnchorInfo);
            this.mLayoutState.mExtra = extraForEnd;
            this.fill(recycler, this.mLayoutState, state, false);
            endOffset = this.mLayoutState.mOffset;
            if (this.mLayoutState.mAvailable > 0) {
                extraForStart += this.mLayoutState.mAvailable;
            }
            this.updateLayoutStateToFillStartExpose(this.mAnchorInfo);
            this.mLayoutState.mExtra = extraForStart;
            this.mLayoutState.mCurrentPosition += this.mLayoutState.mItemDirection;
            this.fill(recycler, this.mLayoutState, state, false);
            startOffset = this.mLayoutState.mOffset;
        }
        if (this.getChildCount() > 0) {
            int fixOffset;
            if (this.mShouldReverseLayoutExpose ^ this.getStackFromEnd()) {
                fixOffset = this.fixLayoutEndGapExpose(endOffset, recycler, state, true);
                startOffset += fixOffset;
                endOffset += fixOffset;
                fixOffset = this.fixLayoutStartGapExpose(startOffset, recycler, state, false);
                startOffset += fixOffset;
                endOffset += fixOffset;
            } else {
                fixOffset = this.fixLayoutStartGapExpose(startOffset, recycler, state, true);
                startOffset += fixOffset;
                endOffset += fixOffset;
                fixOffset = this.fixLayoutEndGapExpose(endOffset, recycler, state, false);
                startOffset += fixOffset;
                endOffset += fixOffset;
            }
        }
        this.layoutForPredictiveAnimationsExpose(recycler, state, startOffset, endOffset);
        if (!state.isPreLayout()) {
            this.mCurrentPendingScrollPosition = -1;
            this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
            this.mOrientationHelper.onLayoutComplete();
        }
        this.mLastStackFromEnd = this.getStackFromEnd();
        this.mCurrentPendingSavedState = null;
    }

    public void onAnchorReady(RecyclerView.State state, AnchorInfo anchorInfo) {
    }

    public void onAttachedToWindow(RecyclerView view) {
        super.onAttachedToWindow(view);
        this.mRecyclerView = view;
    }

    public void onDetachedFromWindow(RecyclerView view, RecyclerView.Recycler recycler) {
        super.onDetachedFromWindow(view, recycler);
        this.mRecyclerView = null;
    }

    public int findFirstVisibleItemPosition() {
        this.ensureLayoutStateExpose();
        return super.findFirstVisibleItemPosition();
    }

    public int findLastVisibleItemPosition() {
        this.ensureLayoutStateExpose();
        try {
            return super.findLastVisibleItemPosition();
        }
        catch (Exception e) {
            Log.d((String)"LastItem", (String)("itemCount: " + this.getItemCount()));
            Log.d((String)"LastItem", (String)("childCount: " + this.getChildCount()));
            Log.d((String)"LastItem", (String)("child: " + this.getChildAt(this.getChildCount() - 1)));
            Log.d((String)"LastItem", (String)("RV childCount: " + this.mRecyclerView.getChildCount()));
            Log.d((String)"LastItem", (String)("RV child: " + this.mRecyclerView.getChildAt(this.mRecyclerView.getChildCount() - 1)));
            throw e;
        }
    }

    private View myFindReferenceChildClosestToEnd(RecyclerView.State state) {
        return this.mShouldReverseLayoutExpose ? this.myFindFirstReferenceChild(state.getItemCount()) : this.myFindLastReferenceChild(state.getItemCount());
    }

    private View myFindReferenceChildClosestToStart(RecyclerView.State state) {
        return this.mShouldReverseLayoutExpose ? this.myFindLastReferenceChild(state.getItemCount()) : this.myFindFirstReferenceChild(state.getItemCount());
    }

    private View myFindFirstReferenceChild(int itemCount) {
        return this.findReferenceChildInternal(0, this.getChildCount(), itemCount);
    }

    private View myFindLastReferenceChild(int itemCount) {
        return this.findReferenceChildInternal(this.getChildCount() - 1, -1, itemCount);
    }

    private View findReferenceChildInternal(int start, int end, int itemCount) {
        this.ensureLayoutStateExpose();
        View invalidMatch = null;
        View outOfBoundsMatch = null;
        int boundsStart = this.mOrientationHelper.getStartAfterPadding();
        int boundsEnd = this.mOrientationHelper.getEndAfterPadding();
        int diff = end > start ? 1 : -1;
        for (int i = start; i != end; i += diff) {
            View view = this.getChildAt(i);
            int position = this.getPosition(view);
            if (position < 0 || position >= itemCount) continue;
            if (((RecyclerView.LayoutParams)view.getLayoutParams()).isItemRemoved()) {
                if (invalidMatch != null) continue;
                invalidMatch = view;
                continue;
            }
            if (this.mOrientationHelper.getDecoratedStart(view) < boundsEnd && this.mOrientationHelper.getDecoratedEnd(view) >= boundsStart) {
                return view;
            }
            if (outOfBoundsMatch != null) continue;
            outOfBoundsMatch = view;
        }
        return outOfBoundsMatch != null ? outOfBoundsMatch : invalidMatch;
    }

    private void layoutForPredictiveAnimationsExpose(RecyclerView.Recycler recycler, RecyclerView.State state, int startOffset, int endOffset) {
        if (!state.willRunPredictiveAnimations() || this.getChildCount() == 0 || state.isPreLayout() || !this.supportsPredictiveItemAnimations()) {
            return;
        }
        int scrapExtraStart = 0;
        int scrapExtraEnd = 0;
        List scrapList = recycler.getScrapList();
        int scrapSize = scrapList.size();
        int firstChildPos = this.getPosition(this.getChildAt(0));
        for (int i = 0; i < scrapSize; ++i) {
            int direction;
            RecyclerView.ViewHolder scrap = (RecyclerView.ViewHolder)scrapList.get(i);
            int position = scrap.getPosition();
            int n = direction = position < firstChildPos != this.mShouldReverseLayoutExpose ? -1 : 1;
            if (direction == -1) {
                scrapExtraStart += this.mOrientationHelper.getDecoratedMeasurement(scrap.itemView);
                continue;
            }
            scrapExtraEnd += this.mOrientationHelper.getDecoratedMeasurement(scrap.itemView);
        }
        this.mLayoutState.mScrapList = scrapList;
        if (scrapExtraStart > 0) {
            View anchor = this.getChildClosestToStartExpose();
            this.updateLayoutStateToFillStartExpose(this.getPosition(anchor), startOffset);
            this.mLayoutState.mExtra = scrapExtraStart;
            this.mLayoutState.mAvailable = 0;
            this.mLayoutState.mCurrentPosition = this.mLayoutState.mCurrentPosition + (this.mShouldReverseLayoutExpose ? 1 : -1);
            this.mLayoutState.mOnRefresLayout = true;
            this.fill(recycler, this.mLayoutState, state, false);
        }
        if (scrapExtraEnd > 0) {
            View anchor = this.getChildClosestToEndExpose();
            this.updateLayoutStateToFillEndExpose(this.getPosition(anchor), endOffset);
            this.mLayoutState.mExtra = scrapExtraEnd;
            this.mLayoutState.mAvailable = 0;
            this.mLayoutState.mCurrentPosition = this.mLayoutState.mCurrentPosition + (this.mShouldReverseLayoutExpose ? -1 : 1);
            this.mLayoutState.mOnRefresLayout = true;
            this.fill(recycler, this.mLayoutState, state, false);
        }
        this.mLayoutState.mScrapList = null;
    }

    private void updateAnchorInfoForLayoutExpose(RecyclerView.State state, AnchorInfo anchorInfo) {
        if (this.updateAnchorFromPendingDataExpose(state, anchorInfo)) {
            return;
        }
        if (this.updateAnchorFromChildrenExpose(state, anchorInfo)) {
            return;
        }
        anchorInfo.assignCoordinateFromPadding();
        anchorInfo.mPosition = this.getStackFromEnd() ? state.getItemCount() - 1 : 0;
    }

    private boolean updateAnchorFromChildrenExpose(RecyclerView.State state, AnchorInfo anchorInfo) {
        View referenceChild;
        if (this.getChildCount() == 0) {
            return false;
        }
        View focused = this.getFocusedChild();
        if (focused != null && anchorInfo.assignFromViewIfValid(focused, state)) {
            return true;
        }
        if (this.mLastStackFromEnd != this.getStackFromEnd()) {
            return false;
        }
        View view = referenceChild = anchorInfo.mLayoutFromEnd ? this.myFindReferenceChildClosestToEnd(state) : this.myFindReferenceChildClosestToStart(state);
        if (referenceChild != null) {
            anchorInfo.assignFromView(referenceChild);
            if (!state.isPreLayout() && this.supportsPredictiveItemAnimations()) {
                boolean notVisible;
                boolean bl = notVisible = this.mOrientationHelper.getDecoratedStart(referenceChild) >= this.mOrientationHelper.getEndAfterPadding() || this.mOrientationHelper.getDecoratedEnd(referenceChild) < this.mOrientationHelper.getStartAfterPadding();
                if (notVisible) {
                    anchorInfo.mCoordinate = anchorInfo.mLayoutFromEnd ? this.mOrientationHelper.getEndAfterPadding() : this.mOrientationHelper.getStartAfterPadding();
                }
            }
            return true;
        }
        return false;
    }

    private boolean updateAnchorFromPendingDataExpose(RecyclerView.State state, AnchorInfo anchorInfo) {
        if (state.isPreLayout() || this.mCurrentPendingScrollPosition == -1) {
            return false;
        }
        if (this.mCurrentPendingScrollPosition < 0 || this.mCurrentPendingScrollPosition >= state.getItemCount()) {
            this.mCurrentPendingScrollPosition = -1;
            this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
            return false;
        }
        anchorInfo.mPosition = this.mCurrentPendingScrollPosition;
        if (this.mCurrentPendingSavedState != null && this.mCurrentPendingSavedState.getInt("AnchorPosition") >= 0) {
            anchorInfo.mLayoutFromEnd = this.mCurrentPendingSavedState.getBoolean("AnchorLayoutFromEnd");
            anchorInfo.mCoordinate = anchorInfo.mLayoutFromEnd ? this.mOrientationHelper.getEndAfterPadding() - this.mCurrentPendingSavedState.getInt("AnchorOffset") : this.mOrientationHelper.getStartAfterPadding() + this.mCurrentPendingSavedState.getInt("AnchorOffset");
            return true;
        }
        if (this.mPendingScrollPositionOffset == Integer.MIN_VALUE) {
            View child = this.findViewByPosition(this.mCurrentPendingScrollPosition);
            if (child != null) {
                int childSize = this.mOrientationHelper.getDecoratedMeasurement(child);
                if (childSize > this.mOrientationHelper.getTotalSpace()) {
                    anchorInfo.assignCoordinateFromPadding();
                    return true;
                }
                int startGap = this.mOrientationHelper.getDecoratedStart(child) - this.mOrientationHelper.getStartAfterPadding();
                if (startGap < 0) {
                    anchorInfo.mCoordinate = this.mOrientationHelper.getStartAfterPadding();
                    anchorInfo.mLayoutFromEnd = false;
                    return true;
                }
                int endGap = this.mOrientationHelper.getEndAfterPadding() - this.mOrientationHelper.getDecoratedEnd(child);
                if (endGap < 0) {
                    anchorInfo.mCoordinate = this.mOrientationHelper.getEndAfterPadding();
                    anchorInfo.mLayoutFromEnd = true;
                    return true;
                }
                anchorInfo.mCoordinate = anchorInfo.mLayoutFromEnd ? this.mOrientationHelper.getDecoratedEnd(child) + this.mOrientationHelper.getTotalSpaceChange() : this.mOrientationHelper.getDecoratedStart(child);
            } else {
                if (this.getChildCount() > 0) {
                    int pos = this.getPosition(this.getChildAt(0));
                    anchorInfo.mLayoutFromEnd = this.mCurrentPendingScrollPosition < pos == this.mShouldReverseLayoutExpose;
                }
                anchorInfo.assignCoordinateFromPadding();
            }
            return true;
        }
        anchorInfo.mLayoutFromEnd = this.mShouldReverseLayoutExpose;
        anchorInfo.mCoordinate = this.mShouldReverseLayoutExpose ? this.mOrientationHelper.getEndAfterPadding() - this.mPendingScrollPositionOffset : this.mOrientationHelper.getStartAfterPadding() + this.mPendingScrollPositionOffset;
        return true;
    }

    private int fixLayoutEndGapExpose(int endOffset, RecyclerView.Recycler recycler, RecyclerView.State state, boolean canOffsetChildren) {
        int gap = this.mOrientationHelper.getEndAfterPadding() - endOffset;
        int fixOffset = 0;
        if (gap <= 0) {
            return 0;
        }
        fixOffset = -this.scrollInternalBy(-gap, recycler, state);
        if (canOffsetChildren && (gap = this.mOrientationHelper.getEndAfterPadding() - (endOffset += fixOffset)) > 0) {
            this.mOrientationHelper.offsetChildren(gap);
            return gap + fixOffset;
        }
        return fixOffset;
    }

    private int fixLayoutStartGapExpose(int startOffset, RecyclerView.Recycler recycler, RecyclerView.State state, boolean canOffsetChildren) {
        int gap = startOffset - this.mOrientationHelper.getStartAfterPadding();
        int fixOffset = 0;
        if (gap <= 0) {
            return 0;
        }
        fixOffset = -this.scrollInternalBy(gap, recycler, state);
        if (canOffsetChildren && (gap = (startOffset += fixOffset) - this.mOrientationHelper.getStartAfterPadding()) > 0) {
            this.mOrientationHelper.offsetChildren(-gap);
            return fixOffset - gap;
        }
        return fixOffset;
    }

    private void updateLayoutStateToFillEndExpose(AnchorInfo anchorInfo) {
        this.updateLayoutStateToFillEndExpose(anchorInfo.mPosition, anchorInfo.mCoordinate);
    }

    private void updateLayoutStateToFillEndExpose(int itemPosition, int offset) {
        this.mLayoutState.mAvailable = this.mOrientationHelper.getEndAfterPadding() - offset;
        this.mLayoutState.mItemDirection = this.mShouldReverseLayoutExpose ? -1 : 1;
        this.mLayoutState.mCurrentPosition = itemPosition;
        this.mLayoutState.mLayoutDirection = 1;
        this.mLayoutState.mOffset = offset;
        this.mLayoutState.mScrollingOffset = Integer.MIN_VALUE;
    }

    private void updateLayoutStateToFillStartExpose(AnchorInfo anchorInfo) {
        this.updateLayoutStateToFillStartExpose(anchorInfo.mPosition, anchorInfo.mCoordinate);
    }

    private void updateLayoutStateToFillStartExpose(int itemPosition, int offset) {
        this.mLayoutState.mAvailable = offset - this.mOrientationHelper.getStartAfterPadding();
        this.mLayoutState.mCurrentPosition = itemPosition;
        this.mLayoutState.mItemDirection = this.mShouldReverseLayoutExpose ? 1 : -1;
        this.mLayoutState.mLayoutDirection = -1;
        this.mLayoutState.mOffset = offset;
        this.mLayoutState.mScrollingOffset = Integer.MIN_VALUE;
    }

    protected void ensureLayoutStateExpose() {
        if (this.mLayoutState == null) {
            this.mLayoutState = new LayoutState();
        }
        if (this.mOrientationHelper == null) {
            this.mOrientationHelper = OrientationHelperEx.createOrientationHelper(this, this.getOrientation());
        }
        try {
            this.mEnsureLayoutStateMethod.invoke((Object)this, this.emptyArgs);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void scrollToPosition(int position) {
        this.mCurrentPendingScrollPosition = position;
        this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
        if (this.mCurrentPendingSavedState != null) {
            this.mCurrentPendingSavedState.putInt("AnchorPosition", -1);
        }
        this.requestLayout();
    }

    public void scrollToPositionWithOffset(int position, int offset) {
        this.mCurrentPendingScrollPosition = position;
        this.mPendingScrollPositionOffset = offset;
        if (this.mCurrentPendingSavedState != null) {
            this.mCurrentPendingSavedState.putInt("AnchorPosition", -1);
        }
        this.requestLayout();
    }

    protected void updateLayoutStateExpose(int layoutDirection, int requiredSpace, boolean canUseExistingSpace, RecyclerView.State state) {
        int fastScrollSpace;
        this.mLayoutState.mExtra = this.getExtraLayoutSpace(state);
        this.mLayoutState.mLayoutDirection = layoutDirection;
        if (layoutDirection == 1) {
            this.mLayoutState.mExtra += this.mOrientationHelper.getEndPadding();
            View child = this.getChildClosestToEndExpose();
            this.mLayoutState.mItemDirection = this.mShouldReverseLayoutExpose ? -1 : 1;
            this.mLayoutState.mCurrentPosition = this.getPosition(child) + this.mLayoutState.mItemDirection;
            this.mLayoutState.mOffset = this.mOrientationHelper.getDecoratedEnd(child) + this.computeAlignOffset(child, true, false);
            fastScrollSpace = this.mLayoutState.mOffset - this.mOrientationHelper.getEndAfterPadding();
        } else {
            View child = this.getChildClosestToStartExpose();
            this.mLayoutState.mExtra += this.mOrientationHelper.getStartAfterPadding();
            this.mLayoutState.mItemDirection = this.mShouldReverseLayoutExpose ? 1 : -1;
            this.mLayoutState.mCurrentPosition = this.getPosition(child) + this.mLayoutState.mItemDirection;
            this.mLayoutState.mOffset = this.mOrientationHelper.getDecoratedStart(child) + this.computeAlignOffset(child, false, false);
            fastScrollSpace = -this.mLayoutState.mOffset + this.mOrientationHelper.getStartAfterPadding();
        }
        this.mLayoutState.mAvailable = requiredSpace;
        if (canUseExistingSpace) {
            this.mLayoutState.mAvailable -= fastScrollSpace;
        }
        this.mLayoutState.mScrollingOffset = fastScrollSpace;
    }

    protected int computeAlignOffset(View child, boolean isLayoutEnd, boolean useAnchor) {
        return 0;
    }

    protected int computeAlignOffset(int position, boolean isLayoutEnd, boolean useAnchor) {
        return 0;
    }

    public boolean isEnableMarginOverLap() {
        return false;
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.getOrientation() == 1) {
            return 0;
        }
        return this.scrollInternalBy(dx, recycler, state);
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.getOrientation() == 0) {
            return 0;
        }
        return this.scrollInternalBy(dy, recycler, state);
    }

    protected int scrollInternalBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.getChildCount() == 0 || dy == 0) {
            return 0;
        }
        this.mLayoutState.mRecycle = true;
        this.ensureLayoutStateExpose();
        int layoutDirection = dy > 0 ? 1 : -1;
        int absDy = Math.abs(dy);
        this.updateLayoutStateExpose(layoutDirection, absDy, true, state);
        int freeScroll = this.mLayoutState.mScrollingOffset;
        this.mLayoutState.mOnRefresLayout = false;
        int consumed = freeScroll + this.fill(recycler, this.mLayoutState, state, false);
        if (consumed < 0) {
            return 0;
        }
        int scrolled = absDy > consumed ? layoutDirection * consumed : dy;
        this.mOrientationHelper.offsetChildren(-scrolled);
        return scrolled;
    }

    public void assertNotInLayoutOrScroll(String message) {
        if (this.mCurrentPendingSavedState == null) {
            super.assertNotInLayoutOrScroll(message);
        }
    }

    protected void recycleChildren(RecyclerView.Recycler recycler, int startIndex, int endIndex) {
        if (startIndex == endIndex) {
            return;
        }
        if (endIndex > startIndex) {
            for (int i = endIndex - 1; i >= startIndex; --i) {
                this.removeAndRecycleViewAt(i, recycler);
            }
        } else {
            for (int i = startIndex; i > endIndex; --i) {
                this.removeAndRecycleViewAt(i, recycler);
            }
        }
    }

    private void recycleViewsFromStartExpose(RecyclerView.Recycler recycler, int dt) {
        if (dt < 0) {
            return;
        }
        int limit = dt;
        int childCount = this.getChildCount();
        if (this.mShouldReverseLayoutExpose) {
            for (int i = childCount - 1; i >= 0; --i) {
                View child = this.getChildAt(i);
                if (this.mOrientationHelper.getDecoratedEnd(child) + this.recycleOffset <= limit) continue;
                this.recycleChildren(recycler, childCount - 1, i);
                return;
            }
        } else {
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                if (this.mOrientationHelper.getDecoratedEnd(child) + this.recycleOffset <= limit) continue;
                this.recycleChildren(recycler, 0, i);
                return;
            }
        }
    }

    private void recycleViewsFromEndExpose(RecyclerView.Recycler recycler, int dt) {
        int childCount = this.getChildCount();
        if (dt < 0) {
            return;
        }
        int limit = this.mOrientationHelper.getEnd() - dt;
        if (this.mShouldReverseLayoutExpose) {
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                if (this.mOrientationHelper.getDecoratedStart(child) - this.recycleOffset >= limit) continue;
                this.recycleChildren(recycler, 0, i);
                return;
            }
        } else {
            for (int i = childCount - 1; i >= 0; --i) {
                View child = this.getChildAt(i);
                if (this.mOrientationHelper.getDecoratedStart(child) - this.recycleOffset >= limit) continue;
                this.recycleChildren(recycler, childCount - 1, i);
                return;
            }
        }
    }

    private void recycleByLayoutStateExpose(RecyclerView.Recycler recycler, LayoutState layoutState) {
        if (!layoutState.mRecycle) {
            return;
        }
        if (layoutState.mLayoutDirection == -1) {
            this.recycleViewsFromEndExpose(recycler, layoutState.mScrollingOffset);
        } else {
            this.recycleViewsFromStartExpose(recycler, layoutState.mScrollingOffset);
        }
    }

    protected int fill(RecyclerView.Recycler recycler, LayoutState layoutState, RecyclerView.State state, boolean stopOnFocusable) {
        int start = layoutState.mAvailable;
        if (layoutState.mScrollingOffset != Integer.MIN_VALUE) {
            if (layoutState.mAvailable < 0) {
                layoutState.mScrollingOffset += layoutState.mAvailable;
            }
            this.recycleByLayoutStateExpose(recycler, layoutState);
        }
        int remainingSpace = layoutState.mAvailable + layoutState.mExtra + this.recycleOffset;
        while (remainingSpace > 0 && layoutState.hasMore(state)) {
            this.layoutChunkResultCache.resetInternal();
            this.layoutChunk(recycler, state, layoutState, this.layoutChunkResultCache);
            if (this.layoutChunkResultCache.mFinished) break;
            layoutState.mOffset += this.layoutChunkResultCache.mConsumed * layoutState.mLayoutDirection;
            if (!this.layoutChunkResultCache.mIgnoreConsumed || this.mLayoutState.mScrapList != null || !state.isPreLayout()) {
                layoutState.mAvailable -= this.layoutChunkResultCache.mConsumed;
                remainingSpace -= this.layoutChunkResultCache.mConsumed;
            }
            if (layoutState.mScrollingOffset != Integer.MIN_VALUE) {
                layoutState.mScrollingOffset += this.layoutChunkResultCache.mConsumed;
                if (layoutState.mAvailable < 0) {
                    layoutState.mScrollingOffset += layoutState.mAvailable;
                }
                this.recycleByLayoutStateExpose(recycler, layoutState);
            }
            if (!stopOnFocusable || !this.layoutChunkResultCache.mFocusable) continue;
            break;
        }
        return start - layoutState.mAvailable;
    }

    protected void layoutChunk(RecyclerView.Recycler recycler, RecyclerView.State state, LayoutState layoutState, LayoutChunkResult result) {
        int top;
        int bottom;
        int left;
        int right;
        View view = layoutState.next(recycler);
        if (view == null) {
            result.mFinished = true;
            return;
        }
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
        if (layoutState.mScrapList == null) {
            if (this.mShouldReverseLayoutExpose == (layoutState.mLayoutDirection == -1)) {
                this.addView(view);
            } else {
                this.addView(view, 0);
            }
        } else if (this.mShouldReverseLayoutExpose == (layoutState.mLayoutDirection == -1)) {
            this.addDisappearingView(view);
        } else {
            this.addDisappearingView(view, 0);
        }
        this.measureChildWithMargins(view, 0, 0);
        result.mConsumed = this.mOrientationHelper.getDecoratedMeasurement(view);
        if (this.getOrientation() == 1) {
            if (this.isLayoutRTL()) {
                right = this.getWidth() - this.getPaddingRight();
                left = right - this.mOrientationHelper.getDecoratedMeasurementInOther(view);
            } else {
                left = this.getPaddingLeft();
                right = left + this.mOrientationHelper.getDecoratedMeasurementInOther(view);
            }
            if (layoutState.mLayoutDirection == -1) {
                bottom = layoutState.mOffset;
                top = layoutState.mOffset - result.mConsumed;
            } else {
                top = layoutState.mOffset;
                bottom = layoutState.mOffset + result.mConsumed;
            }
        } else {
            top = this.getPaddingTop();
            bottom = top + this.mOrientationHelper.getDecoratedMeasurementInOther(view);
            if (layoutState.mLayoutDirection == -1) {
                right = layoutState.mOffset;
                left = layoutState.mOffset - result.mConsumed;
            } else {
                left = layoutState.mOffset;
                right = layoutState.mOffset + result.mConsumed;
            }
        }
        this.layoutDecorated(view, left + params.leftMargin, top + params.topMargin, right - params.rightMargin, bottom - params.bottomMargin);
        if (params.isItemRemoved() || params.isItemChanged()) {
            result.mIgnoreConsumed = true;
        }
        result.mFocusable = view.isFocusable();
    }

    private int convertFocusDirectionToLayoutDirectionExpose(int focusDirection) {
        int orientation = this.getOrientation();
        switch (focusDirection) {
            case 1: {
                return -1;
            }
            case 2: {
                return 1;
            }
            case 33: {
                return orientation == 1 ? -1 : Integer.MIN_VALUE;
            }
            case 130: {
                return orientation == 1 ? 1 : Integer.MIN_VALUE;
            }
            case 17: {
                return orientation == 0 ? -1 : Integer.MIN_VALUE;
            }
            case 66: {
                return orientation == 0 ? 1 : Integer.MIN_VALUE;
            }
        }
        return Integer.MIN_VALUE;
    }

    private View getChildClosestToStartExpose() {
        return this.getChildAt(this.mShouldReverseLayoutExpose ? this.getChildCount() - 1 : 0);
    }

    private View getChildClosestToEndExpose() {
        return this.getChildAt(this.mShouldReverseLayoutExpose ? 0 : this.getChildCount() - 1);
    }

    public View onFocusSearchFailed(View focused, int focusDirection, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.myResolveShouldLayoutReverse();
        if (this.getChildCount() == 0) {
            return null;
        }
        int layoutDir = this.convertFocusDirectionToLayoutDirectionExpose(focusDirection);
        if (layoutDir == Integer.MIN_VALUE) {
            return null;
        }
        View referenceChild = null;
        referenceChild = layoutDir == -1 ? this.myFindReferenceChildClosestToStart(state) : this.myFindReferenceChildClosestToEnd(state);
        if (referenceChild == null) {
            return null;
        }
        this.ensureLayoutStateExpose();
        int maxScroll = (int)(0.33f * (float)this.mOrientationHelper.getTotalSpace());
        this.updateLayoutStateExpose(layoutDir, maxScroll, false, state);
        this.mLayoutState.mScrollingOffset = Integer.MIN_VALUE;
        this.mLayoutState.mRecycle = false;
        this.mLayoutState.mOnRefresLayout = false;
        this.fill(recycler, this.mLayoutState, state, true);
        View nextFocus = layoutDir == -1 ? this.getChildClosestToStartExpose() : this.getChildClosestToEndExpose();
        if (nextFocus == referenceChild || !nextFocus.isFocusable()) {
            return null;
        }
        return nextFocus;
    }

    private void logChildren() {
        Log.d((String)TAG, (String)"internal representation of views on the screen");
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            Log.d((String)TAG, (String)("item " + this.getPosition(child) + ", coord:" + this.mOrientationHelper.getDecoratedStart(child)));
        }
        Log.d((String)TAG, (String)"==============");
    }

    private void validateChildOrderExpose() {
        Log.d((String)TAG, (String)("validating child count " + this.getChildCount()));
        if (this.getChildCount() < 1) {
            return;
        }
        int lastPos = this.getPosition(this.getChildAt(0));
        int lastScreenLoc = this.mOrientationHelper.getDecoratedStart(this.getChildAt(0));
        if (this.mShouldReverseLayoutExpose) {
            for (int i = 1; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                int pos = this.getPosition(child);
                int screenLoc = this.mOrientationHelper.getDecoratedStart(child);
                if (pos < lastPos) {
                    this.logChildren();
                    throw new RuntimeException("detected invalid position. loc invalid? " + (screenLoc < lastScreenLoc));
                }
                if (screenLoc <= lastScreenLoc) continue;
                this.logChildren();
                throw new RuntimeException("detected invalid location");
            }
        } else {
            for (int i = 1; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                int pos = this.getPosition(child);
                int screenLoc = this.mOrientationHelper.getDecoratedStart(child);
                if (pos < lastPos) {
                    this.logChildren();
                    throw new RuntimeException("detected invalid position. loc invalid? " + (screenLoc < lastScreenLoc));
                }
                if (screenLoc >= lastScreenLoc) continue;
                this.logChildren();
                throw new RuntimeException("detected invalid location");
            }
        }
    }

    public boolean supportsPredictiveItemAnimations() {
        return this.mCurrentPendingSavedState == null && this.mLastStackFromEnd == this.getStackFromEnd();
    }

    protected void addHiddenView(View view, boolean head) {
        int index = head ? 0 : -1;
        this.addView(view, index);
        this.mChildHelperWrapper.hide(view);
    }

    protected void hideView(View view) {
        this.mChildHelperWrapper.hide(view);
    }

    protected void showView(View view) {
        this.mChildHelperWrapper.show(view);
    }

    protected View findHiddenView(int position) {
        return this.mChildHelperWrapper.findHiddenNonRemovedView(position, -1);
    }

    protected boolean isHidden(View view) {
        return this.mChildHelperWrapper.isHidden(view);
    }

    protected static boolean isViewHolderUpdated(RecyclerView.ViewHolder holder) {
        return new ViewHolderWrapper(holder).requireUpdated();
    }

    protected static void attachViewHolder(RecyclerView.LayoutParams params, RecyclerView.ViewHolder holder) {
        try {
            if (vhField == null) {
                vhField = RecyclerView.LayoutParams.class.getDeclaredField("mViewHolder");
            }
            vhField.setAccessible(true);
            vhField.set(params, holder);
            if (vhSetFlags == null) {
                vhSetFlags = RecyclerView.ViewHolder.class.getDeclaredMethod("setFlags", Integer.TYPE, Integer.TYPE);
                vhSetFlags.setAccessible(true);
            }
            vhSetFlags.invoke((Object)holder, 4, 4);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    class ChildHelperWrapper {
        private Object mInnerChildHelper;
        private Method mHideMethod;
        private Method mFindHiddenNonRemovedViewMethod;
        private Method mFindHiddenNonRemovedViewMethod25;
        private Method mIsHideMethod;
        private Field mHiddenViewField;
        private Object mInnerBucket;
        private Method mClearMethod;
        private Field mChildHelperField;
        private List mInnerHiddenView;
        private RecyclerView.LayoutManager mLayoutManager;
        private Object[] args = new Object[1];

        void ensureChildHelper() {
            block5: {
                try {
                    if (this.mInnerChildHelper != null) break block5;
                    this.mInnerChildHelper = this.mChildHelperField.get(this.mLayoutManager);
                    if (this.mInnerChildHelper == null) {
                        return;
                    }
                    Class<?> helperClz = this.mInnerChildHelper.getClass();
                    this.mHideMethod = helperClz.getDeclaredMethod("hide", View.class);
                    this.mHideMethod.setAccessible(true);
                    try {
                        this.mFindHiddenNonRemovedViewMethod = helperClz.getDeclaredMethod("findHiddenNonRemovedView", Integer.TYPE, Integer.TYPE);
                        this.mFindHiddenNonRemovedViewMethod.setAccessible(true);
                    }
                    catch (NoSuchMethodException nsme) {
                        this.mFindHiddenNonRemovedViewMethod25 = helperClz.getDeclaredMethod("findHiddenNonRemovedView", Integer.TYPE);
                        this.mFindHiddenNonRemovedViewMethod25.setAccessible(true);
                    }
                    this.mIsHideMethod = helperClz.getDeclaredMethod("isHidden", View.class);
                    this.mIsHideMethod.setAccessible(true);
                    Field bucketField = helperClz.getDeclaredField("mBucket");
                    bucketField.setAccessible(true);
                    this.mInnerBucket = bucketField.get(this.mInnerChildHelper);
                    this.mClearMethod = this.mInnerBucket.getClass().getDeclaredMethod("clear", Integer.TYPE);
                    this.mClearMethod.setAccessible(true);
                    this.mHiddenViewField = helperClz.getDeclaredField("mHiddenViews");
                    this.mHiddenViewField.setAccessible(true);
                    this.mInnerHiddenView = (List)this.mHiddenViewField.get(this.mInnerChildHelper);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        ChildHelperWrapper(RecyclerView.LayoutManager layoutManager) {
            this.mLayoutManager = layoutManager;
            try {
                this.mChildHelperField = RecyclerView.LayoutManager.class.getDeclaredField("mChildHelper");
                this.mChildHelperField.setAccessible(true);
                this.ensureChildHelper();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        void hide(View view) {
            try {
                this.ensureChildHelper();
                if (this.mInnerHiddenView.indexOf(view) < 0) {
                    this.args[0] = view;
                    this.mHideMethod.invoke(this.mInnerChildHelper, this.args);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        void show(View view) {
            try {
                this.ensureChildHelper();
                int index = ExposeLinearLayoutManagerEx.this.mRecyclerView.indexOfChild(view);
                this.args[0] = index;
                this.mClearMethod.invoke(this.mInnerBucket, this.args);
                if (this.mInnerHiddenView != null) {
                    this.mInnerHiddenView.remove(view);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        View findHiddenNonRemovedView(int position, int type) {
            try {
                this.ensureChildHelper();
                if (this.mFindHiddenNonRemovedViewMethod != null) {
                    return (View)this.mFindHiddenNonRemovedViewMethod.invoke(this.mInnerChildHelper, position, -1);
                }
                if (this.mFindHiddenNonRemovedViewMethod25 != null) {
                    return (View)this.mFindHiddenNonRemovedViewMethod25.invoke(this.mInnerChildHelper, position);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        boolean isHidden(View view) {
            try {
                this.ensureChildHelper();
                this.args[0] = view;
                return (Boolean)this.mIsHideMethod.invoke(this.mInnerChildHelper, this.args);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }
    }

    static class ViewHolderWrapper {
        private RecyclerView.ViewHolder mHolder;
        private static Method mShouldIgnore;
        private static Method mIsInvalid;
        private static Method mIsRemoved;
        private static Method mIsChanged;
        private static Method mSetFlags;

        public static void setFlags(RecyclerView.ViewHolder viewHolder, int flags, int mask) {
            try {
                mSetFlags.invoke((Object)viewHolder, flags, mask);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }

        public ViewHolderWrapper(RecyclerView.ViewHolder holder) {
            this.mHolder = holder;
        }

        boolean isInvalid() {
            if (mIsInvalid == null) {
                return true;
            }
            try {
                return (Boolean)mIsInvalid.invoke((Object)this.mHolder, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return true;
        }

        boolean isRemoved() {
            if (mIsRemoved == null) {
                return true;
            }
            try {
                return (Boolean)mIsRemoved.invoke((Object)this.mHolder, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return true;
        }

        boolean isChanged() {
            if (mIsChanged == null) {
                return true;
            }
            try {
                return (Boolean)mIsChanged.invoke((Object)this.mHolder, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return true;
        }

        void setFlags(int flags, int mask) {
            try {
                mSetFlags.invoke((Object)this.mHolder, flags, mask);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }

        public boolean requireUpdated() {
            return this.isInvalid() || this.isRemoved() || this.isChanged();
        }

        static {
            try {
                mShouldIgnore = RecyclerView.ViewHolder.class.getDeclaredMethod("shouldIgnore", new Class[0]);
                mShouldIgnore.setAccessible(true);
                mIsInvalid = RecyclerView.ViewHolder.class.getDeclaredMethod("isInvalid", new Class[0]);
                mIsInvalid.setAccessible(true);
                mIsRemoved = RecyclerView.ViewHolder.class.getDeclaredMethod("isRemoved", new Class[0]);
                mIsRemoved.setAccessible(true);
                mSetFlags = RecyclerView.ViewHolder.class.getDeclaredMethod("setFlags", Integer.TYPE, Integer.TYPE);
                mSetFlags.setAccessible(true);
                try {
                    mIsChanged = RecyclerView.ViewHolder.class.getDeclaredMethod("isChanged", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    mIsChanged = RecyclerView.ViewHolder.class.getDeclaredMethod("isUpdated", new Class[0]);
                }
                mIsChanged.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }

    protected class AnchorInfo {
        public int mPosition;
        public int mCoordinate;
        public boolean mLayoutFromEnd;

        protected AnchorInfo() {
        }

        void reset() {
            this.mPosition = -1;
            this.mCoordinate = Integer.MIN_VALUE;
            this.mLayoutFromEnd = false;
        }

        void assignCoordinateFromPadding() {
            this.mCoordinate = this.mLayoutFromEnd ? ExposeLinearLayoutManagerEx.this.mOrientationHelper.getEndAfterPadding() : ExposeLinearLayoutManagerEx.this.mOrientationHelper.getStartAfterPadding();
        }

        public String toString() {
            return "AnchorInfo{mPosition=" + this.mPosition + ", mCoordinate=" + this.mCoordinate + ", mLayoutFromEnd=" + this.mLayoutFromEnd + '}';
        }

        public boolean assignFromViewIfValid(View child, RecyclerView.State state) {
            RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)child.getLayoutParams();
            if (!lp.isItemRemoved() && lp.getViewPosition() >= 0 && lp.getViewPosition() < state.getItemCount()) {
                this.assignFromView(child);
                return true;
            }
            return false;
        }

        public void assignFromView(View child) {
            this.mCoordinate = this.mLayoutFromEnd ? ExposeLinearLayoutManagerEx.this.mOrientationHelper.getDecoratedEnd(child) + ExposeLinearLayoutManagerEx.this.computeAlignOffset(child, this.mLayoutFromEnd, true) + ExposeLinearLayoutManagerEx.this.mOrientationHelper.getTotalSpaceChange() : ExposeLinearLayoutManagerEx.this.mOrientationHelper.getDecoratedStart(child) + ExposeLinearLayoutManagerEx.this.computeAlignOffset(child, this.mLayoutFromEnd, true);
            this.mPosition = ExposeLinearLayoutManagerEx.this.getPosition(child);
        }
    }

    public static class LayoutState {
        private Method vhIsRemoved = null;
        static final String TAG = "_ExposeLLayoutManager#LayoutState";
        public static final int LAYOUT_START = -1;
        public static final int LAYOUT_END = 1;
        static final int INVALID_LAYOUT = Integer.MIN_VALUE;
        public static final int ITEM_DIRECTION_HEAD = -1;
        public static final int ITEM_DIRECTION_TAIL = 1;
        static final int SCOLLING_OFFSET_NaN = Integer.MIN_VALUE;
        public boolean mOnRefresLayout = false;
        public boolean mRecycle = true;
        public int mOffset;
        public int mAvailable;
        public int mCurrentPosition;
        public int mItemDirection;
        public int mLayoutDirection;
        public int mScrollingOffset;
        public int mExtra = 0;
        public int mFixOffset = 0;
        public boolean mIsPreLayout = false;
        public List<RecyclerView.ViewHolder> mScrapList = null;

        public LayoutState() {
            try {
                this.vhIsRemoved = RecyclerView.ViewHolder.class.getDeclaredMethod("isRemoved", new Class[0]);
                this.vhIsRemoved.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }

        public boolean hasMore(RecyclerView.State state) {
            return this.mCurrentPosition >= 0 && this.mCurrentPosition < state.getItemCount();
        }

        public View next(RecyclerView.Recycler recycler) {
            if (this.mScrapList != null) {
                return this.nextFromLimitedList();
            }
            View view = recycler.getViewForPosition(this.mCurrentPosition);
            this.mCurrentPosition += this.mItemDirection;
            return view;
        }

        @SuppressLint(value={"LongLogTag"})
        private View nextFromLimitedList() {
            int size = this.mScrapList.size();
            RecyclerView.ViewHolder closest = null;
            int closestDistance = Integer.MAX_VALUE;
            for (int i = 0; i < size; ++i) {
                int distance;
                RecyclerView.ViewHolder viewHolder = this.mScrapList.get(i);
                if (!this.mIsPreLayout) {
                    boolean isRemoved = false;
                    try {
                        isRemoved = (Boolean)this.vhIsRemoved.invoke((Object)viewHolder, new Object[0]);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    if (!this.mIsPreLayout && isRemoved) continue;
                }
                if ((distance = (viewHolder.getPosition() - this.mCurrentPosition) * this.mItemDirection) < 0 || distance >= closestDistance) continue;
                closest = viewHolder;
                closestDistance = distance;
                if (distance == 0) break;
            }
            if (closest != null) {
                this.mCurrentPosition = closest.getPosition() + this.mItemDirection;
                return closest.itemView;
            }
            return null;
        }

        @SuppressLint(value={"LongLogTag"})
        void log() {
            Log.d((String)TAG, (String)("avail:" + this.mAvailable + ", ind:" + this.mCurrentPosition + ", dir:" + this.mItemDirection + ", offset:" + this.mOffset + ", layoutDir:" + this.mLayoutDirection));
        }
    }
}

