/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.vlayout.layout;

import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;
import com.alibaba.android.vlayout.LayoutHelper;
import com.alibaba.android.vlayout.LayoutManagerHelper;
import com.alibaba.android.vlayout.OrientationHelperEx;
import com.alibaba.android.vlayout.R;
import com.alibaba.android.vlayout.VirtualLayoutManager;
import com.alibaba.android.vlayout.layout.LayoutChunkResult;
import com.alibaba.android.vlayout.layout.MarginLayoutHelper;

public abstract class BaseLayoutHelper
extends MarginLayoutHelper {
    private static final String TAG = "BaseLayoutHelper";
    public static boolean DEBUG = false;
    protected Rect mLayoutRegion = new Rect();
    View mLayoutView;
    int mBgColor;
    float mAspectRatio = Float.NaN;
    private int mItemCount = 0;
    private LayoutViewUnBindListener mLayoutViewUnBindListener;
    private LayoutViewBindListener mLayoutViewBindListener;

    @Override
    public boolean isFixLayout() {
        return false;
    }

    public int getBgColor() {
        return this.mBgColor;
    }

    public void setBgColor(int bgColor) {
        this.mBgColor = bgColor;
    }

    public void setAspectRatio(float aspectRatio) {
        this.mAspectRatio = aspectRatio;
    }

    public float getAspectRatio() {
        return this.mAspectRatio;
    }

    @Override
    public int getItemCount() {
        return this.mItemCount;
    }

    @Override
    public void setItemCount(int itemCount) {
        this.mItemCount = itemCount;
    }

    @Nullable
    public final View nextView(RecyclerView.Recycler recycler, VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutManagerHelper helper, LayoutChunkResult result) {
        View view = layoutState.next(recycler);
        if (view == null) {
            if (DEBUG && !layoutState.hasScrapList()) {
                throw new RuntimeException("received null view when unexpected");
            }
            result.mFinished = true;
            return null;
        }
        helper.addChildView(layoutState, view);
        return view;
    }

    @Override
    public void beforeLayout(RecyclerView.Recycler recycler, RecyclerView.State state, LayoutManagerHelper helper) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("call beforeLayout() on " + this.getClass().getSimpleName()));
        }
        if (this.requireLayoutView()) {
            if (this.mLayoutView != null) {
                // empty if block
            }
        } else if (this.mLayoutView != null) {
            if (this.mLayoutViewUnBindListener != null) {
                this.mLayoutViewUnBindListener.onUnbind(this.mLayoutView, this);
            }
            helper.removeChildView(this.mLayoutView);
            this.mLayoutView = null;
        }
    }

    protected boolean isValidScrolled(int scrolled) {
        return scrolled != Integer.MAX_VALUE && scrolled != Integer.MIN_VALUE;
    }

    @Override
    public void afterLayout(RecyclerView.Recycler recycler, RecyclerView.State state, int startPosition, int endPosition, int scrolled, LayoutManagerHelper helper) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("call afterLayout() on " + this.getClass().getSimpleName()));
        }
        if (this.requireLayoutView()) {
            if (this.isValidScrolled(scrolled) && this.mLayoutView != null) {
                this.mLayoutRegion.union(this.mLayoutView.getLeft(), this.mLayoutView.getTop(), this.mLayoutView.getRight(), this.mLayoutView.getBottom());
            }
            if (!this.mLayoutRegion.isEmpty()) {
                if (this.isValidScrolled(scrolled)) {
                    if (helper.getOrientation() == 1) {
                        this.mLayoutRegion.offset(0, -scrolled);
                    } else {
                        this.mLayoutRegion.offset(-scrolled, 0);
                    }
                }
                int contentWidth = helper.getContentWidth();
                int contentHeight = helper.getContentHeight();
                if (helper.getOrientation() == 1 ? this.mLayoutRegion.intersects(0, -contentHeight / 4, contentWidth, contentHeight + contentHeight / 4) : this.mLayoutRegion.intersects(-contentWidth / 4, 0, contentWidth + contentWidth / 4, contentHeight)) {
                    if (this.mLayoutView == null) {
                        this.mLayoutView = helper.generateLayoutView();
                        helper.addOffFlowView(this.mLayoutView, true);
                    }
                    if (helper.getOrientation() == 1) {
                        this.mLayoutRegion.left = helper.getPaddingLeft() + this.mMarginLeft;
                        this.mLayoutRegion.right = helper.getContentWidth() - helper.getPaddingRight() - this.mMarginRight;
                    } else {
                        this.mLayoutRegion.top = helper.getPaddingTop() + this.mMarginTop;
                        this.mLayoutRegion.bottom = helper.getContentWidth() - helper.getPaddingBottom() - this.mMarginBottom;
                    }
                    this.bindLayoutView(this.mLayoutView);
                    return;
                }
                this.mLayoutRegion.set(0, 0, 0, 0);
                if (this.mLayoutView != null) {
                    this.mLayoutView.layout(0, 0, 0, 0);
                }
            }
        }
        if (this.mLayoutView != null) {
            if (this.mLayoutViewUnBindListener != null) {
                this.mLayoutViewUnBindListener.onUnbind(this.mLayoutView, this);
            }
            helper.removeChildView(this.mLayoutView);
            this.mLayoutView = null;
        }
    }

    @Override
    public void adjustLayout(int startPosition, int endPosition, LayoutManagerHelper helper) {
        if (this.requireLayoutView()) {
            View refer = null;
            Rect tempRect = new Rect();
            OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
            for (int i = 0; i < helper.getChildCount(); ++i) {
                refer = helper.getChildAt(i);
                int anchorPos = helper.getPosition(refer);
                if (!this.getRange().contains(anchorPos)) continue;
                if (refer.getVisibility() == 8) {
                    tempRect.setEmpty();
                    continue;
                }
                RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)refer.getLayoutParams();
                if (helper.getOrientation() == 1) {
                    tempRect.union(helper.getDecoratedLeft(refer) - params.leftMargin, orientationHelper.getDecoratedStart(refer), helper.getDecoratedRight(refer) + params.rightMargin, orientationHelper.getDecoratedEnd(refer));
                    continue;
                }
                tempRect.union(orientationHelper.getDecoratedStart(refer), helper.getDecoratedTop(refer) - params.topMargin, orientationHelper.getDecoratedEnd(refer), helper.getDecoratedBottom(refer) + params.bottomMargin);
            }
            if (!tempRect.isEmpty()) {
                this.mLayoutRegion.set(tempRect.left - this.mPaddingLeft, tempRect.top - this.mPaddingTop, tempRect.right + this.mPaddingRight, tempRect.bottom + this.mPaddingBottom);
            } else {
                this.mLayoutRegion.setEmpty();
            }
            if (this.mLayoutView != null) {
                this.mLayoutView.layout(this.mLayoutRegion.left, this.mLayoutRegion.top, this.mLayoutRegion.right, this.mLayoutRegion.bottom);
            }
        }
    }

    @Override
    public final void clear(LayoutManagerHelper helper) {
        if (this.mLayoutView != null) {
            if (this.mLayoutViewUnBindListener != null) {
                this.mLayoutViewUnBindListener.onUnbind(this.mLayoutView, this);
            }
            helper.removeChildView(this.mLayoutView);
            this.mLayoutView = null;
        }
        this.onClear(helper);
    }

    protected void onClear(LayoutManagerHelper helper) {
    }

    @Override
    public boolean requireLayoutView() {
        return this.mBgColor != 0 || this.mLayoutViewBindListener != null;
    }

    public abstract void layoutViews(RecyclerView.Recycler var1, RecyclerView.State var2, VirtualLayoutManager.LayoutStateWrapper var3, LayoutChunkResult var4, LayoutManagerHelper var5);

    @Override
    public void doLayout(RecyclerView.Recycler recycler, RecyclerView.State state, VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutChunkResult result, LayoutManagerHelper helper) {
        this.layoutViews(recycler, state, layoutState, result, helper);
    }

    protected void layoutChildWithMargin(View child, int left, int top, int right, int bottom, @NonNull LayoutManagerHelper helper) {
        this.layoutChildWithMargin(child, left, top, right, bottom, helper, false);
    }

    protected void layoutChildWithMargin(View child, int left, int top, int right, int bottom, @NonNull LayoutManagerHelper helper, boolean addLayoutRegionWithMargin) {
        helper.layoutChildWithMargins(child, left, top, right, bottom);
        if (this.requireLayoutView()) {
            if (addLayoutRegionWithMargin) {
                this.mLayoutRegion.union(left - this.mPaddingLeft - this.mMarginLeft, top - this.mPaddingTop - this.mMarginTop, right + this.mPaddingRight + this.mMarginRight, bottom + this.mPaddingBottom + this.mMarginBottom);
            } else {
                this.mLayoutRegion.union(left - this.mPaddingLeft, top - this.mPaddingTop, right + this.mPaddingRight, bottom + this.mPaddingBottom);
            }
        }
    }

    protected void layoutChild(View child, int left, int top, int right, int bottom, @NonNull LayoutManagerHelper helper) {
        this.layoutChild(child, left, top, right, bottom, helper, false);
    }

    protected void layoutChild(View child, int left, int top, int right, int bottom, @NonNull LayoutManagerHelper helper, boolean addLayoutRegionWithMargin) {
        helper.layoutChild(child, left, top, right, bottom);
        if (this.requireLayoutView()) {
            if (addLayoutRegionWithMargin) {
                this.mLayoutRegion.union(left - this.mPaddingLeft - this.mMarginLeft, top - this.mPaddingTop - this.mMarginTop, right + this.mPaddingRight + this.mMarginRight, bottom + this.mPaddingBottom + this.mMarginBottom);
            } else {
                this.mLayoutRegion.union(left - this.mPaddingLeft, top - this.mPaddingTop, right + this.mPaddingRight, bottom + this.mPaddingBottom);
            }
        }
    }

    public void setLayoutViewHelper(DefaultLayoutViewHelper layoutViewHelper) {
        this.mLayoutViewBindListener = layoutViewHelper;
        this.mLayoutViewUnBindListener = layoutViewHelper;
    }

    public void setLayoutViewBindListener(LayoutViewBindListener bindListener) {
        this.mLayoutViewBindListener = bindListener;
    }

    public void setLayoutViewUnBindListener(LayoutViewUnBindListener layoutViewUnBindListener) {
        this.mLayoutViewUnBindListener = layoutViewUnBindListener;
    }

    @Override
    public void bindLayoutView(@NonNull View layoutView) {
        layoutView.measure(View.MeasureSpec.makeMeasureSpec((int)this.mLayoutRegion.width(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.mLayoutRegion.height(), (int)0x40000000));
        layoutView.layout(this.mLayoutRegion.left, this.mLayoutRegion.top, this.mLayoutRegion.right, this.mLayoutRegion.bottom);
        layoutView.setBackgroundColor(this.mBgColor);
        if (this.mLayoutViewBindListener != null) {
            this.mLayoutViewBindListener.onBind(layoutView, this);
        }
        this.mLayoutRegion.set(0, 0, 0, 0);
    }

    protected void handleStateOnResult(LayoutChunkResult result, View view) {
        if (view == null) {
            return;
        }
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
        if (params.isItemRemoved() || params.isItemChanged()) {
            result.mIgnoreConsumed = true;
        }
        result.mFocusable = result.mFocusable || view.isFocusable();
    }

    protected void handleStateOnResult(LayoutChunkResult result, View[] views) {
        if (views == null) {
            return;
        }
        for (int i = 0; i < views.length; ++i) {
            View view = views[i];
            if (view == null) continue;
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
            if (params.isItemRemoved() || params.isItemChanged()) {
                result.mIgnoreConsumed = true;
            }
            boolean bl = result.mFocusable = result.mFocusable || view.isFocusable();
            if (result.mFocusable && result.mIgnoreConsumed) break;
        }
    }

    protected int computeStartSpace(LayoutManagerHelper helper, boolean layoutInVertical, boolean isLayoutEnd, boolean isOverLapMargin) {
        int startSpace = 0;
        LayoutHelper lastLayoutHelper = null;
        if (helper instanceof VirtualLayoutManager) {
            lastLayoutHelper = ((VirtualLayoutManager)helper).findNeighbourNonfixLayoutHelper(this, isLayoutEnd);
        }
        MarginLayoutHelper lastMarginLayoutHelper = null;
        if (lastLayoutHelper != null && lastLayoutHelper instanceof MarginLayoutHelper) {
            lastMarginLayoutHelper = (MarginLayoutHelper)lastLayoutHelper;
        }
        if (lastLayoutHelper == this) {
            return 0;
        }
        if (!isOverLapMargin) {
            startSpace = layoutInVertical ? this.mMarginTop + this.mPaddingTop : this.mMarginLeft + this.mPaddingLeft;
        } else {
            int offset = 0;
            if (lastMarginLayoutHelper == null) {
                offset = layoutInVertical ? this.mMarginTop + this.mPaddingTop : this.mMarginLeft + this.mPaddingLeft;
            } else {
                int n = layoutInVertical ? (isLayoutEnd ? this.calGap(lastMarginLayoutHelper.mMarginBottom, this.mMarginTop) : this.calGap(lastMarginLayoutHelper.mMarginTop, this.mMarginBottom)) : (offset = isLayoutEnd ? this.calGap(lastMarginLayoutHelper.mMarginRight, this.mMarginLeft) : this.calGap(lastMarginLayoutHelper.mMarginLeft, this.mMarginRight));
            }
            startSpace += layoutInVertical ? (isLayoutEnd ? this.mPaddingTop : this.mPaddingBottom) : (isLayoutEnd ? this.mPaddingLeft : this.mPaddingRight);
            startSpace += offset;
        }
        return startSpace;
    }

    protected int computeEndSpace(LayoutManagerHelper helper, boolean layoutInVertical, boolean isLayoutEnd, boolean isOverLapMargin) {
        int endSpace = layoutInVertical ? this.mMarginBottom + this.mPaddingBottom : this.mMarginLeft + this.mPaddingLeft;
        return endSpace;
    }

    private int calGap(int gap, int currGap) {
        if (gap < currGap) {
            return currGap - gap;
        }
        return 0;
    }

    public static class DefaultLayoutViewHelper
    implements LayoutViewBindListener,
    LayoutViewUnBindListener,
    LayoutViewHelper {
        private final LayoutViewBindListener mLayoutViewBindListener;
        private final LayoutViewUnBindListener mLayoutViewUnBindListener;

        public DefaultLayoutViewHelper(LayoutViewBindListener layoutViewBindListener, LayoutViewUnBindListener layoutViewUnBindListener) {
            this.mLayoutViewBindListener = layoutViewBindListener;
            this.mLayoutViewUnBindListener = layoutViewUnBindListener;
        }

        @Override
        public void onBindViewSuccess(View layoutView, String id2) {
            layoutView.setTag(R.id.tag_layout_helper_bg, (Object)id2);
        }

        @Override
        public void onBind(View layoutView, BaseLayoutHelper baseLayoutHelper) {
            if (layoutView.getTag(R.id.tag_layout_helper_bg) == null && this.mLayoutViewBindListener != null) {
                this.mLayoutViewBindListener.onBind(layoutView, baseLayoutHelper);
            }
        }

        @Override
        public void onUnbind(View layoutView, BaseLayoutHelper baseLayoutHelper) {
            if (this.mLayoutViewUnBindListener != null) {
                this.mLayoutViewUnBindListener.onUnbind(layoutView, baseLayoutHelper);
            }
            layoutView.setTag(R.id.tag_layout_helper_bg, null);
        }
    }

    public static interface LayoutViewHelper {
        public void onBindViewSuccess(View var1, String var2);
    }

    public static interface LayoutViewUnBindListener {
        public void onUnbind(View var1, BaseLayoutHelper var2);
    }

    public static interface LayoutViewBindListener {
        public void onBind(View var1, BaseLayoutHelper var2);
    }
}

