/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.vlayout.layout;

import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.alibaba.android.vlayout.LayoutManagerHelper;
import com.alibaba.android.vlayout.OrientationHelperEx;
import com.alibaba.android.vlayout.VirtualLayoutManager;
import com.alibaba.android.vlayout.layout.AbstractFullFillLayoutHelper;
import com.alibaba.android.vlayout.layout.LayoutChunkResult;
import java.util.Arrays;

public class OnePlusNLayoutHelper
extends AbstractFullFillLayoutHelper {
    private static final String TAG = "OnePlusNLayoutHelper";
    private Rect mAreaRect = new Rect();
    private View[] mChildrenViews;
    private float[] mColWeights = new float[0];
    private float mRowWeight = Float.NaN;

    public OnePlusNLayoutHelper() {
        this.setItemCount(0);
    }

    public OnePlusNLayoutHelper(int itemCount) {
        this(itemCount, 0, 0, 0, 0);
    }

    public OnePlusNLayoutHelper(int itemCount, int leftMargin, int topMargin, int rightMargin, int bottomMargin) {
        this.setItemCount(itemCount);
    }

    @Override
    public void onRangeChange(int start, int end) {
        if (end - start > 6) {
            throw new IllegalArgumentException("OnePlusNLayoutHelper only supports maximum 7 children now");
        }
    }

    public void setColWeights(float[] weights) {
        this.mColWeights = weights != null ? Arrays.copyOf(weights, weights.length) : new float[0];
    }

    public void setRowWeight(float weight) {
        this.mRowWeight = weight;
    }

    @Override
    public void layoutViews(RecyclerView.Recycler recycler, RecyclerView.State state, VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutChunkResult result, LayoutManagerHelper helper) {
        if (this.isOutOfRange(layoutState.getCurrentPosition())) {
            return;
        }
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        boolean layoutInVertical = helper.getOrientation() == 1;
        boolean layoutStart = layoutState.getLayoutDirection() == -1;
        int parentWidth = helper.getContentWidth();
        int parentHeight = helper.getContentHeight();
        int parentHPadding = helper.getPaddingLeft() + helper.getPaddingRight() + this.getHorizontalMargin() + this.getHorizontalPadding();
        int parentVPadding = helper.getPaddingTop() + helper.getPaddingBottom() + this.getVerticalMargin() + this.getVerticalPadding();
        int currentPosition = layoutState.getCurrentPosition();
        if (this.hasHeader && currentPosition == this.getRange().getLower()) {
            View header = this.nextView(recycler, layoutState, helper, result);
            int headerConsumed = this.handleHeader(header, layoutState, result, helper, layoutInVertical, parentWidth, parentHeight, parentHPadding, parentVPadding);
            if (header != null) {
                int left = 0;
                int right = 0;
                int top = 0;
                int bottom = 0;
                if (layoutInVertical) {
                    if (layoutStart) {
                        bottom = layoutState.getOffset();
                        top = bottom - headerConsumed;
                    } else {
                        top = layoutState.getOffset() + (this.mLayoutWithAnchor ? 0 : this.mMarginTop + this.mPaddingTop);
                        bottom = top + headerConsumed;
                    }
                    left = helper.getPaddingLeft() + this.mMarginLeft + this.mPaddingLeft;
                    right = left + orientationHelper.getDecoratedMeasurementInOther(header);
                } else {
                    if (layoutStart) {
                        right = layoutState.getOffset();
                        left = right - headerConsumed;
                    } else {
                        left = layoutState.getOffset() + (this.mLayoutWithAnchor ? 0 : this.mMarginLeft + this.mPaddingLeft);
                        right = left + headerConsumed;
                    }
                    top = helper.getPaddingTop() + this.mMarginTop + this.mPaddingTop;
                    bottom = top + orientationHelper.getDecoratedMeasurementInOther(header);
                }
                this.layoutChildWithMargin(header, left, top, right, bottom, helper);
            }
            result.mConsumed = headerConsumed;
            this.handleStateOnResult(result, header);
        } else if (this.hasFooter && currentPosition == this.getRange().getUpper()) {
            View footer = this.nextView(recycler, layoutState, helper, result);
            int footerConsumed = this.handleFooter(footer, layoutState, result, helper, layoutInVertical, parentWidth, parentHeight, parentHPadding, parentVPadding);
            if (footer != null) {
                int left = 0;
                int right = 0;
                int top = 0;
                int bottom = 0;
                if (layoutInVertical) {
                    if (layoutStart) {
                        bottom = layoutState.getOffset() - (this.mLayoutWithAnchor ? 0 : this.mMarginBottom + this.mPaddingBottom);
                        top = bottom - footerConsumed;
                    } else {
                        top = layoutState.getOffset();
                        bottom = top + footerConsumed;
                    }
                    left = helper.getPaddingLeft() + this.mMarginLeft + this.mPaddingLeft;
                    right = left + orientationHelper.getDecoratedMeasurementInOther(footer);
                } else {
                    if (layoutStart) {
                        right = layoutState.getOffset() - (this.mLayoutWithAnchor ? 0 : this.mMarginRight + this.mPaddingRight);
                        left = right - footerConsumed;
                    } else {
                        left = layoutState.getOffset();
                        right = left + footerConsumed;
                    }
                    top = helper.getPaddingTop() + this.mMarginTop + this.mPaddingTop;
                    bottom = top + orientationHelper.getDecoratedMeasurementInOther(footer);
                }
                this.layoutChildWithMargin(footer, left, top, right, bottom, helper);
            }
            result.mConsumed = footerConsumed;
            this.handleStateOnResult(result, footer);
        } else {
            int count;
            int contentCount = this.getItemCount() - (this.hasHeader ? 1 : 0) - (this.hasFooter ? 1 : 0);
            if (this.mChildrenViews == null || this.mChildrenViews.length != contentCount) {
                this.mChildrenViews = new View[contentCount];
            }
            if ((count = this.getAllChildren(this.mChildrenViews, recycler, layoutState, result, helper)) == 0 || count < contentCount) {
                return;
            }
            int mainConsumed = 0;
            if (contentCount == 1) {
                mainConsumed = this.handleOne(layoutState, result, helper, layoutInVertical, parentWidth, parentHeight, parentHPadding, parentVPadding);
            } else if (contentCount == 2) {
                mainConsumed = this.handleTwo(layoutState, result, helper, layoutInVertical, parentWidth, parentHeight, parentHPadding, parentVPadding);
            } else if (contentCount == 3) {
                mainConsumed = this.handleThree(layoutState, result, helper, layoutInVertical, parentWidth, parentHeight, parentHPadding, parentVPadding);
            } else if (contentCount == 4) {
                mainConsumed = this.handleFour(layoutState, result, helper, layoutInVertical, parentWidth, parentHeight, parentHPadding, parentVPadding);
            } else if (contentCount == 5) {
                mainConsumed = this.handleFive(layoutState, result, helper, layoutInVertical, parentWidth, parentHeight, parentHPadding, parentVPadding);
            }
            result.mConsumed = mainConsumed;
            Arrays.fill(this.mChildrenViews, null);
        }
    }

    private float getViewMainWeight(int index) {
        if (this.mColWeights.length > index) {
            return this.mColWeights[index];
        }
        return Float.NaN;
    }

    @Override
    protected void onClear(LayoutManagerHelper helper) {
        super.onClear(helper);
    }

    @Override
    public void checkAnchorInfo(RecyclerView.State state, VirtualLayoutManager.AnchorInfoWrapper anchorInfo, LayoutManagerHelper helper) {
        super.checkAnchorInfo(state, anchorInfo, helper);
        this.mLayoutWithAnchor = true;
    }

    @Override
    public int computeAlignOffset(int offset, boolean isLayoutEnd, boolean useAnchor, LayoutManagerHelper helper) {
        boolean layoutInVertical;
        boolean bl = layoutInVertical = helper.getOrientation() == 1;
        if (useAnchor) {
            return 0;
        }
        if (isLayoutEnd) {
            if (offset == this.getItemCount() - 1) {
                return layoutInVertical ? this.mMarginBottom + this.mPaddingBottom : this.mMarginRight + this.mPaddingRight;
            }
        } else if (offset == 0) {
            return layoutInVertical ? -this.mMarginTop - this.mPaddingTop : -this.mMarginLeft - this.mPaddingLeft;
        }
        return 0;
    }

    private int handleHeader(View header, VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutChunkResult result, LayoutManagerHelper helper, boolean layoutInVertical, int parentWidth, int parentHeight, int parentHPadding, int parentVPadding) {
        if (header == null) {
            return 0;
        }
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        VirtualLayoutManager.LayoutParams lp = (VirtualLayoutManager.LayoutParams)header.getLayoutParams();
        int widthSpec = helper.getChildMeasureSpec(parentWidth - parentHPadding, layoutInVertical ? -1 : lp.width, !layoutInVertical);
        int heightSpec = helper.getChildMeasureSpec(parentHeight - parentVPadding, layoutInVertical ? lp.height : 0x40000000, layoutInVertical);
        helper.measureChildWithMargins(header, widthSpec, heightSpec);
        return orientationHelper.getDecoratedMeasurement(header);
    }

    private int handleFooter(View footer, VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutChunkResult result, LayoutManagerHelper helper, boolean layoutInVertical, int parentWidth, int parentHeight, int parentHPadding, int parentVPadding) {
        if (footer == null) {
            return 0;
        }
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        VirtualLayoutManager.LayoutParams lp = (VirtualLayoutManager.LayoutParams)footer.getLayoutParams();
        int widthSpec = helper.getChildMeasureSpec(parentWidth - parentHPadding, layoutInVertical ? -1 : lp.width, !layoutInVertical);
        int heightSpec = helper.getChildMeasureSpec(parentHeight - parentVPadding, layoutInVertical ? lp.height : 0x40000000, layoutInVertical);
        helper.measureChildWithMargins(footer, widthSpec, heightSpec);
        return orientationHelper.getDecoratedMeasurement(footer);
    }

    private int handleOne(VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutChunkResult result, LayoutManagerHelper helper, boolean layoutInVertical, int parentWidth, int parentHeight, int parentHPadding, int parentVPadding) {
        float weight;
        int mainConsumed = 0;
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        View view = this.mChildrenViews[0];
        VirtualLayoutManager.LayoutParams lp = (VirtualLayoutManager.LayoutParams)view.getLayoutParams();
        if (!Float.isNaN(this.mAspectRatio)) {
            if (layoutInVertical) {
                lp.height = (int)((float)(parentWidth - parentHPadding) / this.mAspectRatio);
            } else {
                lp.width = (int)((float)(parentHeight - parentVPadding) * this.mAspectRatio);
            }
        }
        int widthSpec = helper.getChildMeasureSpec(Float.isNaN(weight = this.getViewMainWeight(0)) ? parentWidth - parentHPadding : (int)((float)(parentWidth - parentHPadding) * weight), layoutInVertical ? -1 : lp.width, !layoutInVertical);
        int heightSpec = helper.getChildMeasureSpec(parentHeight - parentVPadding, layoutInVertical ? lp.height : 0x40000000, layoutInVertical);
        helper.measureChildWithMargins(view, widthSpec, heightSpec);
        this.calculateRect(mainConsumed += orientationHelper.getDecoratedMeasurement(view), this.mAreaRect, layoutState, helper);
        this.layoutChildWithMargin(view, this.mAreaRect.left, this.mAreaRect.top, this.mAreaRect.right, this.mAreaRect.bottom, helper);
        this.handleStateOnResult(result, view);
        mainConsumed = this.mAreaRect.bottom - this.mAreaRect.top + (this.hasHeader ? 0 : this.mMarginTop + this.mPaddingTop) + (this.hasFooter ? 0 : this.mMarginBottom + this.mPaddingBottom);
        return mainConsumed;
    }

    private int handleTwo(VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutChunkResult result, LayoutManagerHelper helper, boolean layoutInVertical, int parentWidth, int parentHeight, int parentHPadding, int parentVPadding) {
        int mainConsumed = 0;
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        View child1 = this.mChildrenViews[0];
        VirtualLayoutManager.LayoutParams lp1 = (VirtualLayoutManager.LayoutParams)child1.getLayoutParams();
        View child2 = this.mChildrenViews[1];
        VirtualLayoutManager.LayoutParams lp2 = (VirtualLayoutManager.LayoutParams)child2.getLayoutParams();
        float weight1 = this.getViewMainWeight(0);
        float weight2 = this.getViewMainWeight(1);
        if (layoutInVertical) {
            if (!Float.isNaN(this.mAspectRatio)) {
                lp1.height = lp2.height = (int)((float)(parentWidth - parentHPadding) / this.mAspectRatio);
            }
            lp2.topMargin = lp1.topMargin;
            lp2.bottomMargin = lp1.bottomMargin;
            int availableSpace = parentWidth - parentHPadding - lp1.leftMargin - lp1.rightMargin - lp2.leftMargin - lp2.rightMargin;
            int width1 = Float.isNaN(weight1) ? (int)((float)availableSpace / 2.0f + 0.5f) : (int)((float)availableSpace * weight1 / 100.0f + 0.5f);
            int width2 = Float.isNaN(weight2) ? availableSpace - width1 : (int)((float)availableSpace * weight2 / 100.0f + 0.5f);
            helper.measureChildWithMargins(child1, View.MeasureSpec.makeMeasureSpec((int)(width1 + lp1.leftMargin + lp1.rightMargin), (int)0x40000000), helper.getChildMeasureSpec(helper.getContentHeight(), lp1.height, true));
            helper.measureChildWithMargins(child2, View.MeasureSpec.makeMeasureSpec((int)(width2 + lp2.leftMargin + lp2.rightMargin), (int)0x40000000), helper.getChildMeasureSpec(helper.getContentHeight(), lp2.height, true));
            this.calculateRect(mainConsumed += Math.max(orientationHelper.getDecoratedMeasurement(child1), orientationHelper.getDecoratedMeasurement(child2)), this.mAreaRect, layoutState, helper);
            int right1 = this.mAreaRect.left + orientationHelper.getDecoratedMeasurementInOther(child1);
            this.layoutChildWithMargin(child1, this.mAreaRect.left, this.mAreaRect.top, right1, this.mAreaRect.bottom, helper);
            this.layoutChildWithMargin(child2, right1, this.mAreaRect.top, right1 + orientationHelper.getDecoratedMeasurementInOther(child2), this.mAreaRect.bottom, helper);
            mainConsumed = this.mAreaRect.bottom - this.mAreaRect.top + (this.hasHeader ? 0 : this.mMarginTop + this.mPaddingTop) + (this.hasFooter ? 0 : this.mMarginBottom + this.mPaddingBottom);
        } else {
            if (!Float.isNaN(this.mAspectRatio)) {
                lp1.width = lp2.width = (int)((float)(parentHeight - parentVPadding) * this.mAspectRatio);
            }
            int availableSpace = parentHeight - parentVPadding - lp1.topMargin - lp1.bottomMargin - lp2.topMargin - lp2.bottomMargin;
            int height1 = Float.isNaN(weight1) ? (int)((float)availableSpace / 2.0f + 0.5f) : (int)((float)availableSpace * weight1 / 100.0f + 0.5f);
            int height2 = Float.isNaN(weight2) ? availableSpace - height1 : (int)((float)availableSpace * weight2 / 100.0f + 0.5f);
            helper.measureChildWithMargins(child1, helper.getChildMeasureSpec(helper.getContentWidth(), lp1.width, true), View.MeasureSpec.makeMeasureSpec((int)(height1 + lp1.topMargin + lp1.bottomMargin), (int)0x40000000));
            int width = child1.getMeasuredWidth();
            helper.measureChildWithMargins(child2, View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height2 + lp2.topMargin + lp2.bottomMargin), (int)0x40000000));
            this.calculateRect(mainConsumed += Math.max(orientationHelper.getDecoratedMeasurement(child1), orientationHelper.getDecoratedMeasurement(child2)), this.mAreaRect, layoutState, helper);
            int bottom1 = this.mAreaRect.top + orientationHelper.getDecoratedMeasurementInOther(child1);
            this.layoutChildWithMargin(child1, this.mAreaRect.left, this.mAreaRect.top, this.mAreaRect.right, bottom1, helper);
            this.layoutChildWithMargin(child2, this.mAreaRect.left, bottom1, this.mAreaRect.right, bottom1 + orientationHelper.getDecoratedMeasurementInOther(child2), helper);
            mainConsumed = this.mAreaRect.right - this.mAreaRect.left + (this.hasHeader ? 0 : this.mMarginLeft + this.mPaddingRight) + (this.hasFooter ? 0 : this.mMarginRight + this.mPaddingRight);
        }
        this.handleStateOnResult(result, this.mChildrenViews);
        return mainConsumed;
    }

    private int handleThree(VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutChunkResult result, LayoutManagerHelper helper, boolean layoutInVertical, int parentWidth, int parentHeight, int parentHPadding, int parentVPadding) {
        int mainConsumed = 0;
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        View child1 = this.mChildrenViews[0];
        VirtualLayoutManager.LayoutParams lp1 = (VirtualLayoutManager.LayoutParams)child1.getLayoutParams();
        View child2 = helper.getReverseLayout() ? this.mChildrenViews[2] : this.mChildrenViews[1];
        View child3 = helper.getReverseLayout() ? this.mChildrenViews[1] : this.mChildrenViews[2];
        VirtualLayoutManager.LayoutParams lp2 = (VirtualLayoutManager.LayoutParams)child2.getLayoutParams();
        VirtualLayoutManager.LayoutParams lp3 = (VirtualLayoutManager.LayoutParams)child3.getLayoutParams();
        float weight1 = this.getViewMainWeight(0);
        float weight2 = this.getViewMainWeight(1);
        float weight3 = this.getViewMainWeight(2);
        if (layoutInVertical) {
            if (!Float.isNaN(this.mAspectRatio)) {
                lp1.height = (int)((float)(parentWidth - parentHPadding) / this.mAspectRatio);
            }
            lp2.topMargin = lp1.topMargin;
            lp3.bottomMargin = lp1.bottomMargin;
            lp3.leftMargin = lp2.leftMargin;
            lp3.rightMargin = lp2.rightMargin;
            int availableSpace = parentWidth - parentHPadding - lp1.leftMargin - lp1.rightMargin - lp2.leftMargin - lp2.rightMargin;
            int width1 = Float.isNaN(weight1) ? (int)((float)availableSpace / 2.0f + 0.5f) : (int)((float)availableSpace * weight1 / 100.0f + 0.5f);
            int width2 = Float.isNaN(weight2) ? availableSpace - width1 : (int)((double)((float)availableSpace * weight2 / 100.0f) + 0.5);
            int width3 = Float.isNaN(weight3) ? width2 : (int)((double)((float)availableSpace * weight3 / 100.0f) + 0.5);
            helper.measureChildWithMargins(child1, View.MeasureSpec.makeMeasureSpec((int)(width1 + lp1.leftMargin + lp1.rightMargin), (int)0x40000000), helper.getChildMeasureSpec(helper.getContentHeight(), lp1.height, true));
            int height1 = child1.getMeasuredHeight();
            int height2 = Float.isNaN(this.mRowWeight) ? (int)((float)(height1 - lp2.bottomMargin - lp3.topMargin) / 2.0f + 0.5f) : (int)((float)(height1 - lp2.bottomMargin - lp3.topMargin) * this.mRowWeight / 100.0f + 0.5f);
            int height3 = height1 - lp2.bottomMargin - lp3.topMargin - height2;
            helper.measureChildWithMargins(child2, View.MeasureSpec.makeMeasureSpec((int)(width2 + lp2.leftMargin + lp2.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height2 + lp2.topMargin + lp2.bottomMargin), (int)0x40000000));
            helper.measureChildWithMargins(child3, View.MeasureSpec.makeMeasureSpec((int)(width3 + lp3.leftMargin + lp3.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height3 + lp3.topMargin + lp3.bottomMargin), (int)0x40000000));
            this.calculateRect(mainConsumed += Math.max(height1 + lp1.topMargin + lp1.bottomMargin, height2 + lp2.topMargin + lp2.bottomMargin + height3 + lp3.topMargin + lp3.bottomMargin), this.mAreaRect, layoutState, helper);
            int right1 = this.mAreaRect.left + orientationHelper.getDecoratedMeasurementInOther(child1);
            this.layoutChildWithMargin(child1, this.mAreaRect.left, this.mAreaRect.top, right1, this.mAreaRect.bottom, helper);
            int right2 = right1 + orientationHelper.getDecoratedMeasurementInOther(child2);
            this.layoutChildWithMargin(child2, right1, this.mAreaRect.top, right2, this.mAreaRect.top + child2.getMeasuredHeight() + lp2.topMargin + lp2.bottomMargin, helper);
            this.layoutChildWithMargin(child3, right1, this.mAreaRect.bottom - orientationHelper.getDecoratedMeasurement(child3), right1 + orientationHelper.getDecoratedMeasurementInOther(child3), this.mAreaRect.bottom, helper);
            mainConsumed = this.mAreaRect.bottom - this.mAreaRect.top + (this.hasHeader ? 0 : this.mMarginTop + this.mPaddingTop) + (this.hasFooter ? 0 : this.mMarginBottom + this.mPaddingBottom);
        }
        this.handleStateOnResult(result, this.mChildrenViews);
        return mainConsumed;
    }

    private int handleFour(VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutChunkResult result, LayoutManagerHelper helper, boolean layoutInVertical, int parentWidth, int parentHeight, int parentHPadding, int parentVPadding) {
        int mainConsumed = 0;
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        View child1 = this.mChildrenViews[0];
        VirtualLayoutManager.LayoutParams lp1 = (VirtualLayoutManager.LayoutParams)child1.getLayoutParams();
        View child2 = helper.getReverseLayout() ? this.mChildrenViews[3] : this.mChildrenViews[1];
        VirtualLayoutManager.LayoutParams lp2 = (VirtualLayoutManager.LayoutParams)child2.getLayoutParams();
        View child3 = this.mChildrenViews[2];
        VirtualLayoutManager.LayoutParams lp3 = (VirtualLayoutManager.LayoutParams)child3.getLayoutParams();
        View child4 = helper.getReverseLayout() ? this.mChildrenViews[1] : this.mChildrenViews[3];
        VirtualLayoutManager.LayoutParams lp4 = (VirtualLayoutManager.LayoutParams)child4.getLayoutParams();
        float weight1 = this.getViewMainWeight(0);
        float weight2 = this.getViewMainWeight(1);
        float weight3 = this.getViewMainWeight(2);
        float weight4 = this.getViewMainWeight(3);
        if (layoutInVertical) {
            lp2.topMargin = lp1.topMargin;
            lp3.bottomMargin = lp4.bottomMargin = lp1.bottomMargin;
            lp3.leftMargin = lp2.leftMargin;
            lp4.rightMargin = lp2.rightMargin;
            if (!Float.isNaN(this.mAspectRatio)) {
                lp1.height = (int)((float)(parentWidth - parentHPadding) / this.mAspectRatio);
            }
            int availableSpace = parentWidth - parentHPadding - lp1.leftMargin - lp1.rightMargin - lp2.leftMargin - lp2.rightMargin;
            int width1 = Float.isNaN(weight1) ? (int)((float)availableSpace / 2.0f + 0.5f) : (int)((float)availableSpace * weight1 / 100.0f + 0.5f);
            int width2 = Float.isNaN(weight2) ? availableSpace - width1 : (int)((float)availableSpace * weight2 / 100.0f + 0.5f);
            int width3 = Float.isNaN(weight3) ? (int)((float)(width2 - lp3.rightMargin - lp4.leftMargin) / 2.0f + 0.5f) : (int)((float)availableSpace * weight3 / 100.0f + 0.5f);
            int width4 = Float.isNaN(weight4) ? width2 - lp3.rightMargin - lp4.leftMargin - width3 : (int)((float)availableSpace * weight4 / 100.0f + 0.5f);
            helper.measureChildWithMargins(child1, View.MeasureSpec.makeMeasureSpec((int)(width1 + lp1.leftMargin + lp1.rightMargin), (int)0x40000000), helper.getChildMeasureSpec(helper.getContentHeight(), lp1.height, true));
            int height1 = child1.getMeasuredHeight();
            int height2 = Float.isNaN(this.mRowWeight) ? (int)((float)(height1 - lp2.bottomMargin - lp3.topMargin) / 2.0f + 0.5f) : (int)((float)(height1 - lp2.bottomMargin - lp3.topMargin) * this.mRowWeight / 100.0f + 0.5f);
            int height3 = height1 - lp2.bottomMargin - lp3.topMargin - height2;
            helper.measureChildWithMargins(child2, View.MeasureSpec.makeMeasureSpec((int)(width2 + lp2.leftMargin + lp2.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height2 + lp2.topMargin + lp2.bottomMargin), (int)0x40000000));
            helper.measureChildWithMargins(child3, View.MeasureSpec.makeMeasureSpec((int)(width3 + lp3.leftMargin + lp3.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height3 + lp3.topMargin + lp3.bottomMargin), (int)0x40000000));
            helper.measureChildWithMargins(child4, View.MeasureSpec.makeMeasureSpec((int)(width4 + lp4.leftMargin + lp4.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height3 + lp4.topMargin + lp4.bottomMargin), (int)0x40000000));
            this.calculateRect(mainConsumed += Math.max(height1 + lp1.topMargin + lp1.bottomMargin, height2 + lp2.topMargin + lp2.bottomMargin + Math.max(height3 + lp3.topMargin + lp3.bottomMargin, height3 + lp4.topMargin + lp4.bottomMargin)), this.mAreaRect, layoutState, helper);
            int right1 = this.mAreaRect.left + orientationHelper.getDecoratedMeasurementInOther(child1);
            this.layoutChildWithMargin(child1, this.mAreaRect.left, this.mAreaRect.top, right1, this.mAreaRect.bottom, helper);
            int right2 = right1 + orientationHelper.getDecoratedMeasurementInOther(child2);
            this.layoutChildWithMargin(child2, right1, this.mAreaRect.top, right2, this.mAreaRect.top + orientationHelper.getDecoratedMeasurement(child2), helper);
            int right3 = right1 + orientationHelper.getDecoratedMeasurementInOther(child3);
            this.layoutChildWithMargin(child3, right1, this.mAreaRect.bottom - orientationHelper.getDecoratedMeasurement(child3), right3, this.mAreaRect.bottom, helper);
            this.layoutChildWithMargin(child4, right3, this.mAreaRect.bottom - orientationHelper.getDecoratedMeasurement(child4), right3 + orientationHelper.getDecoratedMeasurementInOther(child4), this.mAreaRect.bottom, helper);
            mainConsumed = this.mAreaRect.bottom - this.mAreaRect.top + (this.hasHeader ? 0 : this.mMarginTop + this.mPaddingTop) + (this.hasFooter ? 0 : this.mMarginBottom + this.mPaddingBottom);
        }
        this.handleStateOnResult(result, this.mChildrenViews);
        return mainConsumed;
    }

    private int handleFive(VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutChunkResult result, LayoutManagerHelper helper, boolean layoutInVertical, int parentWidth, int parentHeight, int parentHPadding, int parentVPadding) {
        int mainConsumed = 0;
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        View child1 = this.mChildrenViews[0];
        VirtualLayoutManager.LayoutParams lp1 = (VirtualLayoutManager.LayoutParams)child1.getLayoutParams();
        View child2 = helper.getReverseLayout() ? this.mChildrenViews[4] : this.mChildrenViews[1];
        VirtualLayoutManager.LayoutParams lp2 = (VirtualLayoutManager.LayoutParams)child2.getLayoutParams();
        View child3 = helper.getReverseLayout() ? this.mChildrenViews[3] : this.mChildrenViews[2];
        VirtualLayoutManager.LayoutParams lp3 = (VirtualLayoutManager.LayoutParams)child3.getLayoutParams();
        View child4 = helper.getReverseLayout() ? this.mChildrenViews[2] : this.mChildrenViews[3];
        VirtualLayoutManager.LayoutParams lp4 = (VirtualLayoutManager.LayoutParams)child4.getLayoutParams();
        View child5 = helper.getReverseLayout() ? this.mChildrenViews[1] : this.mChildrenViews[4];
        VirtualLayoutManager.LayoutParams lp5 = (VirtualLayoutManager.LayoutParams)child5.getLayoutParams();
        float weight1 = this.getViewMainWeight(0);
        float weight2 = this.getViewMainWeight(1);
        float weight3 = this.getViewMainWeight(2);
        float weight4 = this.getViewMainWeight(3);
        float weight5 = this.getViewMainWeight(4);
        if (layoutInVertical) {
            lp2.topMargin = lp1.topMargin;
            lp3.bottomMargin = lp4.bottomMargin = lp1.bottomMargin;
            lp3.leftMargin = lp2.leftMargin;
            lp4.rightMargin = lp2.rightMargin;
            lp5.rightMargin = lp2.rightMargin;
            if (!Float.isNaN(this.mAspectRatio)) {
                lp1.height = (int)((float)(parentWidth - parentHPadding) / this.mAspectRatio);
            }
            int availableSpace = parentWidth - parentHPadding - lp1.leftMargin - lp1.rightMargin - lp2.leftMargin - lp2.rightMargin;
            int width1 = Float.isNaN(weight1) ? (int)((float)availableSpace / 2.0f + 0.5f) : (int)((float)availableSpace * weight1 / 100.0f + 0.5f);
            int width2 = Float.isNaN(weight2) ? availableSpace - width1 : (int)((float)availableSpace * weight2 / 100.0f + 0.5f);
            int width3 = Float.isNaN(weight3) ? (int)((float)(width2 - lp3.rightMargin - lp4.leftMargin) / 3.0f + 0.5f) : (int)((float)availableSpace * weight3 / 100.0f + 0.5f);
            int width4 = Float.isNaN(weight4) ? (int)((float)(width2 - lp3.rightMargin - lp4.leftMargin) / 3.0f + 0.5f) : (int)((float)availableSpace * weight4 / 100.0f + 0.5f);
            int width5 = Float.isNaN(weight5) ? width2 - lp3.rightMargin - lp4.leftMargin - width3 - width4 : (int)((float)availableSpace * weight5 / 100.0f + 0.5f);
            helper.measureChildWithMargins(child1, View.MeasureSpec.makeMeasureSpec((int)(width1 + lp1.leftMargin + lp1.rightMargin), (int)0x40000000), helper.getChildMeasureSpec(helper.getContentHeight(), lp1.height, true));
            int height1 = child1.getMeasuredHeight();
            int height2 = Float.isNaN(this.mRowWeight) ? (int)((float)(height1 - lp2.bottomMargin - lp3.topMargin) / 2.0f + 0.5f) : (int)((float)(height1 - lp2.bottomMargin - lp3.topMargin) * this.mRowWeight / 100.0f + 0.5f);
            int height3 = height1 - lp2.bottomMargin - lp3.topMargin - height2;
            helper.measureChildWithMargins(child2, View.MeasureSpec.makeMeasureSpec((int)(width2 + lp2.leftMargin + lp2.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height2 + lp2.topMargin + lp2.bottomMargin), (int)0x40000000));
            helper.measureChildWithMargins(child3, View.MeasureSpec.makeMeasureSpec((int)(width3 + lp3.leftMargin + lp3.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height3 + lp3.topMargin + lp3.bottomMargin), (int)0x40000000));
            helper.measureChildWithMargins(child4, View.MeasureSpec.makeMeasureSpec((int)(width4 + lp4.leftMargin + lp4.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height3 + lp4.topMargin + lp4.bottomMargin), (int)0x40000000));
            helper.measureChildWithMargins(child5, View.MeasureSpec.makeMeasureSpec((int)(width5 + lp5.leftMargin + lp5.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height3 + lp5.topMargin + lp5.bottomMargin), (int)0x40000000));
            this.calculateRect(mainConsumed += Math.max(height1 + lp1.topMargin + lp1.bottomMargin, height2 + lp2.topMargin + lp2.bottomMargin + Math.max(height3 + lp3.topMargin + lp3.bottomMargin, height3 + lp4.topMargin + lp4.bottomMargin)), this.mAreaRect, layoutState, helper);
            int right1 = this.mAreaRect.left + orientationHelper.getDecoratedMeasurementInOther(child1);
            this.layoutChildWithMargin(child1, this.mAreaRect.left, this.mAreaRect.top, right1, this.mAreaRect.bottom, helper);
            int right2 = right1 + orientationHelper.getDecoratedMeasurementInOther(child2);
            this.layoutChildWithMargin(child2, right1, this.mAreaRect.top, right2, this.mAreaRect.top + orientationHelper.getDecoratedMeasurement(child2), helper);
            int right3 = right1 + orientationHelper.getDecoratedMeasurementInOther(child3);
            this.layoutChildWithMargin(child3, right1, this.mAreaRect.bottom - orientationHelper.getDecoratedMeasurement(child3), right3, this.mAreaRect.bottom, helper);
            int right4 = right3 + orientationHelper.getDecoratedMeasurementInOther(child4);
            this.layoutChildWithMargin(child4, right3, this.mAreaRect.bottom - orientationHelper.getDecoratedMeasurement(child4), right3 + orientationHelper.getDecoratedMeasurementInOther(child4), this.mAreaRect.bottom, helper);
            this.layoutChildWithMargin(child5, right4, this.mAreaRect.bottom - orientationHelper.getDecoratedMeasurement(child5), right4 + orientationHelper.getDecoratedMeasurementInOther(child5), this.mAreaRect.bottom, helper);
            mainConsumed = this.mAreaRect.bottom - this.mAreaRect.top + (this.hasHeader ? 0 : this.mMarginTop + this.mPaddingTop) + (this.hasFooter ? 0 : this.mMarginBottom + this.mPaddingBottom);
        }
        this.handleStateOnResult(result, this.mChildrenViews);
        return mainConsumed;
    }
}

