/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.vlayout.layout;

import android.support.annotation.NonNull;
import android.support.v4.util.ArrayMap;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;
import com.alibaba.android.vlayout.LayoutManagerHelper;
import com.alibaba.android.vlayout.OrientationHelperEx;
import com.alibaba.android.vlayout.Range;
import com.alibaba.android.vlayout.VirtualLayoutManager;
import com.alibaba.android.vlayout.layout.BaseLayoutHelper;
import com.alibaba.android.vlayout.layout.GridLayoutHelper;
import com.alibaba.android.vlayout.layout.LayoutChunkResult;
import com.alibaba.android.vlayout.layout.RangeStyle;
import java.util.Arrays;

public class RangeGridLayoutHelper
extends BaseLayoutHelper {
    private static final String TAG = "RGLayoutHelper";
    private static boolean DEBUG = false;
    private GridRangeStyle mRangeStyle = new GridRangeStyle(this);
    private int mTotalSize = 0;
    private static final int MAIN_DIR_SPEC = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
    private boolean mLayoutWithAnchor = false;

    public RangeGridLayoutHelper(int spanCount) {
        this(spanCount, -1, -1);
    }

    public RangeGridLayoutHelper(int spanCount, int itemCount) {
        this(spanCount, itemCount, 0);
    }

    public RangeGridLayoutHelper(int spanCount, int itemCount, int gap) {
        this(spanCount, itemCount, gap, gap);
    }

    public RangeGridLayoutHelper(int spanCount, int itemCount, int vGap, int hGap) {
        this.mRangeStyle.setSpanCount(spanCount);
        this.mRangeStyle.setVGap(vGap);
        this.mRangeStyle.setHGap(hGap);
        this.setItemCount(itemCount);
    }

    public void addRangeStyle(int start, int end, GridRangeStyle rangeStyle) {
        this.mRangeStyle.addChildRangeStyle(start, end, rangeStyle);
    }

    public GridRangeStyle getRootRangeStyle() {
        return this.mRangeStyle;
    }

    @Override
    public void setMargin(int leftMargin, int topMargin, int rightMargin, int bottomMargin) {
        super.setMargin(leftMargin, topMargin, rightMargin, bottomMargin);
        this.mRangeStyle.setMargin(leftMargin, topMargin, rightMargin, bottomMargin);
    }

    @Override
    public void setPadding(int leftPadding, int topPadding, int rightPadding, int bottomPadding) {
        super.setPadding(leftPadding, topPadding, rightPadding, bottomPadding);
        this.mRangeStyle.setPadding(leftPadding, topPadding, rightPadding, bottomPadding);
    }

    public void setWeights(float[] weights) {
        this.mRangeStyle.setWeights(weights);
    }

    public void setSpanSizeLookup(GridLayoutHelper.SpanSizeLookup spanSizeLookup) {
        this.mRangeStyle.setSpanSizeLookup(spanSizeLookup);
    }

    public void setAutoExpand(boolean isAutoExpand) {
        this.mRangeStyle.setAutoExpand(isAutoExpand);
    }

    public void setIgnoreExtra(boolean ignoreExtra) {
        this.mRangeStyle.setIgnoreExtra(ignoreExtra);
    }

    public void setSpanCount(int spanCount) {
        this.mRangeStyle.setSpanCount(spanCount);
    }

    public int getSpanCount() {
        return this.mRangeStyle.getSpanCount();
    }

    @Override
    public void onRangeChange(int start, int end) {
        this.mRangeStyle.setRange(start, end);
    }

    public void setGap(int gap) {
        this.setVGap(gap);
        this.setHGap(gap);
    }

    public void setVGap(int vGap) {
        this.mRangeStyle.setVGap(vGap);
    }

    public void setHGap(int hGap) {
        this.mRangeStyle.setHGap(hGap);
    }

    @Override
    public void setAspectRatio(float aspectRatio) {
        this.mRangeStyle.setAspectRatio(aspectRatio);
    }

    @Override
    public float getAspectRatio() {
        return this.mRangeStyle.getAspectRatio();
    }

    @Override
    public void setBgColor(int bgColor) {
        this.mRangeStyle.setBgColor(bgColor);
    }

    @Override
    public void setLayoutViewHelper(BaseLayoutHelper.DefaultLayoutViewHelper layoutViewHelper) {
        this.mRangeStyle.setLayoutViewHelper(layoutViewHelper);
    }

    @Override
    public void setLayoutViewBindListener(BaseLayoutHelper.LayoutViewBindListener bindListener) {
        this.mRangeStyle.setLayoutViewBindListener(bindListener);
    }

    @Override
    public void setLayoutViewUnBindListener(BaseLayoutHelper.LayoutViewUnBindListener layoutViewUnBindListener) {
        this.mRangeStyle.setLayoutViewUnBindListener(layoutViewUnBindListener);
    }

    @Override
    public boolean requireLayoutView() {
        return this.mRangeStyle.requireLayoutView();
    }

    @Override
    public void beforeLayout(RecyclerView.Recycler recycler, RecyclerView.State state, LayoutManagerHelper helper) {
        this.mRangeStyle.beforeLayout(recycler, state, helper);
    }

    @Override
    public void layoutViews(RecyclerView.Recycler recycler, RecyclerView.State state, VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutChunkResult result, LayoutManagerHelper helper) {
        int spanSize;
        int count;
        boolean layoutInVertical;
        if (this.isOutOfRange(layoutState.getCurrentPosition())) {
            return;
        }
        boolean isStartLine = false;
        boolean isEndLine = false;
        boolean isSecondStartLine = false;
        boolean isSecondEndLine = false;
        int currentPosition = layoutState.getCurrentPosition();
        GridRangeStyle rangeStyle = this.mRangeStyle.findRangeStyleByPosition(currentPosition);
        int itemDirection = layoutState.getItemDirection();
        boolean layingOutInPrimaryDirection = itemDirection == 1;
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        boolean bl = layoutInVertical = helper.getOrientation() == 1;
        if (layoutInVertical) {
            this.mTotalSize = helper.getContentWidth() - helper.getPaddingRight() - helper.getPaddingLeft() - rangeStyle.getFamilyHorizontalMargin() - rangeStyle.getFamilyHorizontalPadding();
            rangeStyle.mSizePerSpan = (int)((float)(this.mTotalSize - (rangeStyle.mSpanCount - 1) * rangeStyle.mHGap) * 1.0f / (float)rangeStyle.mSpanCount + 0.5f);
        } else {
            this.mTotalSize = helper.getContentHeight() - helper.getPaddingBottom() - helper.getPaddingTop() - rangeStyle.getFamilyVerticalMargin() - rangeStyle.getFamilyVerticalPadding();
            rangeStyle.mSizePerSpan = (int)((float)(this.mTotalSize - (rangeStyle.mSpanCount - 1) * rangeStyle.mVGap) * 1.0f / (float)rangeStyle.mSpanCount + 0.5f);
        }
        int consumedSpanCount = 0;
        int remainingSpan = rangeStyle.mSpanCount;
        rangeStyle.ensureSpanCount();
        if (!layingOutInPrimaryDirection) {
            int itemSpanIndex = this.getSpanIndex(rangeStyle.mSpanSizeLookup, rangeStyle.mSpanCount, recycler, state, currentPosition);
            int itemSpanSize = this.getSpanSize(rangeStyle.mSpanSizeLookup, recycler, state, currentPosition);
            remainingSpan = itemSpanIndex + itemSpanSize;
            if (itemSpanIndex != rangeStyle.mSpanCount - 1) {
                int index = layoutState.getCurrentPosition();
                int revRemainingSpan = rangeStyle.mSpanCount - remainingSpan;
                for (count = 0; count < rangeStyle.mSpanCount && revRemainingSpan > 0 && !rangeStyle.isOutOfRange(index -= itemDirection); ++count) {
                    spanSize = this.getSpanSize(rangeStyle.mSpanSizeLookup, recycler, state, index);
                    if (spanSize > rangeStyle.mSpanCount) {
                        throw new IllegalArgumentException("Item at position " + index + " requires " + spanSize + " spans but RangeGridLayoutHelper has only " + rangeStyle.mSpanCount + " spans.");
                    }
                    View view = layoutState.retrieve(recycler, index);
                    if (view == null) break;
                    if (!isStartLine) {
                        boolean bl2 = helper.getReverseLayout() ? index == this.mRangeStyle.getRange().getUpper() : (isStartLine = index == this.mRangeStyle.getRange().getLower());
                    }
                    if (!isEndLine) {
                        boolean bl3 = helper.getReverseLayout() ? index == this.mRangeStyle.getRange().getLower() : (isEndLine = index == this.mRangeStyle.getRange().getUpper());
                    }
                    if ((revRemainingSpan -= spanSize) < 0) break;
                    consumedSpanCount += spanSize;
                    ((GridRangeStyle)rangeStyle).mSet[count] = view;
                }
                if (count > 0) {
                    int s = 0;
                    for (int e = count - 1; s < e; ++s, --e) {
                        View temp = rangeStyle.mSet[s];
                        ((GridRangeStyle)rangeStyle).mSet[s] = rangeStyle.mSet[e];
                        ((GridRangeStyle)rangeStyle).mSet[e] = temp;
                    }
                }
            }
        }
        while (count < rangeStyle.mSpanCount && layoutState.hasMore(state) && remainingSpan > 0) {
            View view;
            int pos = layoutState.getCurrentPosition();
            if (rangeStyle.isOutOfRange(pos)) {
                if (!DEBUG) break;
                Log.d((String)TAG, (String)("pos [" + pos + "] is out of range"));
                break;
            }
            int spanSize2 = this.getSpanSize(rangeStyle.mSpanSizeLookup, recycler, state, pos);
            if (spanSize2 > rangeStyle.mSpanCount) {
                throw new IllegalArgumentException("Item at position " + pos + " requires " + spanSize2 + " spans but GridLayoutManager has only " + rangeStyle.mSpanCount + " spans.");
            }
            if ((remainingSpan -= spanSize2) < 0) break;
            if (!isStartLine) {
                boolean bl4 = helper.getReverseLayout() ? pos == this.mRangeStyle.getRange().getUpper() : (isStartLine = pos == this.mRangeStyle.getRange().getLower());
            }
            if (!isSecondStartLine && !rangeStyle.equals(this.mRangeStyle)) {
                boolean bl5 = helper.getReverseLayout() ? pos == rangeStyle.getRange().getUpper() : (isSecondStartLine = pos == rangeStyle.getRange().getLower());
            }
            if (!isEndLine) {
                boolean bl6 = helper.getReverseLayout() ? pos == this.mRangeStyle.getRange().getLower() : (isEndLine = pos == this.mRangeStyle.getRange().getUpper());
            }
            if (!isSecondEndLine && !rangeStyle.equals(this.mRangeStyle)) {
                boolean bl7 = helper.getReverseLayout() ? pos == rangeStyle.getRange().getLower() : (isSecondEndLine = pos == rangeStyle.getRange().getUpper());
                if (DEBUG) {
                    Log.d((String)TAG, (String)("isSecondEndLineLogic:" + isSecondEndLine + "  helper.getReverseLayout()=" + helper.getReverseLayout() + " pos=" + pos + " rangeStyle.getRange().getLower()=" + rangeStyle.getRange().getLower() + " rangeStyle.getRange().getUpper()=" + rangeStyle.getRange().getUpper()));
                }
            }
            if ((view = layoutState.next(recycler)) == null) break;
            consumedSpanCount += spanSize2;
            ((GridRangeStyle)rangeStyle).mSet[count] = view;
            ++count;
        }
        if (count == 0) {
            return;
        }
        int maxSize = 0;
        this.assignSpans(rangeStyle, recycler, state, count, consumedSpanCount, layingOutInPrimaryDirection, helper);
        if (remainingSpan > 0 && count == consumedSpanCount && rangeStyle.mIsAutoExpand) {
            if (layoutInVertical) {
                rangeStyle.mSizePerSpan = (this.mTotalSize - (count - 1) * rangeStyle.mHGap) / count;
            } else {
                rangeStyle.mSizePerSpan = (this.mTotalSize - (count - 1) * rangeStyle.mVGap) / count;
            }
        } else if (!layingOutInPrimaryDirection && remainingSpan == 0 && count == consumedSpanCount && rangeStyle.mIsAutoExpand) {
            if (layoutInVertical) {
                rangeStyle.mSizePerSpan = (this.mTotalSize - (count - 1) * rangeStyle.mHGap) / count;
            } else {
                rangeStyle.mSizePerSpan = (this.mTotalSize - (count - 1) * rangeStyle.mVGap) / count;
            }
        }
        boolean weighted = false;
        if (rangeStyle.mWeights != null && rangeStyle.mWeights.length > 0) {
            weighted = true;
            int totalSpace = layoutInVertical ? this.mTotalSize - (count - 1) * rangeStyle.mHGap : this.mTotalSize - (count - 1) * rangeStyle.mVGap;
            int eqCnt = 0;
            int remainingSpace = totalSpace;
            int colCnt = remainingSpan > 0 && rangeStyle.mIsAutoExpand ? count : rangeStyle.mSpanCount;
            for (int i = 0; i < colCnt; ++i) {
                if (i < rangeStyle.mWeights.length && !Float.isNaN(rangeStyle.mWeights[i]) && rangeStyle.mWeights[i] >= 0.0f) {
                    float weight = rangeStyle.mWeights[i];
                    ((GridRangeStyle)rangeStyle).mSpanCols[i] = (int)(weight * 1.0f / 100.0f * (float)totalSpace + 0.5f);
                    remainingSpace -= rangeStyle.mSpanCols[i];
                    continue;
                }
                ++eqCnt;
                ((GridRangeStyle)rangeStyle).mSpanCols[i] = -1;
            }
            if (eqCnt > 0) {
                int eqLength = remainingSpace / eqCnt;
                for (int i = 0; i < colCnt; ++i) {
                    if (rangeStyle.mSpanCols[i] >= 0) continue;
                    ((GridRangeStyle)rangeStyle).mSpanCols[i] = eqLength;
                }
            }
        }
        for (int i = 0; i < count; ++i) {
            int spec;
            View view = rangeStyle.mSet[i];
            helper.addChildView(layoutState, view, layingOutInPrimaryDirection ? -1 : 0);
            spanSize = this.getSpanSize(rangeStyle.mSpanSizeLookup, recycler, state, helper.getPosition(view));
            if (weighted) {
                int index = rangeStyle.mSpanIndices[i];
                int spanLength = 0;
                for (int j = 0; j < spanSize; ++j) {
                    spanLength += rangeStyle.mSpanCols[j + index];
                }
                spec = View.MeasureSpec.makeMeasureSpec((int)Math.max(0, spanLength), (int)0x40000000);
            } else {
                spec = View.MeasureSpec.makeMeasureSpec((int)(rangeStyle.mSizePerSpan * spanSize + Math.max(0, spanSize - 1) * (layoutInVertical ? rangeStyle.mHGap : rangeStyle.mVGap)), (int)0x40000000);
            }
            VirtualLayoutManager.LayoutParams lp = (VirtualLayoutManager.LayoutParams)view.getLayoutParams();
            if (helper.getOrientation() == 1) {
                helper.measureChildWithMargins(view, spec, this.getMainDirSpec(rangeStyle, lp.height, this.mTotalSize, View.MeasureSpec.getSize((int)spec), lp.mAspectRatio));
            } else {
                helper.measureChildWithMargins(view, this.getMainDirSpec(rangeStyle, lp.width, this.mTotalSize, View.MeasureSpec.getSize((int)spec), lp.mAspectRatio), View.MeasureSpec.getSize((int)spec));
            }
            int size = orientationHelper.getDecoratedMeasurement(view);
            if (size <= maxSize) continue;
            maxSize = size;
        }
        int maxMeasureSpec = this.getMainDirSpec(rangeStyle, maxSize, this.mTotalSize, 0, Float.NaN);
        for (int i = 0; i < count; ++i) {
            int spec;
            View view = rangeStyle.mSet[i];
            if (orientationHelper.getDecoratedMeasurement(view) == maxSize) continue;
            int spanSize3 = this.getSpanSize(rangeStyle.mSpanSizeLookup, recycler, state, helper.getPosition(view));
            if (weighted) {
                int index = rangeStyle.mSpanIndices[i];
                int spanLength = 0;
                for (int j = 0; j < spanSize3; ++j) {
                    spanLength += rangeStyle.mSpanCols[j + index];
                }
                spec = View.MeasureSpec.makeMeasureSpec((int)Math.max(0, spanLength), (int)0x40000000);
            } else {
                spec = View.MeasureSpec.makeMeasureSpec((int)(rangeStyle.mSizePerSpan * spanSize3 + Math.max(0, spanSize3 - 1) * (layoutInVertical ? rangeStyle.mHGap : rangeStyle.mVGap)), (int)0x40000000);
            }
            if (helper.getOrientation() == 1) {
                helper.measureChildWithMargins(view, spec, maxMeasureSpec);
                continue;
            }
            helper.measureChildWithMargins(view, maxMeasureSpec, spec);
        }
        int startSpace = 0;
        int endSpace = 0;
        int secondStartSpace = 0;
        int secondEndSpace = 0;
        boolean isLayoutEnd = layoutState.getLayoutDirection() == 1;
        boolean isOverLapMargin = helper.isEnableMarginOverLap();
        if (isStartLine) {
            startSpace = this.computeStartSpace(helper, layoutInVertical, isLayoutEnd, isOverLapMargin);
        }
        if (isSecondStartLine) {
            int n = secondStartSpace = layoutInVertical ? rangeStyle.getMarginTop() + rangeStyle.getPaddingTop() : rangeStyle.getMarginLeft() + rangeStyle.getPaddingLeft();
        }
        if (isEndLine) {
            int n = endSpace = layoutInVertical ? this.mRangeStyle.getMarginBottom() + this.mRangeStyle.getPaddingBottom() : this.mRangeStyle.getMarginRight() + this.mRangeStyle.getPaddingRight();
        }
        if (isSecondEndLine) {
            int n = secondEndSpace = layoutInVertical ? rangeStyle.getMarginBottom() + rangeStyle.getPaddingBottom() : rangeStyle.getMarginRight() + rangeStyle.getPaddingRight();
            if (DEBUG) {
                Log.d((String)TAG, (String)("isSecondEndLineLogic:" + isSecondEndLine + " pos=" + currentPosition + " secondEndSpace=" + secondEndSpace));
            }
        }
        result.mConsumed = maxSize + startSpace + endSpace + secondStartSpace + secondEndSpace;
        boolean layoutStart = layoutState.getLayoutDirection() == -1;
        int consumedGap = 0;
        if (!this.mLayoutWithAnchor) {
            if (!layoutStart) {
                if (!isStartLine) {
                    if (isSecondStartLine) {
                        int n = consumedGap = layoutInVertical ? ((GridRangeStyle)rangeStyle.mParent).mVGap : ((GridRangeStyle)rangeStyle.mParent).mHGap;
                        if (DEBUG) {
                            Log.d((String)TAG, (String)("\u2b07 " + currentPosition + " 1 " + consumedGap + " gap"));
                        }
                    } else {
                        int n = consumedGap = layoutInVertical ? rangeStyle.mVGap : rangeStyle.mHGap;
                        if (DEBUG) {
                            Log.d((String)TAG, (String)("\u2b07 " + currentPosition + " 2 " + consumedGap + " gap"));
                        }
                    }
                }
            } else if (!isEndLine) {
                if (isSecondEndLine) {
                    int n = consumedGap = layoutInVertical ? ((GridRangeStyle)rangeStyle.mParent).mVGap : ((GridRangeStyle)rangeStyle.mParent).mHGap;
                    if (DEBUG) {
                        Log.d((String)TAG, (String)("\u2b06 " + currentPosition + " 3 " + consumedGap + " gap"));
                    }
                } else {
                    int n = consumedGap = layoutInVertical ? rangeStyle.mVGap : rangeStyle.mHGap;
                    if (DEBUG) {
                        Log.d((String)TAG, (String)("\u2b06 " + currentPosition + " 4 " + consumedGap + " gap"));
                    }
                }
            }
        }
        result.mConsumed += consumedGap;
        if (result.mConsumed <= 0) {
            result.mConsumed = 0;
        }
        int lastUnconsumedSpace = 0;
        if (!layoutState.isRefreshLayout()) {
            GridRangeStyle neighbourRange;
            int lastLinePosition;
            if (layoutStart) {
                lastLinePosition = currentPosition + 1;
                if (!this.isOutOfRange(lastLinePosition) && (neighbourRange = this.mRangeStyle.findRangeStyleByPosition(lastLinePosition)).isFirstPosition(lastLinePosition)) {
                    int n = lastUnconsumedSpace = layoutInVertical ? neighbourRange.getMarginTop() + neighbourRange.getPaddingTop() : neighbourRange.getMarginLeft() + neighbourRange.getPaddingLeft();
                    if (DEBUG) {
                        Log.d((String)TAG, (String)("\u2b06 " + currentPosition + " 1 " + lastUnconsumedSpace + " last"));
                    }
                }
            } else {
                lastLinePosition = currentPosition - 1;
                if (!this.isOutOfRange(lastLinePosition) && (neighbourRange = this.mRangeStyle.findRangeStyleByPosition(lastLinePosition)).isLastPosition(lastLinePosition)) {
                    int n = lastUnconsumedSpace = layoutInVertical ? neighbourRange.getMarginBottom() + neighbourRange.getPaddingBottom() : neighbourRange.getMarginRight() + neighbourRange.getPaddingRight();
                    if (DEBUG) {
                        Log.d((String)TAG, (String)("\u2b07 " + currentPosition + " 2 " + lastUnconsumedSpace + " last"));
                    }
                }
            }
        }
        if (DEBUG) {
            Log.d((String)TAG, (String)((layoutStart ? "\u2b06 " : "\u2b07 ") + currentPosition + " consumed " + result.mConsumed + " startSpace " + startSpace + " endSpace " + endSpace + " secondStartSpace " + secondStartSpace + " secondEndSpace " + secondEndSpace + " lastUnconsumedSpace " + lastUnconsumedSpace + " isSecondEndLine=" + isSecondEndLine));
        }
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        if (layoutInVertical) {
            if (layoutStart) {
                bottom = layoutState.getOffset() - endSpace - secondEndSpace - consumedGap - lastUnconsumedSpace;
                top = bottom - maxSize;
            } else {
                top = layoutState.getOffset() + startSpace + secondStartSpace + consumedGap + lastUnconsumedSpace;
                bottom = top + maxSize;
            }
        } else if (layoutStart) {
            right = layoutState.getOffset() - endSpace - consumedGap - lastUnconsumedSpace;
            left = right - maxSize;
        } else {
            left = layoutState.getOffset() + startSpace + consumedGap + lastUnconsumedSpace;
            right = left + maxSize;
        }
        for (int i = 0; i < count; ++i) {
            int j;
            View view = rangeStyle.mSet[i];
            int index = rangeStyle.mSpanIndices[i];
            VirtualLayoutManager.LayoutParams params = (VirtualLayoutManager.LayoutParams)view.getLayoutParams();
            if (layoutInVertical) {
                if (weighted) {
                    left = helper.getPaddingLeft() + rangeStyle.getFamilyMarginLeft() + rangeStyle.getFamilyPaddingLeft();
                    for (j = 0; j < index; ++j) {
                        left += rangeStyle.mSpanCols[j] + rangeStyle.mHGap;
                    }
                } else {
                    left = helper.getPaddingLeft() + rangeStyle.getFamilyMarginLeft() + rangeStyle.getFamilyPaddingLeft() + rangeStyle.mSizePerSpan * index + index * rangeStyle.mHGap;
                }
                right = left + orientationHelper.getDecoratedMeasurementInOther(view);
            } else {
                if (weighted) {
                    top = helper.getPaddingTop() + rangeStyle.getFamilyMarginTop() + rangeStyle.getFamilyPaddingTop();
                    for (j = 0; j < index; ++j) {
                        top += rangeStyle.mSpanCols[j] + rangeStyle.mVGap;
                    }
                } else {
                    top = helper.getPaddingTop() + rangeStyle.getFamilyMarginTop() + rangeStyle.getFamilyPaddingTop() + rangeStyle.mSizePerSpan * index + index * rangeStyle.mVGap;
                }
                bottom = top + orientationHelper.getDecoratedMeasurementInOther(view);
            }
            if (DEBUG) {
                Log.d((String)TAG, (String)("layout item in position: " + params.getViewPosition() + " with text with SpanIndex: " + index + " into (" + left + ", " + top + ", " + right + ", " + bottom + "), topInfo=[layoutState.getOffset()=" + layoutState.getOffset() + " startSpace=" + startSpace + " secondStartSpace=" + secondStartSpace + " consumedGap=" + consumedGap + " lastUnconsumedSpace=" + lastUnconsumedSpace + "]"));
            }
            rangeStyle.layoutChild(view, left, top, right, bottom, helper, false);
            if (params.isItemRemoved() || params.isItemChanged()) {
                result.mIgnoreConsumed = true;
            }
            result.mFocusable |= view.isFocusable();
        }
        this.mLayoutWithAnchor = false;
        Arrays.fill(rangeStyle.mSet, null);
        Arrays.fill(rangeStyle.mSpanIndices, 0);
        Arrays.fill(rangeStyle.mSpanCols, 0);
    }

    @Override
    public void afterLayout(RecyclerView.Recycler recycler, RecyclerView.State state, int startPosition, int endPosition, int scrolled, LayoutManagerHelper helper) {
        this.mRangeStyle.afterLayout(recycler, state, startPosition, endPosition, scrolled, helper);
    }

    @Override
    public void adjustLayout(int startPosition, int endPosition, LayoutManagerHelper helper) {
        this.mRangeStyle.adjustLayout(startPosition, endPosition, helper);
    }

    @Override
    public int computeAlignOffset(int offset, boolean isLayoutEnd, boolean useAnchor, LayoutManagerHelper helper) {
        boolean layoutInVertical;
        boolean bl = layoutInVertical = helper.getOrientation() == 1;
        if (isLayoutEnd) {
            if (offset == this.getItemCount() - 1) {
                return GridRangeStyle.computeEndAlignOffset(this.mRangeStyle, layoutInVertical);
            }
        } else if (offset == 0) {
            return GridRangeStyle.computeStartAlignOffset(this.mRangeStyle, layoutInVertical);
        }
        return super.computeAlignOffset(offset, isLayoutEnd, useAnchor, helper);
    }

    @Override
    public void onClear(LayoutManagerHelper helper) {
        super.onClear(helper);
        this.mRangeStyle.onClear(helper);
        this.mRangeStyle.onInvalidateSpanIndexCache();
    }

    @Override
    public void onItemsChanged(LayoutManagerHelper helper) {
        super.onItemsChanged(helper);
        this.mRangeStyle.onInvalidateSpanIndexCache();
    }

    private int getMainDirSpec(GridRangeStyle rangeStyle, int dim, int otherSize, int viewSize, float viewAspectRatio) {
        if (!Float.isNaN(viewAspectRatio) && viewAspectRatio > 0.0f && viewSize > 0) {
            return View.MeasureSpec.makeMeasureSpec((int)((int)((float)viewSize / viewAspectRatio + 0.5f)), (int)0x40000000);
        }
        if (!Float.isNaN(rangeStyle.mAspectRatio) && rangeStyle.mAspectRatio > 0.0f) {
            return View.MeasureSpec.makeMeasureSpec((int)((int)((float)otherSize / rangeStyle.mAspectRatio + 0.5f)), (int)0x40000000);
        }
        if (dim < 0) {
            return MAIN_DIR_SPEC;
        }
        return View.MeasureSpec.makeMeasureSpec((int)dim, (int)0x40000000);
    }

    @Override
    public void checkAnchorInfo(RecyclerView.State state, VirtualLayoutManager.AnchorInfoWrapper anchorInfo, LayoutManagerHelper helper) {
        if (state.getItemCount() > 0) {
            GridRangeStyle rangeStyle = this.mRangeStyle.findRangeStyleByPosition(anchorInfo.position);
            int span = rangeStyle.mSpanSizeLookup.getCachedSpanIndex(anchorInfo.position, rangeStyle.mSpanCount);
            if (anchorInfo.layoutFromEnd) {
                while (span < rangeStyle.mSpanCount - 1 && anchorInfo.position < this.getRange().getUpper()) {
                    ++anchorInfo.position;
                    span = rangeStyle.mSpanSizeLookup.getCachedSpanIndex(anchorInfo.position, rangeStyle.mSpanCount);
                }
            } else {
                while (span > 0 && anchorInfo.position > 0) {
                    --anchorInfo.position;
                    span = rangeStyle.mSpanSizeLookup.getCachedSpanIndex(anchorInfo.position, rangeStyle.mSpanCount);
                }
            }
            this.mLayoutWithAnchor = true;
        }
    }

    private int getSpanIndex(GridLayoutHelper.SpanSizeLookup spanSizeLookup, int spanCount, RecyclerView.Recycler recycler, RecyclerView.State state, int pos) {
        if (!state.isPreLayout()) {
            return spanSizeLookup.getCachedSpanIndex(pos, spanCount);
        }
        int adapterPosition = recycler.convertPreLayoutPositionToPostLayout(pos);
        if (adapterPosition == -1) {
            return 0;
        }
        return spanSizeLookup.getCachedSpanIndex(adapterPosition, spanCount);
    }

    private int getSpanSize(GridLayoutHelper.SpanSizeLookup spanSizeLookup, RecyclerView.Recycler recycler, RecyclerView.State state, int pos) {
        if (!state.isPreLayout()) {
            return spanSizeLookup.getSpanSize(pos);
        }
        int adapterPosition = recycler.convertPreLayoutPositionToPostLayout(pos);
        if (adapterPosition == -1) {
            return 0;
        }
        return spanSizeLookup.getSpanSize(adapterPosition);
    }

    private void assignSpans(GridRangeStyle rangeStyle, RecyclerView.Recycler recycler, RecyclerView.State state, int count, int consumedSpanCount, boolean layingOutInPrimaryDirection, LayoutManagerHelper helper) {
        int spanDiff;
        int span;
        int diff;
        int end;
        int start;
        if (layingOutInPrimaryDirection) {
            start = 0;
            end = count;
            diff = 1;
        } else {
            start = count - 1;
            end = -1;
            diff = -1;
        }
        if (helper.getOrientation() == 1 && helper.isDoLayoutRTL()) {
            span = consumedSpanCount - 1;
            spanDiff = -1;
        } else {
            span = 0;
            spanDiff = 1;
        }
        for (int i = start; i != end; i += diff) {
            View view = rangeStyle.mSet[i];
            int spanSize = this.getSpanSize(rangeStyle.mSpanSizeLookup, recycler, state, helper.getPosition(view));
            ((GridRangeStyle)rangeStyle).mSpanIndices[i] = spanDiff == -1 && spanSize > 1 ? span - (spanSize - 1) : span;
            span += spanDiff * spanSize;
        }
    }

    public int getBorderStartSpace(LayoutManagerHelper helper) {
        int start = this.getRange().getLower();
        GridRangeStyle rangeStyle = this.mRangeStyle.findRangeStyleByPosition(start);
        if (helper.getOrientation() == 1) {
            return rangeStyle.getFamilyMarginTop() + rangeStyle.getFamilyPaddingTop();
        }
        return rangeStyle.getFamilyMarginLeft() + rangeStyle.getFamilyPaddingLeft();
    }

    public int getBorderEndSpace(LayoutManagerHelper helper) {
        int end = this.getRange().getUpper();
        GridRangeStyle rangeStyle = this.mRangeStyle.findRangeStyleByPosition(end);
        if (helper.getOrientation() == 1) {
            return rangeStyle.getFamilyMarginBottom() + rangeStyle.getFamilyPaddingBottom();
        }
        return rangeStyle.getFamilyMarginRight() + rangeStyle.getFamilyPaddingRight();
    }

    public static class GridRangeStyle
    extends RangeStyle<GridRangeStyle> {
        private float mAspectRatio = Float.NaN;
        private int mSpanCount = 4;
        private int mSizePerSpan = 0;
        private boolean mIsAutoExpand = true;
        private boolean mIgnoreExtra = false;
        @NonNull
        private GridLayoutHelper.SpanSizeLookup mSpanSizeLookup = new GridLayoutHelper.DefaultSpanSizeLookup();
        private int mVGap = 0;
        private int mHGap = 0;
        private float[] mWeights = new float[0];
        private View[] mSet;
        private int[] mSpanIndices;
        private int[] mSpanCols;

        public GridRangeStyle(RangeGridLayoutHelper layoutHelper) {
            super(layoutHelper);
            this.mSpanSizeLookup.setSpanIndexCacheEnabled(true);
        }

        public GridRangeStyle() {
            this.mSpanSizeLookup.setSpanIndexCacheEnabled(true);
        }

        public GridRangeStyle findRangeStyleByPosition(int position) {
            return this.findRangeStyle(this, position);
        }

        private GridRangeStyle findRangeStyle(GridRangeStyle rangeStyle, int position) {
            int size = rangeStyle.mChildren.size();
            for (int i = 0; i < size; ++i) {
                GridRangeStyle childRangeStyle = (GridRangeStyle)rangeStyle.mChildren.valueAt(i);
                Range range = (Range)rangeStyle.mChildren.keyAt(i);
                if (!childRangeStyle.isChildrenEmpty()) {
                    return this.findRangeStyle(childRangeStyle, position);
                }
                if (!range.contains(position)) continue;
                return (GridRangeStyle)rangeStyle.mChildren.valueAt(i);
            }
            return rangeStyle;
        }

        public GridRangeStyle findSiblingStyleByPosition(int position) {
            GridRangeStyle rangeStyle = null;
            if (this.mParent != null) {
                ArrayMap siblings = ((GridRangeStyle)this.mParent).mChildren;
                int size = siblings.size();
                for (int i = 0; i < size; ++i) {
                    Range range = (Range)siblings.keyAt(i);
                    if (!range.contains(position)) continue;
                    GridRangeStyle childRangeStyle = (GridRangeStyle)siblings.valueAt(i);
                    if (childRangeStyle.equals(this)) break;
                    rangeStyle = childRangeStyle;
                    break;
                }
            }
            return rangeStyle;
        }

        public void onInvalidateSpanIndexCache() {
            this.mSpanSizeLookup.invalidateSpanIndexCache();
            int size = this.mChildren.size();
            for (int i = 0; i < size; ++i) {
                GridRangeStyle rangeStyle = (GridRangeStyle)this.mChildren.valueAt(i);
                rangeStyle.onInvalidateSpanIndexCache();
            }
        }

        public static int computeEndAlignOffset(GridRangeStyle rangeStyle, boolean layoutInVertical) {
            int offset = layoutInVertical ? rangeStyle.mMarginBottom + rangeStyle.mPaddingBottom : rangeStyle.mMarginRight + rangeStyle.mPaddingRight;
            int endPosition = rangeStyle.getRange().getUpper();
            int size = rangeStyle.mChildren.size();
            for (int i = 0; i < size; ++i) {
                GridRangeStyle childRangeStyle = (GridRangeStyle)rangeStyle.mChildren.valueAt(i);
                if (!childRangeStyle.isChildrenEmpty()) {
                    offset += GridRangeStyle.computeEndAlignOffset(childRangeStyle, layoutInVertical);
                    continue;
                }
                if ((Integer)childRangeStyle.mRange.getUpper() != endPosition) continue;
                offset += layoutInVertical ? childRangeStyle.mMarginBottom + childRangeStyle.mPaddingBottom : childRangeStyle.mMarginRight + childRangeStyle.mPaddingRight;
                break;
            }
            return offset;
        }

        public static int computeStartAlignOffset(GridRangeStyle rangeStyle, boolean layoutInVertical) {
            int offset = layoutInVertical ? -rangeStyle.mMarginTop - rangeStyle.mPaddingTop : -rangeStyle.mMarginLeft - rangeStyle.mPaddingLeft;
            int startPosition = rangeStyle.getRange().getLower();
            int size = rangeStyle.mChildren.size();
            for (int i = 0; i < size; ++i) {
                GridRangeStyle childRangeStyle = (GridRangeStyle)rangeStyle.mChildren.valueAt(i);
                if (!childRangeStyle.isChildrenEmpty()) {
                    offset += GridRangeStyle.computeStartAlignOffset(childRangeStyle, layoutInVertical);
                    continue;
                }
                if ((Integer)childRangeStyle.mRange.getLower() != startPosition) continue;
                offset += layoutInVertical ? -childRangeStyle.mMarginTop - childRangeStyle.mPaddingTop : -childRangeStyle.mMarginLeft - childRangeStyle.mPaddingLeft;
                break;
            }
            return offset;
        }

        public void setAspectRatio(float aspectRatio) {
            this.mAspectRatio = aspectRatio;
        }

        public float getAspectRatio() {
            return this.mAspectRatio;
        }

        @Override
        public void setRange(int start, int end) {
            super.setRange(start, end);
            this.mSpanSizeLookup.setStartPosition(start);
            this.mSpanSizeLookup.invalidateSpanIndexCache();
        }

        public void setGap(int gap) {
            this.setVGap(gap);
            this.setHGap(gap);
        }

        public void setVGap(int vGap) {
            if (vGap < 0) {
                vGap = 0;
            }
            this.mVGap = vGap;
        }

        public void setHGap(int hGap) {
            if (hGap < 0) {
                hGap = 0;
            }
            this.mHGap = hGap;
        }

        public void setWeights(float[] weights) {
            this.mWeights = weights != null ? Arrays.copyOf(weights, weights.length) : new float[0];
        }

        public void setSpanSizeLookup(GridLayoutHelper.SpanSizeLookup spanSizeLookup) {
            if (spanSizeLookup != null) {
                spanSizeLookup.setStartPosition(this.mSpanSizeLookup.getStartPosition());
                this.mSpanSizeLookup = spanSizeLookup;
            }
        }

        public void setAutoExpand(boolean isAutoExpand) {
            this.mIsAutoExpand = isAutoExpand;
        }

        public void setIgnoreExtra(boolean ignoreExtra) {
            this.mIgnoreExtra = ignoreExtra;
        }

        public void setSpanCount(int spanCount) {
            if (spanCount == this.mSpanCount) {
                return;
            }
            if (spanCount < 1) {
                throw new IllegalArgumentException("Span count should be at least 1. Provided " + spanCount);
            }
            this.mSpanCount = spanCount;
            this.mSpanSizeLookup.invalidateSpanIndexCache();
            this.ensureSpanCount();
        }

        public int getSpanCount() {
            return this.mSpanCount;
        }

        private void ensureSpanCount() {
            if (this.mSet == null || this.mSet.length != this.mSpanCount) {
                this.mSet = new View[this.mSpanCount];
            }
            if (this.mSpanIndices == null || this.mSpanIndices.length != this.mSpanCount) {
                this.mSpanIndices = new int[this.mSpanCount];
            }
            if (this.mSpanCols == null || this.mSpanCols.length != this.mSpanCount) {
                this.mSpanCols = new int[this.mSpanCount];
            }
        }
    }
}

