/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.vlayout.layout;

import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.SimpleArrayMap;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.alibaba.android.vlayout.LayoutManagerHelper;
import com.alibaba.android.vlayout.OrientationHelperEx;
import com.alibaba.android.vlayout.Range;
import com.alibaba.android.vlayout.layout.BaseLayoutHelper;
import java.lang.reflect.Array;

public class RangeStyle<T extends RangeStyle> {
    private static final boolean DEBUG = false;
    private static final String TAG = "RangeStyle";
    protected BaseLayoutHelper mLayoutHelper;
    protected T mParent;
    private int mOriginStartOffset = 0;
    private int mOriginEndOffset = 0;
    protected Range<Integer> mRange;
    protected ArrayMap<Range<Integer>, T> mChildren = new ArrayMap();
    protected int mPaddingLeft;
    protected int mPaddingRight;
    protected int mPaddingTop;
    protected int mPaddingBottom;
    protected int mMarginLeft;
    protected int mMarginRight;
    protected int mMarginTop;
    protected int mMarginBottom;
    protected Rect mLayoutRegion = new Rect();
    private View mLayoutView;
    private int mBgColor;
    private BaseLayoutHelper.LayoutViewUnBindListener mLayoutViewUnBindListener;
    private BaseLayoutHelper.LayoutViewBindListener mLayoutViewBindListener;

    public RangeStyle(BaseLayoutHelper layoutHelper) {
        this.mLayoutHelper = layoutHelper;
    }

    public RangeStyle() {
    }

    public void addChildRangeStyle(int start, int end, T rangeStyle) {
        if (start <= end && rangeStyle != null) {
            rangeStyle.setParent((RangeStyle)this);
            rangeStyle.setOriginStartOffset(start);
            rangeStyle.setOriginEndOffset(end);
            rangeStyle.setRange(start, end);
            this.mChildren.put(rangeStyle.getRange(), rangeStyle);
        }
    }

    public void setParent(T rangeStyle) {
        this.mParent = rangeStyle;
    }

    public void setPadding(int leftPadding, int topPadding, int rightPadding, int bottomPadding) {
        this.mPaddingLeft = leftPadding;
        this.mPaddingRight = rightPadding;
        this.mPaddingTop = topPadding;
        this.mPaddingBottom = bottomPadding;
    }

    public void setMargin(int leftMargin, int topMargin, int rightMargin, int bottomMargin) {
        this.mMarginLeft = leftMargin;
        this.mMarginTop = topMargin;
        this.mMarginRight = rightMargin;
        this.mMarginBottom = bottomMargin;
    }

    protected int getHorizontalMargin() {
        return this.mMarginLeft + this.mMarginRight;
    }

    protected int getVerticalMargin() {
        return this.mMarginTop + this.mMarginBottom;
    }

    protected int getHorizontalPadding() {
        return this.mPaddingLeft + this.mPaddingRight;
    }

    protected int getVerticalPadding() {
        return this.mPaddingTop + this.mPaddingBottom;
    }

    public int getPaddingLeft() {
        return this.mPaddingLeft;
    }

    public int getPaddingRight() {
        return this.mPaddingRight;
    }

    public int getPaddingTop() {
        return this.mPaddingTop;
    }

    public int getPaddingBottom() {
        return this.mPaddingBottom;
    }

    public int getMarginLeft() {
        return this.mMarginLeft;
    }

    public int getMarginRight() {
        return this.mMarginRight;
    }

    public int getMarginTop() {
        return this.mMarginTop;
    }

    public int getMarginBottom() {
        return this.mMarginBottom;
    }

    public void setPaddingLeft(int paddingLeft) {
        this.mPaddingLeft = paddingLeft;
    }

    public void setPaddingRight(int paddingRight) {
        this.mPaddingRight = paddingRight;
    }

    public void setPaddingTop(int paddingTop) {
        this.mPaddingTop = paddingTop;
    }

    public void setPaddingBottom(int paddingBottom) {
        this.mPaddingBottom = paddingBottom;
    }

    public void setMarginLeft(int marginLeft) {
        this.mMarginLeft = marginLeft;
    }

    public void setMarginRight(int marginRight) {
        this.mMarginRight = marginRight;
    }

    public void setMarginTop(int marginTop) {
        this.mMarginTop = marginTop;
    }

    public void setMarginBottom(int marginBottom) {
        this.mMarginBottom = marginBottom;
    }

    public int getFamilyHorizontalMargin() {
        return (this.mParent != null ? ((RangeStyle)this.mParent).getFamilyHorizontalMargin() : 0) + this.getHorizontalMargin();
    }

    public int getFamilyVerticalMargin() {
        return (this.mParent != null ? ((RangeStyle)this.mParent).getFamilyVerticalMargin() : 0) + this.getVerticalMargin();
    }

    public int getFamilyHorizontalPadding() {
        return (this.mParent != null ? ((RangeStyle)this.mParent).getFamilyHorizontalPadding() : 0) + this.getHorizontalPadding();
    }

    public int getFamilyVerticalPadding() {
        return (this.mParent != null ? ((RangeStyle)this.mParent).getFamilyVerticalPadding() : 0) + this.getVerticalPadding();
    }

    public int getFamilyPaddingLeft() {
        return (this.mParent != null ? ((RangeStyle)this.mParent).getFamilyPaddingLeft() : 0) + this.mPaddingLeft;
    }

    public int getFamilyPaddingRight() {
        return (this.mParent != null ? ((RangeStyle)this.mParent).getFamilyPaddingRight() : 0) + this.mPaddingRight;
    }

    public int getFamilyPaddingTop() {
        return (this.mParent != null ? ((RangeStyle)this.mParent).getFamilyPaddingTop() : 0) + this.mPaddingTop;
    }

    public int getFamilyPaddingBottom() {
        return (this.mParent != null ? ((RangeStyle)this.mParent).getFamilyPaddingBottom() : 0) + this.mPaddingBottom;
    }

    public int getFamilyMarginLeft() {
        return (this.mParent != null ? ((RangeStyle)this.mParent).getFamilyMarginLeft() : 0) + this.mMarginLeft;
    }

    public int getFamilyMarginRight() {
        return (this.mParent != null ? ((RangeStyle)this.mParent).getFamilyMarginRight() : 0) + this.mMarginRight;
    }

    public int getFamilyMarginTop() {
        return (this.mParent != null ? ((RangeStyle)this.mParent).getFamilyMarginTop() : 0) + this.mMarginTop;
    }

    public int getFamilyMarginBottom() {
        return (this.mParent != null ? ((RangeStyle)this.mParent).getFamilyMarginBottom() : 0) + this.mMarginBottom;
    }

    public int getAncestorHorizontalMargin() {
        return this.mParent != null ? ((RangeStyle)this.mParent).getAncestorHorizontalMargin() + ((RangeStyle)this.mParent).getHorizontalMargin() : 0;
    }

    public int getAncestorVerticalMargin() {
        return this.mParent != null ? ((RangeStyle)this.mParent).getAncestorVerticalMargin() + ((RangeStyle)this.mParent).getVerticalMargin() : 0;
    }

    public int getAncestorHorizontalPadding() {
        return this.mParent != null ? ((RangeStyle)this.mParent).getAncestorHorizontalPadding() + ((RangeStyle)this.mParent).getHorizontalPadding() : 0;
    }

    public int getAncestorVerticalPadding() {
        return this.mParent != null ? ((RangeStyle)this.mParent).getAncestorVerticalPadding() + ((RangeStyle)this.mParent).getVerticalPadding() : 0;
    }

    public int getAncestorPaddingLeft() {
        return this.mParent != null ? ((RangeStyle)this.mParent).getAncestorPaddingLeft() + ((RangeStyle)this.mParent).getPaddingLeft() : 0;
    }

    public int getAncestorPaddingRight() {
        return this.mParent != null ? ((RangeStyle)this.mParent).getAncestorPaddingRight() + ((RangeStyle)this.mParent).getPaddingRight() : 0;
    }

    public int getAncestorPaddingTop() {
        return this.mParent != null ? ((RangeStyle)this.mParent).getAncestorPaddingTop() + ((RangeStyle)this.mParent).getPaddingTop() : 0;
    }

    public int getAncestorPaddingBottom() {
        return this.mParent != null ? ((RangeStyle)this.mParent).getAncestorPaddingBottom() + ((RangeStyle)this.mParent).getPaddingBottom() : 0;
    }

    public int getAncestorMarginLeft() {
        return this.mParent != null ? ((RangeStyle)this.mParent).getAncestorMarginLeft() + ((RangeStyle)this.mParent).getMarginLeft() : 0;
    }

    public int getAncestorMarginRight() {
        return this.mParent != null ? ((RangeStyle)this.mParent).getAncestorMarginRight() + ((RangeStyle)this.mParent).getMarginRight() : 0;
    }

    public int getAncestorMarginTop() {
        return this.mParent != null ? ((RangeStyle)this.mParent).getAncestorMarginTop() + ((RangeStyle)this.mParent).getMarginTop() : 0;
    }

    public int getAncestorMarginBottom() {
        return this.mParent != null ? ((RangeStyle)this.mParent).getAncestorMarginBottom() + ((RangeStyle)this.mParent).getMarginBottom() : 0;
    }

    public int getOriginStartOffset() {
        return this.mOriginStartOffset;
    }

    public int getOriginEndOffset() {
        return this.mOriginEndOffset;
    }

    public void setOriginStartOffset(int originStartOffset) {
        this.mOriginStartOffset = originStartOffset;
    }

    public void setOriginEndOffset(int originEndOffset) {
        this.mOriginEndOffset = originEndOffset;
    }

    public Range<Integer> getRange() {
        return this.mRange;
    }

    public BaseLayoutHelper getLayoutHelper() {
        if (this.mLayoutHelper != null) {
            return this.mLayoutHelper;
        }
        if (this.mParent != null) {
            return ((RangeStyle)this.mParent).getLayoutHelper();
        }
        return null;
    }

    public boolean isChildrenEmpty() {
        return this.mChildren.isEmpty();
    }

    public boolean isRoot() {
        return this.mParent == null;
    }

    public boolean isOutOfRange(int position) {
        return this.mRange != null ? !this.mRange.contains(position) : true;
    }

    public boolean isFirstPosition(int position) {
        return this.mRange != null ? this.mRange.getLower() == position : false;
    }

    public boolean isLastPosition(int position) {
        return this.mRange != null ? this.mRange.getUpper() == position : false;
    }

    public void setRange(int start, int end) {
        this.mRange = Range.create(start, end);
        if (!this.mChildren.isEmpty()) {
            SimpleArrayMap newMap = new SimpleArrayMap();
            int size = this.mChildren.size();
            for (int i = 0; i < size; ++i) {
                RangeStyle rangeStyle = (RangeStyle)this.mChildren.valueAt(i);
                int newStart = rangeStyle.getOriginStartOffset() + start;
                int newEnd = rangeStyle.getOriginEndOffset() + start;
                Range<Integer> newRange = Range.create(newStart, newEnd);
                newMap.put(newRange, (Object)rangeStyle);
                rangeStyle.setRange(newStart, newEnd);
            }
            this.mChildren.clear();
            this.mChildren.putAll(newMap);
        }
    }

    public void beforeLayout(RecyclerView.Recycler recycler, RecyclerView.State state, LayoutManagerHelper helper) {
        if (!this.isChildrenEmpty()) {
            int size = this.mChildren.size();
            for (int i = 0; i < size; ++i) {
                RangeStyle rangeStyle = (RangeStyle)this.mChildren.valueAt(i);
                rangeStyle.beforeLayout(recycler, state, helper);
            }
        }
        if (this.requireLayoutView()) {
            if (this.mLayoutView != null) {
                // empty if block
            }
        } else if (this.mLayoutView != null) {
            if (this.mLayoutViewUnBindListener != null) {
                this.mLayoutViewUnBindListener.onUnbind(this.mLayoutView, this.getLayoutHelper());
            }
            helper.removeChildView(this.mLayoutView);
            this.mLayoutView = null;
        }
    }

    private boolean isValidScrolled(int scrolled) {
        return scrolled != Integer.MAX_VALUE && scrolled != Integer.MIN_VALUE;
    }

    public void afterLayout(RecyclerView.Recycler recycler, RecyclerView.State state, int startPosition, int endPosition, int scrolled, LayoutManagerHelper helper) {
        if (!this.isChildrenEmpty()) {
            int size = this.mChildren.size();
            for (int i = 0; i < size; ++i) {
                RangeStyle rangeStyle = (RangeStyle)this.mChildren.valueAt(i);
                rangeStyle.afterLayout(recycler, state, startPosition, endPosition, scrolled, helper);
            }
        }
        if (this.requireLayoutView()) {
            if (this.isValidScrolled(scrolled) && this.mLayoutView != null) {
                this.mLayoutRegion.union(this.mLayoutView.getLeft(), this.mLayoutView.getTop(), this.mLayoutView.getRight(), this.mLayoutView.getBottom());
            }
            if (!this.mLayoutRegion.isEmpty()) {
                if (this.isValidScrolled(scrolled)) {
                    if (helper.getOrientation() == 1) {
                        this.mLayoutRegion.offset(0, -scrolled);
                    } else {
                        this.mLayoutRegion.offset(-scrolled, 0);
                    }
                }
                this.unionChildRegion(this);
                int contentWidth = helper.getContentWidth();
                int contentHeight = helper.getContentHeight();
                if (helper.getOrientation() == 1 ? this.mLayoutRegion.intersects(0, -contentHeight / 4, contentWidth, contentHeight + contentHeight / 4) : this.mLayoutRegion.intersects(-contentWidth / 4, 0, contentWidth + contentWidth / 4, contentHeight)) {
                    if (this.mLayoutView == null) {
                        this.mLayoutView = helper.generateLayoutView();
                        helper.addBackgroundView(this.mLayoutView, true);
                    }
                    if (helper.getOrientation() == 1) {
                        this.mLayoutRegion.left = helper.getPaddingLeft() + this.getFamilyMarginLeft() + this.getAncestorPaddingLeft();
                        this.mLayoutRegion.right = helper.getContentWidth() - helper.getPaddingRight() - this.getFamilyMarginRight() - this.getAncestorPaddingRight();
                    } else {
                        this.mLayoutRegion.top = helper.getPaddingTop() + this.getFamilyMarginTop() + this.getAncestorPaddingTop();
                        this.mLayoutRegion.bottom = helper.getContentWidth() - helper.getPaddingBottom() - this.getFamilyMarginBottom() - this.getAncestorPaddingBottom();
                    }
                    this.bindLayoutView(this.mLayoutView);
                    this.hideLayoutViews(helper);
                    return;
                }
                this.mLayoutRegion.set(0, 0, 0, 0);
                if (this.mLayoutView != null) {
                    this.mLayoutView.layout(0, 0, 0, 0);
                }
                this.hideLayoutViews(helper);
            }
        }
        this.hideLayoutViews(helper);
        if (this.isRoot()) {
            this.removeChildViews(helper, this);
        }
    }

    private void unionChildRegion(RangeStyle<T> rangeStyle) {
        if (!rangeStyle.isChildrenEmpty()) {
            int size = rangeStyle.mChildren.size();
            for (int i = 0; i < size; ++i) {
                RangeStyle childRangeStyle = (RangeStyle)rangeStyle.mChildren.valueAt(i);
                this.unionChildRegion(childRangeStyle);
                if (childRangeStyle.mLayoutView == null) continue;
                rangeStyle.mLayoutRegion.union(childRangeStyle.mLayoutView.getLeft(), childRangeStyle.mLayoutView.getTop(), childRangeStyle.mLayoutView.getRight(), childRangeStyle.mLayoutView.getBottom());
            }
        }
    }

    private void removeChildViews(LayoutManagerHelper helper, RangeStyle<T> rangeStyle) {
        if (!rangeStyle.isChildrenEmpty()) {
            int size = rangeStyle.mChildren.size();
            for (int i = 0; i < size; ++i) {
                RangeStyle childRangeStyle = (RangeStyle)rangeStyle.mChildren.valueAt(i);
                this.removeChildViews(helper, childRangeStyle);
            }
        }
        if (rangeStyle.mLayoutView != null) {
            if (rangeStyle.mLayoutViewUnBindListener != null) {
                rangeStyle.mLayoutViewUnBindListener.onUnbind(rangeStyle.mLayoutView, this.getLayoutHelper());
            }
            helper.removeChildView(rangeStyle.mLayoutView);
            rangeStyle.mLayoutView = null;
        }
    }

    public void adjustLayout(int startPosition, int endPosition, LayoutManagerHelper helper) {
        if (!this.isChildrenEmpty()) {
            int size = this.mChildren.size();
            for (int i = 0; i < size; ++i) {
                RangeStyle rangeStyle = (RangeStyle)this.mChildren.valueAt(i);
                rangeStyle.adjustLayout(startPosition, endPosition, helper);
            }
        }
        if (this.requireLayoutView()) {
            View refer = null;
            Rect tempRect = new Rect();
            OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
            for (int i = 0; i < helper.getChildCount(); ++i) {
                refer = helper.getChildAt(i);
                int anchorPos = helper.getPosition(refer);
                if (!this.getRange().contains(anchorPos)) continue;
                if (refer.getVisibility() == 8) {
                    tempRect.setEmpty();
                    continue;
                }
                RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)refer.getLayoutParams();
                if (helper.getOrientation() == 1) {
                    tempRect.union(helper.getDecoratedLeft(refer) - params.leftMargin, orientationHelper.getDecoratedStart(refer), helper.getDecoratedRight(refer) + params.rightMargin, orientationHelper.getDecoratedEnd(refer));
                    continue;
                }
                tempRect.union(orientationHelper.getDecoratedStart(refer), helper.getDecoratedTop(refer) - params.topMargin, orientationHelper.getDecoratedEnd(refer), helper.getDecoratedBottom(refer) + params.bottomMargin);
            }
            if (!tempRect.isEmpty()) {
                this.mLayoutRegion.set(tempRect.left - this.mPaddingLeft, tempRect.top - this.mPaddingTop, tempRect.right + this.mPaddingRight, tempRect.bottom + this.mPaddingBottom);
            } else {
                this.mLayoutRegion.setEmpty();
            }
            if (this.mLayoutView != null) {
                this.mLayoutView.layout(this.mLayoutRegion.left, this.mLayoutRegion.top, this.mLayoutRegion.right, this.mLayoutRegion.bottom);
            }
        }
    }

    private void hideLayoutViews(LayoutManagerHelper helper) {
        if (this.isRoot()) {
            this.hideChildLayoutViews(helper, this);
            if (this.mLayoutView != null) {
                helper.hideView(this.mLayoutView);
            }
        }
    }

    private void hideChildLayoutViews(LayoutManagerHelper helper, RangeStyle<T> rangeStyle) {
        int size = rangeStyle.mChildren.size();
        for (int i = 0; i < size; ++i) {
            RangeStyle childRangeStyle = (RangeStyle)rangeStyle.mChildren.valueAt(i);
            if (!childRangeStyle.isChildrenEmpty()) {
                this.hideChildLayoutViews(helper, childRangeStyle);
            }
            if (childRangeStyle.mLayoutView == null) continue;
            helper.hideView(childRangeStyle.mLayoutView);
        }
    }

    public boolean requireLayoutView() {
        boolean self;
        boolean bl = self = this.mBgColor != 0 || this.mLayoutViewBindListener != null;
        if (!this.isChildrenEmpty()) {
            self |= this.requireChildLayoutView(this);
        }
        return self;
    }

    private boolean requireChildLayoutView(RangeStyle<T> rangeStyle) {
        boolean self = rangeStyle.mBgColor != 0 || rangeStyle.mLayoutViewBindListener != null;
        int size = rangeStyle.mChildren.size();
        for (int i = 0; i < size; ++i) {
            RangeStyle childRangeStyle = (RangeStyle)rangeStyle.mChildren.valueAt(i);
            if (!childRangeStyle.isChildrenEmpty()) {
                self |= this.requireChildLayoutView(childRangeStyle);
                continue;
            }
            return childRangeStyle.requireLayoutView();
        }
        return self;
    }

    public void bindLayoutView(@NonNull View layoutView) {
        layoutView.measure(View.MeasureSpec.makeMeasureSpec((int)this.mLayoutRegion.width(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.mLayoutRegion.height(), (int)0x40000000));
        layoutView.layout(this.mLayoutRegion.left, this.mLayoutRegion.top, this.mLayoutRegion.right, this.mLayoutRegion.bottom);
        layoutView.setBackgroundColor(this.mBgColor);
        if (this.mLayoutViewBindListener != null) {
            this.mLayoutViewBindListener.onBind(layoutView, this.getLayoutHelper());
        }
        this.mLayoutRegion.set(0, 0, 0, 0);
    }

    public void setLayoutViewHelper(BaseLayoutHelper.DefaultLayoutViewHelper layoutViewHelper) {
        this.mLayoutViewBindListener = layoutViewHelper;
        this.mLayoutViewUnBindListener = layoutViewHelper;
    }

    public void setLayoutViewBindListener(BaseLayoutHelper.LayoutViewBindListener bindListener) {
        this.mLayoutViewBindListener = bindListener;
    }

    public void setLayoutViewUnBindListener(BaseLayoutHelper.LayoutViewUnBindListener layoutViewUnBindListener) {
        this.mLayoutViewUnBindListener = layoutViewUnBindListener;
    }

    public void setBgColor(int bgColor) {
        this.mBgColor = bgColor;
    }

    public void onClear(LayoutManagerHelper helper) {
        this.clearChild(helper, this);
    }

    private void clearChild(LayoutManagerHelper helper, RangeStyle<T> rangeStyle) {
        if (rangeStyle.mLayoutView != null) {
            if (rangeStyle.mLayoutViewUnBindListener != null) {
                rangeStyle.mLayoutViewUnBindListener.onUnbind(rangeStyle.mLayoutView, this.getLayoutHelper());
            }
            helper.removeChildView(rangeStyle.mLayoutView);
            rangeStyle.mLayoutView = null;
        }
        if (rangeStyle.mChildren.isEmpty()) {
            return;
        }
        int size = rangeStyle.mChildren.size();
        for (int i = 0; i < size; ++i) {
            RangeStyle childRangeStyle = (RangeStyle)rangeStyle.mChildren.valueAt(i);
            this.clearChild(helper, childRangeStyle);
        }
    }

    public void onClearChildMap() {
        this.mChildren.clear();
    }

    public void layoutChild(View child, int left, int top, int right, int bottom, @NonNull LayoutManagerHelper helper, boolean addLayoutRegionWithMargin) {
        helper.layoutChildWithMargins(child, left, top, right, bottom);
        this.fillLayoutRegion(left, top, right, bottom, addLayoutRegionWithMargin);
    }

    protected void fillLayoutRegion(int left, int top, int right, int bottom, boolean addLayoutRegionWithMargin) {
        if (addLayoutRegionWithMargin) {
            this.mLayoutRegion.union(left - this.mPaddingLeft - this.mMarginLeft, top - this.mPaddingTop - this.mMarginTop, right + this.mPaddingRight + this.mMarginRight, bottom + this.mPaddingBottom + this.mMarginBottom);
        } else {
            this.mLayoutRegion.union(left - this.mPaddingLeft, top - this.mPaddingTop, right + this.mPaddingRight, bottom + this.mPaddingBottom);
        }
        if (this.mParent != null) {
            ((RangeStyle)this.mParent).fillLayoutRegion(left - this.mPaddingLeft - this.mMarginLeft, top - this.mPaddingTop - this.mMarginLeft, right + this.mPaddingRight + this.mMarginRight, bottom + this.mPaddingBottom + this.mMarginBottom, addLayoutRegionWithMargin);
        }
    }

    private static class RangeMap<T> {
        private static final int CAPACITY = 64;
        private Class<T> mClass;
        private int lastIndex = -1;
        private int[] mOffsetMap = new int[64];
        private T[] mCardMap = (Object[])Array.newInstance(this.mClass, 64);

        public RangeMap(Class<T> type) {
            this.mClass = type;
        }

        public void addChild(int startOffset, int endOffset, T t) {
            int index = this.lastIndex + 1;
            if (index < this.mCardMap.length) {
                this.mCardMap[index] = t;
            } else {
                int oldLength = this.mCardMap.length;
                Object[] newCardMap = (Object[])Array.newInstance(this.mClass, oldLength * 2);
                System.arraycopy(this.mCardMap, 0, newCardMap, 0, oldLength);
                this.mCardMap = newCardMap;
                this.mCardMap[oldLength] = t;
                index = oldLength;
                oldLength = this.mOffsetMap.length;
                int[] newOffsetMap = new int[oldLength * 2];
                System.arraycopy(this.mOffsetMap, 0, newOffsetMap, 0, oldLength);
                this.mOffsetMap = newOffsetMap;
            }
            this.lastIndex = index;
            for (int i = startOffset; i <= endOffset; ++i) {
                this.mOffsetMap[i] = index;
            }
        }

        public T getChild(int offset) {
            return this.mCardMap[this.mOffsetMap[offset]];
        }
    }
}

