/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.vlayout.layout;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.alibaba.android.vlayout.LayoutHelper;
import com.alibaba.android.vlayout.LayoutManagerHelper;
import com.alibaba.android.vlayout.OrientationHelperEx;
import com.alibaba.android.vlayout.Range;
import com.alibaba.android.vlayout.VirtualLayoutManager;
import com.alibaba.android.vlayout.layout.BaseLayoutHelper;
import com.alibaba.android.vlayout.layout.LayoutChunkResult;
import com.alibaba.android.vlayout.layout.StickyLayoutHelper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

public class StaggeredGridLayoutHelper
extends BaseLayoutHelper {
    private static final String TAG = "Staggered";
    private static final String LOOKUP_BUNDLE_KEY = "StaggeredGridLayoutHelper_LazySpanLookup";
    private static final int INVALID_SPAN_ID = Integer.MIN_VALUE;
    static final int INVALID_LINE = Integer.MIN_VALUE;
    private int mNumLanes = 0;
    private Span[] mSpans;
    private int mHGap = 0;
    private int mVGap = 0;
    private int mColLength = 0;
    private int mEachGap = 0;
    private int mLastGap = 0;
    private BitSet mRemainingSpans = null;
    private LazySpanLookup mLazySpanLookup = new LazySpanLookup();
    private List<View> prelayoutViewList = new ArrayList<View>();
    private boolean mLayoutWithAnchor;
    private int anchorPosition;
    private WeakReference<VirtualLayoutManager> mLayoutManager = null;
    private final Runnable checkForGapsRunnable = new Runnable(){

        @Override
        public void run() {
            StaggeredGridLayoutHelper.this.checkForGaps();
        }
    };

    public StaggeredGridLayoutHelper() {
        this(1, 0);
    }

    public StaggeredGridLayoutHelper(int lanes) {
        this(lanes, 0);
    }

    public StaggeredGridLayoutHelper(int lanes, int gap) {
        this.setLane(lanes);
        this.setGap(gap);
    }

    public void setGap(int gap) {
        this.setHGap(gap);
        this.setVGap(gap);
    }

    public void setHGap(int hGap) {
        this.mHGap = hGap;
    }

    public int getHGap() {
        return this.mHGap;
    }

    public void setVGap(int vGap) {
        this.mVGap = vGap;
    }

    public int getVGap() {
        return this.mVGap;
    }

    public void setLane(int lane) {
        this.mNumLanes = lane;
        this.ensureLanes();
    }

    public int getLane() {
        return this.mNumLanes;
    }

    public int getColLength() {
        return this.mColLength;
    }

    private void ensureLanes() {
        if (this.mSpans == null || this.mSpans.length != this.mNumLanes || this.mRemainingSpans == null) {
            this.mRemainingSpans = new BitSet(this.mNumLanes);
            this.mSpans = new Span[this.mNumLanes];
            for (int i = 0; i < this.mNumLanes; ++i) {
                this.mSpans[i] = new Span(i);
            }
        }
    }

    @Override
    public void beforeLayout(RecyclerView.Recycler recycler, RecyclerView.State state, LayoutManagerHelper helper) {
        super.beforeLayout(recycler, state, helper);
        int availableWidth = helper.getOrientation() == 1 ? helper.getContentWidth() - helper.getPaddingLeft() - helper.getPaddingRight() - this.getHorizontalMargin() - this.getHorizontalPadding() : helper.getContentHeight() - helper.getPaddingTop() - helper.getPaddingBottom() - this.getVerticalMargin() - this.getVerticalPadding();
        this.mColLength = (int)((double)((availableWidth - this.mHGap * (this.mNumLanes - 1)) / this.mNumLanes) + 0.5);
        int totalGaps = availableWidth - this.mColLength * this.mNumLanes;
        if (this.mNumLanes <= 1) {
            this.mLastGap = 0;
            this.mEachGap = 0;
        } else if (this.mNumLanes == 2) {
            this.mEachGap = totalGaps;
            this.mLastGap = totalGaps;
        } else {
            this.mLastGap = helper.getOrientation() == 1 ? this.mHGap : this.mVGap;
            this.mEachGap = this.mLastGap;
        }
        if ((this.mLayoutManager == null || this.mLayoutManager.get() == null || this.mLayoutManager.get() != helper) && helper instanceof VirtualLayoutManager) {
            this.mLayoutManager = new WeakReference<VirtualLayoutManager>((VirtualLayoutManager)helper);
        }
    }

    @Override
    public void afterLayout(RecyclerView.Recycler recycler, RecyclerView.State state, int startPosition, int endPosition, int scrolled, LayoutManagerHelper helper) {
        super.afterLayout(recycler, state, startPosition, endPosition, scrolled, helper);
        this.mLayoutWithAnchor = false;
        if (startPosition > this.getRange().getUpper() || endPosition < this.getRange().getLower()) {
            return;
        }
        if (!state.isPreLayout() && helper.getChildCount() > 0) {
            ViewCompat.postOnAnimation((View)helper.getChildAt(0), (Runnable)this.checkForGapsRunnable);
        }
    }

    @Override
    public void layoutViews(RecyclerView.Recycler recycler, RecyclerView.State state, VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutChunkResult result, LayoutManagerHelper helper) {
        int targetLine;
        int recycleLine;
        if (this.isOutOfRange(layoutState.getCurrentPosition())) {
            return;
        }
        this.ensureLanes();
        boolean layoutInVertical = helper.getOrientation() == 1;
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        OrientationHelperEx secondaryOrientationHelper = helper.getSecondaryOrientationHelper();
        boolean isOverLapMargin = helper.isEnableMarginOverLap();
        this.mRemainingSpans.set(0, this.mNumLanes, true);
        if (layoutState.getLayoutDirection() == 1) {
            recycleLine = layoutState.getOffset() + layoutState.getAvailable();
            targetLine = recycleLine + layoutState.getExtra() + orientationHelper.getEndPadding();
        } else {
            recycleLine = layoutState.getOffset() - layoutState.getAvailable();
            targetLine = recycleLine - layoutState.getExtra() - orientationHelper.getStartAfterPadding();
        }
        this.updateAllRemainingSpans(layoutState.getLayoutDirection(), targetLine, orientationHelper);
        int defaultNewViewLine = layoutState.getOffset();
        this.prelayoutViewList.clear();
        while (layoutState.hasMore(state) && !this.mRemainingSpans.isEmpty() && !this.isOutOfRange(layoutState.getCurrentPosition())) {
            int end;
            int start;
            Span currentSpan;
            boolean assignSpan;
            boolean isStartLine = false;
            boolean isEndLine = false;
            int currentPosition = layoutState.getCurrentPosition();
            View view = layoutState.next(recycler);
            if (view == null) break;
            VirtualLayoutManager.LayoutParams lp = (VirtualLayoutManager.LayoutParams)view.getLayoutParams();
            int position = lp.getViewPosition();
            int spanIndex = this.mLazySpanLookup.getSpan(position);
            boolean bl = assignSpan = spanIndex == Integer.MIN_VALUE;
            if (assignSpan) {
                currentSpan = this.getNextSpan(defaultNewViewLine, layoutState, helper);
                this.mLazySpanLookup.setSpan(position, currentSpan);
            } else {
                currentSpan = this.mSpans[spanIndex];
            }
            isStartLine = position - this.getRange().getLower() < this.mNumLanes;
            boolean bl2 = isEndLine = this.getRange().getUpper() - position < this.mNumLanes;
            if (layoutState.isPreLayout()) {
                this.prelayoutViewList.add(view);
            }
            helper.addChildView(layoutState, view);
            if (layoutInVertical) {
                int widthSpec = helper.getChildMeasureSpec(this.mColLength, lp.width, false);
                int heightSpec = helper.getChildMeasureSpec(orientationHelper.getTotalSpace(), Float.isNaN(lp.mAspectRatio) ? lp.height : (int)((float)View.MeasureSpec.getSize((int)widthSpec) / lp.mAspectRatio + 0.5f), true);
                helper.measureChildWithMargins(view, widthSpec, heightSpec);
            } else {
                int heightSpec = helper.getChildMeasureSpec(this.mColLength, lp.height, false);
                int widthSpec = helper.getChildMeasureSpec(orientationHelper.getTotalSpace(), Float.isNaN(lp.mAspectRatio) ? lp.width : (int)((float)View.MeasureSpec.getSize((int)heightSpec) * lp.mAspectRatio + 0.5f), true);
                helper.measureChildWithMargins(view, widthSpec, heightSpec);
            }
            if (layoutState.getLayoutDirection() == 1) {
                start = currentSpan.getEndLine(defaultNewViewLine, orientationHelper);
                if (isStartLine) {
                    start += this.computeStartSpace(helper, layoutInVertical, true, isOverLapMargin);
                } else if (this.mLayoutWithAnchor) {
                    if (Math.abs(currentPosition - this.anchorPosition) >= this.mNumLanes) {
                        start += layoutInVertical ? this.mVGap : this.mHGap;
                    }
                } else {
                    start += layoutInVertical ? this.mVGap : this.mHGap;
                }
                end = start + orientationHelper.getDecoratedMeasurement(view);
            } else {
                end = isEndLine ? currentSpan.getStartLine(defaultNewViewLine, orientationHelper) - (layoutInVertical ? this.mMarginBottom + this.mPaddingRight : this.mMarginRight + this.mPaddingRight) : currentSpan.getStartLine(defaultNewViewLine, orientationHelper) - (layoutInVertical ? this.mVGap : this.mHGap);
                start = end - orientationHelper.getDecoratedMeasurement(view);
            }
            if (layoutState.getLayoutDirection() == 1) {
                currentSpan.appendToSpan(view, orientationHelper);
            } else {
                currentSpan.prependToSpan(view, orientationHelper);
            }
            int otherStart = (currentSpan.mIndex == this.mNumLanes - 1 ? currentSpan.mIndex * (this.mColLength + this.mEachGap) - this.mEachGap + this.mLastGap : currentSpan.mIndex * (this.mColLength + this.mEachGap)) + secondaryOrientationHelper.getStartAfterPadding();
            otherStart = layoutInVertical ? (otherStart += this.mMarginLeft + this.mPaddingLeft) : (otherStart += this.mMarginTop + this.mPaddingTop);
            int otherEnd = otherStart + orientationHelper.getDecoratedMeasurementInOther(view);
            if (layoutInVertical) {
                this.layoutChildWithMargin(view, otherStart, start, otherEnd, end, helper);
            } else {
                this.layoutChildWithMargin(view, start, otherStart, end, otherEnd, helper);
            }
            this.updateRemainingSpans(currentSpan, layoutState.getLayoutDirection(), targetLine, orientationHelper);
            this.recycle(recycler, layoutState, currentSpan, recycleLine, helper);
            this.handleStateOnResult(result, view);
        }
        if (this.isOutOfRange(layoutState.getCurrentPosition())) {
            if (layoutState.getLayoutDirection() == -1) {
                for (Span span : this.mSpans) {
                    if (span.mCachedStart == Integer.MIN_VALUE) continue;
                    span.mLastEdgeStart = span.mCachedStart;
                }
            } else {
                for (Span span : this.mSpans) {
                    if (span.mCachedEnd == Integer.MIN_VALUE) continue;
                    span.mLastEdgeEnd = span.mCachedEnd;
                }
            }
        }
        if (layoutState.getLayoutDirection() == -1) {
            if (!this.isOutOfRange(layoutState.getCurrentPosition()) && layoutState.hasMore(state)) {
                int maxStart = this.getMaxStart(orientationHelper.getStartAfterPadding(), orientationHelper);
                result.mConsumed = layoutState.getOffset() - maxStart;
            } else {
                int minStart = this.getMinStart(orientationHelper.getEndAfterPadding(), orientationHelper);
                result.mConsumed = layoutState.getOffset() - minStart + (layoutInVertical ? this.mMarginTop + this.mPaddingTop : this.mMarginLeft + this.mPaddingLeft);
            }
        } else if (!this.isOutOfRange(layoutState.getCurrentPosition()) && layoutState.hasMore(state)) {
            int minEnd = this.getMinEnd(orientationHelper.getEndAfterPadding(), orientationHelper);
            result.mConsumed = minEnd - layoutState.getOffset();
        } else {
            int maxEnd = this.getMaxEnd(orientationHelper.getEndAfterPadding(), orientationHelper);
            result.mConsumed = maxEnd - layoutState.getOffset() + (layoutInVertical ? this.mMarginBottom + this.mPaddingBottom : this.mMarginRight + this.mPaddingRight);
        }
        this.recycleForPreLayout(recycler, layoutState, helper);
    }

    private void recycleForPreLayout(RecyclerView.Recycler recycler, VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutManagerHelper helper) {
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        for (int i = this.prelayoutViewList.size() - 1; i >= 0; --i) {
            Span span;
            int position;
            RecyclerView.LayoutParams lp;
            View child = this.prelayoutViewList.get(i);
            if (child != null && orientationHelper.getDecoratedStart(child) > orientationHelper.getEndAfterPadding()) {
                lp = (RecyclerView.LayoutParams)child.getLayoutParams();
                position = lp.getViewPosition();
                span = this.findSpan(position, child, false);
                if (span != null) {
                    span.popEnd(orientationHelper);
                }
            } else {
                lp = (RecyclerView.LayoutParams)child.getLayoutParams();
                position = lp.getViewPosition();
                span = this.findSpan(position, child, false);
                if (span != null) {
                    span.popEnd(orientationHelper);
                }
                helper.removeChildView(child);
                recycler.recycleView(child);
                break;
            }
            helper.removeChildView(child);
            recycler.recycleView(child);
        }
    }

    @Override
    public void onScrollStateChanged(int state, int startPosition, int endPosition, LayoutManagerHelper helper) {
        if (startPosition > this.getRange().getUpper() || endPosition < this.getRange().getLower()) {
            return;
        }
        if (state == 0) {
            this.checkForGaps();
        }
    }

    @Override
    public int computeAlignOffset(int offset, boolean isLayoutEnd, boolean useAnchor, LayoutManagerHelper helper) {
        boolean layoutInVertical = helper.getOrientation() == 1;
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        View child = helper.findViewByPosition(offset + this.getRange().getLower());
        if (child == null) {
            return 0;
        }
        this.ensureLanes();
        if (layoutInVertical) {
            if (isLayoutEnd) {
                if (offset == this.getItemCount() - 1) {
                    return this.mMarginBottom + this.mPaddingBottom + (this.getMaxEnd(orientationHelper.getDecoratedEnd(child), orientationHelper) - orientationHelper.getDecoratedEnd(child));
                }
                if (!useAnchor) {
                    int minEnd = this.getMinEnd(orientationHelper.getDecoratedStart(child), orientationHelper);
                    return minEnd - orientationHelper.getDecoratedEnd(child);
                }
            } else {
                if (offset == 0) {
                    return -this.mMarginTop - this.mPaddingTop - (orientationHelper.getDecoratedStart(child) - this.getMinStart(orientationHelper.getDecoratedStart(child), orientationHelper));
                }
                if (!useAnchor) {
                    int maxStart = this.getMaxStart(orientationHelper.getDecoratedEnd(child), orientationHelper);
                    return maxStart - orientationHelper.getDecoratedStart(child);
                }
            }
        }
        return 0;
    }

    @Override
    public void onClear(LayoutManagerHelper helper) {
        super.onClear(helper);
        this.mLazySpanLookup.clear();
        this.mSpans = null;
        this.mLayoutManager = null;
    }

    private void checkForGaps() {
        View child;
        int position;
        View view;
        int i;
        int alignPos;
        int maxPos;
        int minPos;
        if (this.mLayoutManager == null) {
            return;
        }
        VirtualLayoutManager layoutManager = (VirtualLayoutManager)this.mLayoutManager.get();
        if (layoutManager == null || layoutManager.getChildCount() == 0) {
            return;
        }
        Range<Integer> range = this.getRange();
        if (layoutManager.getReverseLayout()) {
            minPos = layoutManager.findLastVisibleItemPosition();
            maxPos = layoutManager.findFirstVisibleItemPosition();
            alignPos = range.getUpper() - 1;
        } else {
            minPos = layoutManager.findFirstVisibleItemPosition();
            maxPos = layoutManager.findLastCompletelyVisibleItemPosition();
            alignPos = range.getLower();
        }
        OrientationHelperEx orientationHelper = layoutManager.getMainOrientationHelper();
        int childCount = layoutManager.getChildCount();
        int viewAnchor = Integer.MIN_VALUE;
        int alignLine = Integer.MIN_VALUE;
        if (layoutManager.getReverseLayout()) {
            for (i = childCount - 1; i >= 0; --i) {
                int aPos;
                view = layoutManager.getChildAt(i);
                position = layoutManager.getPosition(view);
                if (position != alignPos) continue;
                viewAnchor = position;
                alignLine = i == childCount - 1 ? orientationHelper.getDecoratedEnd(view) : ((aPos = layoutManager.getPosition(child = layoutManager.getChildAt(i + 1))) == position - 1 ? orientationHelper.getDecoratedStart(child) - layoutManager.obtainExtraMargin(child, false) + layoutManager.obtainExtraMargin(view, true) : orientationHelper.getDecoratedEnd(view));
                break;
            }
        } else {
            for (i = 0; i < childCount; ++i) {
                LayoutHelper layoutHelper;
                int viewStart;
                view = layoutManager.getChildAt(i);
                position = layoutManager.getPosition(view);
                if (position != alignPos) continue;
                viewAnchor = position;
                if (i == 0) {
                    alignLine = orientationHelper.getDecoratedStart(view);
                    break;
                }
                child = layoutManager.getChildAt(i - 1);
                alignLine = orientationHelper.getDecoratedEnd(child) + layoutManager.obtainExtraMargin(child, true, false) - layoutManager.obtainExtraMargin(view, false, false);
                if (alignLine == (viewStart = orientationHelper.getDecoratedStart(view))) {
                    viewAnchor = Integer.MIN_VALUE;
                    break;
                }
                int nextPosition = layoutManager.getPosition(child);
                if (nextPosition != alignPos - 1) {
                    layoutHelper = layoutManager.findLayoutHelperByPosition(alignPos - 1);
                    if (layoutHelper == null || !(layoutHelper instanceof StickyLayoutHelper) || layoutHelper.getFixedView() == null) break;
                    alignLine += layoutHelper.getFixedView().getMeasuredHeight();
                    break;
                }
                layoutHelper = layoutManager.findLayoutHelperByPosition(nextPosition);
                layoutHelper.getRange();
                break;
            }
        }
        if (viewAnchor == Integer.MIN_VALUE) {
            return;
        }
        View gapView = this.hasGapsToFix(layoutManager, viewAnchor, alignLine);
        if (gapView != null) {
            for (Span span : this.mSpans) {
                span.setLine(alignLine);
            }
            layoutManager.requestSimpleAnimationsInNextLayout();
            layoutManager.requestLayout();
        }
    }

    private View hasGapsToFix(VirtualLayoutManager layoutManager, int position, int alignLine) {
        View view = layoutManager.findViewByPosition(position);
        if (view == null) {
            return null;
        }
        BitSet mSpansToCheck = new BitSet(this.mNumLanes);
        mSpansToCheck.set(0, this.mNumLanes, true);
        for (Span span : this.mSpans) {
            if (span.mViews.size() == 0 || !this.checkSpanForGap(span, layoutManager, alignLine)) continue;
            return layoutManager.getReverseLayout() ? (View)span.mViews.get(span.mViews.size() - 1) : (View)span.mViews.get(0);
        }
        return null;
    }

    private boolean checkSpanForGap(Span span, VirtualLayoutManager layoutManager, int line) {
        OrientationHelperEx orientationHelper = layoutManager.getMainOrientationHelper();
        return layoutManager.getReverseLayout() ? span.getEndLine(orientationHelper) < line : span.getStartLine(orientationHelper) > line;
    }

    private void recycle(RecyclerView.Recycler recycler, VirtualLayoutManager.LayoutStateWrapper layoutState, Span updatedSpan, int recycleLine, LayoutManagerHelper helper) {
        OrientationHelperEx orientation = helper.getMainOrientationHelper();
        if (layoutState.getLayoutDirection() == -1) {
            int maxStart = this.getMaxStart(updatedSpan.getStartLine(orientation), orientation);
            this.recycleFromEnd(recycler, Math.max(recycleLine, maxStart) + (orientation.getEnd() - orientation.getStartAfterPadding()), helper);
        } else {
            int minEnd = this.getMinEnd(updatedSpan.getEndLine(orientation), orientation);
            this.recycleFromStart(recycler, Math.min(recycleLine, minEnd) - (orientation.getEnd() - orientation.getStartAfterPadding()), helper);
        }
    }

    private void recycleFromStart(RecyclerView.Recycler recycler, int line, LayoutManagerHelper helper) {
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        boolean changed = true;
        while (helper.getChildCount() > 0 && changed) {
            View child = helper.getChildAt(0);
            if (child != null && orientationHelper.getDecoratedEnd(child) < line) {
                RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)child.getLayoutParams();
                int position = lp.getViewPosition();
                Span span = this.findSpan(position, child, true);
                if (span != null) {
                    span.popStart(orientationHelper);
                    helper.removeChildView(child);
                    recycler.recycleView(child);
                    continue;
                }
                changed = false;
                continue;
            }
            return;
        }
    }

    private void recycleFromEnd(RecyclerView.Recycler recycler, int line, LayoutManagerHelper helper) {
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        int childCount = helper.getChildCount();
        for (int i = childCount - 1; i >= 0; --i) {
            View child = helper.getChildAt(i);
            if (child != null && orientationHelper.getDecoratedStart(child) > line) {
                RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)child.getLayoutParams();
                int position = lp.getViewPosition();
                Span span = this.findSpan(position, child, false);
                if (span == null) continue;
                span.popEnd(orientationHelper);
                helper.removeChildView(child);
                recycler.recycleView(child);
                continue;
            }
            return;
        }
    }

    private Span findSpan(int position, View child, boolean isStart) {
        int span = this.mLazySpanLookup.getSpan(position);
        if (span >= 0 && span < this.mSpans.length) {
            Span sp = this.mSpans[span];
            if (isStart && sp.findStart(child)) {
                return sp;
            }
            if (!isStart && sp.findEnd(child)) {
                return sp;
            }
        }
        for (int i = 0; i < this.mSpans.length; ++i) {
            if (i == span) continue;
            Span sp = this.mSpans[i];
            if (isStart && sp.findStart(child)) {
                return sp;
            }
            if (isStart || !sp.findEnd(child)) continue;
            return sp;
        }
        return null;
    }

    @Override
    public boolean isRecyclable(int childPos, int startIndex, int endIndex, LayoutManagerHelper helper, boolean fromStart) {
        View child;
        boolean recyclable = super.isRecyclable(childPos, startIndex, endIndex, helper, fromStart);
        if (recyclable && (child = helper.findViewByPosition(childPos)) != null) {
            OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
            RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)child.getLayoutParams();
            int position = lp.getViewPosition();
            if (helper.getReverseLayout()) {
                if (fromStart) {
                    Span span = this.findSpan(position, child, true);
                    if (span != null) {
                        span.popEnd(orientationHelper);
                    }
                } else {
                    Span span = this.findSpan(position, child, false);
                    if (span != null) {
                        span.popStart(orientationHelper);
                    }
                }
            } else if (fromStart) {
                Span span = this.findSpan(position, child, true);
                if (span != null) {
                    span.popStart(orientationHelper);
                }
            } else {
                Span span = this.findSpan(position, child, false);
                if (span != null) {
                    span.popEnd(orientationHelper);
                }
            }
        }
        return recyclable;
    }

    private void updateAllRemainingSpans(int layoutDir, int targetLine, OrientationHelperEx helper) {
        for (int i = 0; i < this.mNumLanes; ++i) {
            if (this.mSpans[i].mViews.isEmpty()) continue;
            this.updateRemainingSpans(this.mSpans[i], layoutDir, targetLine, helper);
        }
    }

    private void updateRemainingSpans(Span span, int layoutDir, int targetLine, OrientationHelperEx helper) {
        int deletedSize = span.getDeletedSize();
        if (layoutDir == -1) {
            int line = span.getStartLine(helper);
            if (line + deletedSize < targetLine) {
                this.mRemainingSpans.set(span.mIndex, false);
            }
        } else {
            int line = span.getEndLine(helper);
            if (line - deletedSize > targetLine) {
                this.mRemainingSpans.set(span.mIndex, false);
            }
        }
    }

    private Span getNextSpan(int defaultLine, VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutManagerHelper helper) {
        int diff;
        int endIndex;
        int startIndex;
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        boolean preferLastSpan = false;
        if (helper.getOrientation() == 0) {
            preferLastSpan = layoutState.getLayoutDirection() == -1 != helper.getReverseLayout();
        } else {
            boolean bl = preferLastSpan = layoutState.getLayoutDirection() == -1 == helper.getReverseLayout() == helper.isDoLayoutRTL();
        }
        if (preferLastSpan) {
            startIndex = this.mNumLanes - 1;
            endIndex = -1;
            diff = -1;
        } else {
            startIndex = 0;
            endIndex = this.mNumLanes;
            diff = 1;
        }
        if (layoutState.getLayoutDirection() == 1) {
            Span min = null;
            int minLine = Integer.MAX_VALUE;
            for (int i = startIndex; i != endIndex; i += diff) {
                Span other = this.mSpans[i];
                int otherLine = other.getEndLine(defaultLine, orientationHelper);
                if (otherLine >= minLine) continue;
                min = other;
                minLine = otherLine;
            }
            return min;
        }
        Span max = null;
        int maxLine = Integer.MIN_VALUE;
        for (int i = startIndex; i != endIndex; i += diff) {
            Span other = this.mSpans[i];
            int otherLine = other.getStartLine(defaultLine, orientationHelper);
            if (otherLine <= maxLine) continue;
            max = other;
            maxLine = otherLine;
        }
        return max;
    }

    private int getMaxStart(int defaultValue, OrientationHelperEx helper) {
        int maxStart = this.mSpans[0].getStartLine(defaultValue, helper);
        for (int i = 1; i < this.mNumLanes; ++i) {
            int spanStart = this.mSpans[i].getStartLine(defaultValue, helper);
            if (spanStart <= maxStart) continue;
            maxStart = spanStart;
        }
        return maxStart;
    }

    private int getMinStart(int defaultValue, OrientationHelperEx helper) {
        int minStart = this.mSpans[0].getStartLine(defaultValue, helper);
        for (int i = 1; i < this.mNumLanes; ++i) {
            int spanStart = this.mSpans[i].getStartLine(defaultValue, helper);
            if (spanStart >= minStart) continue;
            minStart = spanStart;
        }
        return minStart;
    }

    private int getMaxEnd(int defaultValue, OrientationHelperEx helper) {
        int maxEnd = this.mSpans[0].getEndLine(defaultValue, helper);
        for (int i = 1; i < this.mNumLanes; ++i) {
            int spanEnd = this.mSpans[i].getEndLine(defaultValue, helper);
            if (spanEnd <= maxEnd) continue;
            maxEnd = spanEnd;
        }
        return maxEnd;
    }

    private int getMinEnd(int defaultValue, OrientationHelperEx helper) {
        int minEnd = this.mSpans[0].getEndLine(defaultValue, helper);
        for (int i = 1; i < this.mNumLanes; ++i) {
            int spanEnd = this.mSpans[i].getEndLine(defaultValue, helper);
            if (spanEnd >= minEnd) continue;
            minEnd = spanEnd;
        }
        return minEnd;
    }

    @Override
    public void onRefreshLayout(RecyclerView.State state, VirtualLayoutManager.AnchorInfoWrapper anchorInfo, LayoutManagerHelper helper) {
        super.onRefreshLayout(state, anchorInfo, helper);
        this.ensureLanes();
        if (this.isOutOfRange(anchorInfo.position)) {
            for (Span span : this.mSpans) {
                span.clear();
            }
        }
    }

    @Override
    public void checkAnchorInfo(RecyclerView.State state, VirtualLayoutManager.AnchorInfoWrapper anchorInfo, LayoutManagerHelper helper) {
        super.checkAnchorInfo(state, anchorInfo, helper);
        this.ensureLanes();
        Range<Integer> range = this.getRange();
        if (anchorInfo.layoutFromEnd) {
            if (anchorInfo.position < range.getLower() + this.mNumLanes - 1) {
                anchorInfo.position = Math.min(range.getLower() + this.mNumLanes - 1, range.getUpper());
            }
        } else if (anchorInfo.position > range.getUpper() - (this.mNumLanes - 1)) {
            anchorInfo.position = Math.max(range.getLower(), range.getUpper() - (this.mNumLanes - 1));
        }
        View reference = helper.findViewByPosition(anchorInfo.position);
        boolean layoutInVertical = helper.getOrientation() == 1;
        int mainGap = layoutInVertical ? this.mVGap : this.mHGap;
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        if (reference == null) {
            for (Span span : this.mSpans) {
                span.clear();
                span.setLine(anchorInfo.coordinate);
            }
        } else {
            int anchorPos = anchorInfo.layoutFromEnd ? Integer.MIN_VALUE : Integer.MAX_VALUE;
            for (Span span : this.mSpans) {
                View view;
                if (span.mViews.isEmpty()) continue;
                if (anchorInfo.layoutFromEnd) {
                    view = (View)span.mViews.get(span.mViews.size() - 1);
                    anchorPos = Math.max(anchorPos, helper.getPosition(view));
                    continue;
                }
                view = (View)span.mViews.get(0);
                anchorPos = Math.min(anchorPos, helper.getPosition(view));
            }
            int offset = Integer.MIN_VALUE;
            if (!this.isOutOfRange(anchorPos)) {
                boolean isStartLine = anchorPos == range.getLower();
                View view = helper.findViewByPosition(anchorPos);
                if (view != null) {
                    if (anchorInfo.layoutFromEnd) {
                        anchorInfo.position = anchorPos;
                        int endRef = orientationHelper.getDecoratedEnd(reference);
                        if (endRef < anchorInfo.coordinate) {
                            offset = anchorInfo.coordinate - endRef;
                            anchorInfo.coordinate = orientationHelper.getDecoratedEnd(view) + (offset += isStartLine ? 0 : mainGap);
                        } else {
                            offset = isStartLine ? 0 : mainGap;
                            anchorInfo.coordinate = orientationHelper.getDecoratedEnd(view) + offset;
                        }
                    } else {
                        anchorInfo.position = anchorPos;
                        int startRef = orientationHelper.getDecoratedStart(reference);
                        if (startRef > anchorInfo.coordinate) {
                            offset = anchorInfo.coordinate - startRef;
                            anchorInfo.coordinate = orientationHelper.getDecoratedStart(view) + (offset -= isStartLine ? 0 : mainGap);
                        } else {
                            offset = -(isStartLine ? 0 : mainGap);
                            anchorInfo.coordinate = orientationHelper.getDecoratedStart(view) + offset;
                        }
                    }
                }
            } else {
                this.anchorPosition = anchorInfo.position;
                this.mLayoutWithAnchor = true;
            }
            for (Span span : this.mSpans) {
                span.cacheReferenceLineAndClear(helper.getReverseLayout() ^ anchorInfo.layoutFromEnd, offset, orientationHelper);
            }
        }
    }

    @Override
    public void onItemsChanged(LayoutManagerHelper helper) {
    }

    @Override
    public void onSaveState(Bundle bundle) {
        super.onSaveState(bundle);
        bundle.putIntArray(LOOKUP_BUNDLE_KEY, this.mLazySpanLookup.mData);
    }

    @Override
    public void onRestoreInstanceState(Bundle bundle) {
        super.onRestoreInstanceState(bundle);
        this.mLazySpanLookup.mData = bundle.getIntArray(LOOKUP_BUNDLE_KEY);
    }

    @Override
    public void onOffsetChildrenVertical(int dy, LayoutManagerHelper helper) {
        super.onOffsetChildrenVertical(dy, helper);
        if (helper.getOrientation() == 1) {
            for (Span span : this.mSpans) {
                span.onOffset(dy);
            }
        }
    }

    @Override
    public void onOffsetChildrenHorizontal(int dx, LayoutManagerHelper helper) {
        super.onOffsetChildrenHorizontal(dx, helper);
        if (helper.getOrientation() == 0) {
            for (Span span : this.mSpans) {
                span.onOffset(dx);
            }
        }
    }

    static class LazySpanLookup {
        private static final int MIN_SIZE = 10;
        int[] mData;

        LazySpanLookup() {
        }

        int invalidateAfter(int position) {
            if (this.mData == null) {
                return -1;
            }
            if (position >= this.mData.length) {
                return -1;
            }
            Arrays.fill(this.mData, position, this.mData.length, Integer.MIN_VALUE);
            return this.mData.length;
        }

        int getSpan(int position) {
            if (this.mData == null || position >= this.mData.length || position < 0) {
                return Integer.MIN_VALUE;
            }
            return this.mData[position];
        }

        void setSpan(int position, Span span) {
            this.ensureSize(position);
            this.mData[position] = span.mIndex;
        }

        int sizeForPosition(int position) {
            int len;
            for (len = this.mData.length; len <= position; len *= 2) {
            }
            return len;
        }

        void ensureSize(int position) {
            if (this.mData == null) {
                this.mData = new int[Math.max(position, 10) + 1];
                Arrays.fill(this.mData, Integer.MIN_VALUE);
            } else if (position >= this.mData.length) {
                int[] old = this.mData;
                this.mData = new int[this.sizeForPosition(position)];
                System.arraycopy(old, 0, this.mData, 0, old.length);
                Arrays.fill(this.mData, old.length, this.mData.length, Integer.MIN_VALUE);
            }
        }

        void clear() {
            if (this.mData != null) {
                Arrays.fill(this.mData, Integer.MIN_VALUE);
            }
        }

        void offsetForRemoval(int positionStart, int itemCount) {
            if (this.mData == null || positionStart >= this.mData.length) {
                return;
            }
            this.ensureSize(positionStart + itemCount);
            System.arraycopy(this.mData, positionStart + itemCount, this.mData, positionStart, this.mData.length - positionStart - itemCount);
            Arrays.fill(this.mData, this.mData.length - itemCount, this.mData.length, Integer.MIN_VALUE);
        }

        void offsetForAddition(int positionStart, int itemCount) {
            if (this.mData == null || positionStart >= this.mData.length) {
                return;
            }
            this.ensureSize(positionStart + itemCount);
            System.arraycopy(this.mData, positionStart, this.mData, positionStart + itemCount, this.mData.length - positionStart - itemCount);
            Arrays.fill(this.mData, positionStart, positionStart + itemCount, Integer.MIN_VALUE);
        }
    }

    static class Span {
        static final int INVALID_OFFSET = Integer.MIN_VALUE;
        private ArrayList<View> mViews = new ArrayList();
        int mCachedStart = Integer.MIN_VALUE;
        int mCachedEnd = Integer.MIN_VALUE;
        int mDeletedSize = 0;
        final int mIndex;
        int mLastEdgeStart = Integer.MIN_VALUE;
        int mLastEdgeEnd = Integer.MIN_VALUE;

        private Span(int index) {
            this.mIndex = index;
        }

        void calculateCachedStart(@NonNull OrientationHelperEx helper) {
            if (this.mViews.size() == 0) {
                this.mCachedStart = Integer.MIN_VALUE;
            } else {
                View startView = this.mViews.get(0);
                this.mCachedStart = helper.getDecoratedStart(startView);
            }
        }

        int getStartLine(OrientationHelperEx helper) {
            return this.getStartLine(Integer.MIN_VALUE, helper);
        }

        int getStartLine(int defaultValue, OrientationHelperEx helper) {
            if (this.mCachedStart != Integer.MIN_VALUE) {
                return this.mCachedStart;
            }
            if (defaultValue != Integer.MIN_VALUE && this.mViews.size() == 0) {
                if (this.mLastEdgeEnd != Integer.MIN_VALUE) {
                    return this.mLastEdgeEnd;
                }
                return defaultValue;
            }
            this.calculateCachedStart(helper);
            return this.mCachedStart;
        }

        void calculateCachedEnd(OrientationHelperEx helper) {
            if (this.mViews.size() == 0) {
                this.mCachedEnd = Integer.MIN_VALUE;
            } else {
                View endView = this.mViews.get(this.mViews.size() - 1);
                this.mCachedEnd = helper.getDecoratedEnd(endView);
            }
        }

        int getEndLine(OrientationHelperEx helper) {
            return this.getEndLine(Integer.MIN_VALUE, helper);
        }

        int getEndLine(int defaultValue, OrientationHelperEx helper) {
            if (this.mCachedEnd != Integer.MIN_VALUE) {
                return this.mCachedEnd;
            }
            if (defaultValue != Integer.MIN_VALUE && this.mViews.size() == 0) {
                if (this.mLastEdgeStart != Integer.MIN_VALUE) {
                    return this.mLastEdgeStart;
                }
                return defaultValue;
            }
            this.calculateCachedEnd(helper);
            return this.mCachedEnd;
        }

        void prependToSpan(View view, OrientationHelperEx helper) {
            RecyclerView.LayoutParams lp = this.getLayoutParams(view);
            this.mViews.add(0, view);
            this.mCachedStart = Integer.MIN_VALUE;
            if (this.mViews.size() == 1) {
                this.mCachedEnd = Integer.MIN_VALUE;
            }
            if (lp.isItemRemoved() || lp.isItemChanged()) {
                this.mDeletedSize += helper.getDecoratedMeasurement(view);
            }
        }

        void appendToSpan(View view, OrientationHelperEx helper) {
            RecyclerView.LayoutParams lp = this.getLayoutParams(view);
            this.mViews.add(view);
            this.mCachedEnd = Integer.MIN_VALUE;
            if (this.mViews.size() == 1) {
                this.mCachedStart = Integer.MIN_VALUE;
            }
            if (lp.isItemRemoved() || lp.isItemChanged()) {
                this.mDeletedSize += helper.getDecoratedMeasurement(view);
            }
        }

        void cacheReferenceLineAndClear(boolean reverseLayout, int offset, OrientationHelperEx helper) {
            int reference = reverseLayout ? this.getEndLine(helper) : this.getStartLine(helper);
            this.clear();
            if (reference == Integer.MIN_VALUE) {
                return;
            }
            if (reverseLayout && reference < helper.getEndAfterPadding() || reverseLayout || reference > helper.getStartAfterPadding()) {
                // empty if block
            }
            if (offset != Integer.MIN_VALUE) {
                reference += offset;
            }
            this.mCachedStart = this.mCachedEnd = reference;
            this.mLastEdgeEnd = Integer.MIN_VALUE;
            this.mLastEdgeStart = Integer.MIN_VALUE;
        }

        void clear() {
            this.mViews.clear();
            this.invalidateCache();
            this.mDeletedSize = 0;
        }

        void invalidateCache() {
            this.mCachedStart = Integer.MIN_VALUE;
            this.mCachedEnd = Integer.MIN_VALUE;
            this.mLastEdgeEnd = Integer.MIN_VALUE;
            this.mLastEdgeStart = Integer.MIN_VALUE;
        }

        void setLine(int line) {
            this.mCachedEnd = this.mCachedStart = line;
            this.mLastEdgeEnd = Integer.MIN_VALUE;
            this.mLastEdgeStart = Integer.MIN_VALUE;
        }

        void popEnd(OrientationHelperEx helper) {
            int size = this.mViews.size();
            View end = this.mViews.remove(size - 1);
            RecyclerView.LayoutParams lp = this.getLayoutParams(end);
            if (lp.isItemRemoved() || lp.isItemChanged()) {
                this.mDeletedSize -= helper.getDecoratedMeasurement(end);
            }
            if (size == 1) {
                this.mCachedStart = Integer.MIN_VALUE;
            }
            this.mCachedEnd = Integer.MIN_VALUE;
        }

        boolean findEnd(View view) {
            int size = this.mViews.size();
            if (size > 0) {
                return this.mViews.get(size - 1) == view;
            }
            return false;
        }

        void popStart(OrientationHelperEx helper) {
            View start = this.mViews.remove(0);
            RecyclerView.LayoutParams lp = this.getLayoutParams(start);
            if (this.mViews.size() == 0) {
                this.mCachedEnd = Integer.MIN_VALUE;
            }
            if (lp.isItemRemoved() || lp.isItemChanged()) {
                this.mDeletedSize -= helper.getDecoratedMeasurement(start);
            }
            this.mCachedStart = Integer.MIN_VALUE;
        }

        boolean findStart(View view) {
            int size = this.mViews.size();
            if (size > 0) {
                return this.mViews.get(0) == view;
            }
            return false;
        }

        public int getDeletedSize() {
            return this.mDeletedSize;
        }

        RecyclerView.LayoutParams getLayoutParams(View view) {
            return (RecyclerView.LayoutParams)view.getLayoutParams();
        }

        void onOffset(int dt) {
            if (this.mLastEdgeStart != Integer.MIN_VALUE) {
                this.mLastEdgeStart += dt;
            }
            if (this.mCachedStart != Integer.MIN_VALUE) {
                this.mCachedStart += dt;
            }
            if (this.mLastEdgeEnd != Integer.MIN_VALUE) {
                this.mLastEdgeEnd += dt;
            }
            if (this.mCachedEnd != Integer.MIN_VALUE) {
                this.mCachedEnd += dt;
            }
        }

        int getNormalizedOffset(int dt, int targetStart, int targetEnd, OrientationHelperEx helper) {
            if (this.mViews.size() == 0) {
                return 0;
            }
            if (dt < 0) {
                int endSpace = this.getEndLine(0, helper) - targetEnd;
                if (endSpace <= 0) {
                    return 0;
                }
                return -dt > endSpace ? -endSpace : dt;
            }
            int startSpace = targetStart - this.getStartLine(0, helper);
            if (startSpace <= 0) {
                return 0;
            }
            return startSpace < dt ? startSpace : dt;
        }

        boolean isEmpty(int start, int end, OrientationHelperEx orientationHelper) {
            int count = this.mViews.size();
            for (int i = 0; i < count; ++i) {
                View view = this.mViews.get(i);
                if (orientationHelper.getDecoratedStart(view) >= end || orientationHelper.getDecoratedEnd(view) <= start) continue;
                return false;
            }
            return true;
        }
    }
}

