/*
 * Decompiled with CFR 0.152.
 */
package com.deepl.api;

import com.deepl.api.LanguageCode;
import org.jetbrains.annotations.Nullable;

public class TextResult {
    private final String text;
    private final String detectedSourceLanguage;
    private final int billedCharacters;
    @Nullable
    private final String modelTypeUsed;

    public TextResult(String text, String detectedSourceLanguage, int billedCharacters, @Nullable String modelTypeUsed) {
        this.text = text;
        this.detectedSourceLanguage = LanguageCode.standardize(detectedSourceLanguage);
        this.billedCharacters = billedCharacters;
        this.modelTypeUsed = modelTypeUsed;
    }

    public String getText() {
        return this.text;
    }

    public String getDetectedSourceLanguage() {
        return this.detectedSourceLanguage;
    }

    public int getBilledCharacters() {
        return this.billedCharacters;
    }

    @Nullable
    public String getModelTypeUsed() {
        return this.modelTypeUsed;
    }
}

