/*
 * *************************************************************************************
 *  Copyright (C) 2008 EsperTech, Inc. All rights reserved.                            *
 *  http://esper.codehaus.org                                                          *
 *  http://www.espertech.com                                                           *
 *  ---------------------------------------------------------------------------------- *
 *  The software in this package is published under the terms of the GPL license       *
 *  a copy of which has been included with this distribution in the license.txt file.  *
 * *************************************************************************************
 */

package com.espertech.esper.client.soda;

import com.espertech.esper.epl.expression.core.ExprNodeUtility;

import java.io.StringWriter;
import java.util.List;

/**
 * The "new instance" operator instantiates a host language object.
 */
public class NewInstanceOperatorExpression extends ExpressionBase {

    private static final long serialVersionUID = 4725168176516142366L;
    private String className;

    /**
     * Ctor.
     */
    public NewInstanceOperatorExpression() {
    }

    /**
     * Ctor.
     * <p>
     * @param className the class name
     */
    public NewInstanceOperatorExpression(String className) {
        this.className = className;
    }

    /**
     * Returns the class name.
     * @return class name
     */
    public String getClassName() {
        return className;
    }

    /**
     * Sets the class name.
     * @param className class name to set
     */
    public void setClassName(String className) {
        this.className = className;
    }

    public ExpressionPrecedenceEnum getPrecedence()
    {
        return ExpressionPrecedenceEnum.UNARY;
    }

    public void toPrecedenceFreeEPL(StringWriter writer)
    {
        writer.write("new ");
        writer.write(className);
        writer.write("(");
        ExpressionBase.toPrecedenceFreeEPL(this.getChildren(), writer);
        writer.write(")");
    }
}
