/*
 * *************************************************************************************
 *  Copyright (C) 2008 EsperTech, Inc. All rights reserved.                            *
 *  http://esper.codehaus.org                                                          *
 *  http://www.espertech.com                                                           *
 *  ---------------------------------------------------------------------------------- *
 *  The software in this package is published under the terms of the GPL license       *
 *  a copy of which has been included with this distribution in the license.txt file.  *
 * *************************************************************************************
 */

package com.espertech.esper.core.service.multimatch;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.filter.FilterHandleCallback;

import java.util.Collection;

public class MultiMatchHandlerSubqueryPreevalNoDedup implements MultiMatchHandler {
    public static final MultiMatchHandlerSubqueryPreevalNoDedup INSTANCE = new MultiMatchHandlerSubqueryPreevalNoDedup();

    private MultiMatchHandlerSubqueryPreevalNoDedup() {
    }

    public void handle(Collection<FilterHandleCallback> callbacks, EventBean theEvent) {
        for (FilterHandleCallback callback : callbacks) {
            if (callback.isSubSelect()) {
                callback.matchFound(theEvent, callbacks);
            }
        }

        for (FilterHandleCallback callback : callbacks) {
            if (!callback.isSubSelect()) {
                callback.matchFound(theEvent, callbacks);
            }
        }
    }
}
