/**************************************************************************************
 * Copyright (C) 2006-2015 EsperTech Inc. All rights reserved.                        *
 * http://esper.codehaus.org                                                          *
 * http://www.espertech.com                                                           *
 * ---------------------------------------------------------------------------------- *
 * The software in this package is published under the terms of the GPL license       *
 * a copy of which has been included with this distribution in the license.txt file.  *
 **************************************************************************************/
package com.espertech.esper.core.start;

import com.espertech.esper.util.DestroyCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayDeque;
import java.util.Deque;

/**
 * Method to call to destroy an EPStatement.
 */
public class EPStatementDestroyCallbackList implements EPStatementDestroyMethod
{
    private static final Log log = LogFactory.getLog(EPStatementDestroyCallbackList.class);

    private Deque<DestroyCallback> callbacks;

    public void addCallback(DestroyCallback destroyCallback) {
        if (callbacks == null) {
            callbacks = new ArrayDeque<DestroyCallback>(2);
        }
        callbacks.add(destroyCallback);
    }

    public void destroy() {
        if (callbacks == null) {
            return;
        }
        for (DestroyCallback destroyCallback : callbacks) {
            try {
                destroyCallback.destroy();
            }
            catch (RuntimeException ex) {
                log.error("Failed to destroy resource: " + ex.getMessage(), ex);
            }
        }
    }
}