/**************************************************************************************
 * Copyright (C) 2006-2015 EsperTech Inc. All rights reserved.                        *
 * http://esper.codehaus.org                                                          *
 * http://www.espertech.com                                                           *
 * ---------------------------------------------------------------------------------- *
 * The software in this package is published under the terms of the GPL license       *
 * a copy of which has been included with this distribution in the license.txt file.  *
 **************************************************************************************/
package com.espertech.esper.epl.agg.aggregator;

import com.espertech.esper.epl.agg.service.AggregatorUtil;

/**
 * Aggregator for the very last value.
 */
public class AggregatorLastEverFilter extends AggregatorLastEver
{
    public AggregatorLastEverFilter(Class type) {
        super(type);
    }

    @Override
    public void enter(Object parameters)
    {
        Object[] paramArray = (Object[]) parameters;
        if (!AggregatorUtil.checkFilter(paramArray)) {
            return;
        }
        super.enter(paramArray[0]);
    }
}