/**************************************************************************************
 * Copyright (C) 2006-2015 EsperTech Inc. All rights reserved.                        *
 * http://esper.codehaus.org                                                          *
 * http://www.espertech.com                                                           *
 * ---------------------------------------------------------------------------------- *
 * The software in this package is published under the terms of the GPL license       *
 * a copy of which has been included with this distribution in the license.txt file.  *
 **************************************************************************************/
package com.espertech.esper.epl.expression.funcs;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.metrics.instrumentation.InstrumentationHelper;

public class ExprCastNodeConstEval implements ExprEvaluator
{
    private final ExprCastNode parent;
    private final Object theConstant;

    public ExprCastNodeConstEval(ExprCastNode parent, Object theConstant) {
        this.parent = parent;
        this.theConstant = theConstant;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (InstrumentationHelper.ENABLED) {
            InstrumentationHelper.get().qExprCast(parent);
            InstrumentationHelper.get().aExprCast(theConstant);
        }
        return theConstant;
    }

    public Class getType() {
        return parent.getTargetType();
    }
}
