/**************************************************************************************
 * Copyright (C) 2006-2015 EsperTech Inc. All rights reserved.                        *
 * http://esper.codehaus.org                                                          *
 * http://www.espertech.com                                                           *
 * ---------------------------------------------------------------------------------- *
 * The software in this package is published under the terms of the GPL license       *
 * a copy of which has been included with this distribution in the license.txt file.  *
 **************************************************************************************/
package com.espertech.esper.epl.expression.prior;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.view.window.RandomAccessByIndex;

/**
 * Represents the 'prior' prior event function in an expression node tree.
 */
public class ExprPriorEvalStrategyRandomAccess extends ExprPriorEvalStrategyBase
{
    private final transient RandomAccessByIndex randomAccess;

    public ExprPriorEvalStrategyRandomAccess(RandomAccessByIndex randomAccess) {
        this.randomAccess = randomAccess;
    }

    public EventBean getSubstituteEvent(EventBean originalEvent, boolean isNewData, int constantIndexNumber) {
        if (isNewData)
        {
            return randomAccess.getNewData(constantIndexNumber);
        }
        else
        {
            return randomAccess.getOldData(constantIndexNumber);
        }
    }
}
