/**************************************************************************************
 * Copyright (C) 2006-2015 EsperTech Inc. All rights reserved.                        *
 * http://esper.codehaus.org                                                          *
 * http://www.espertech.com                                                           *
 * ---------------------------------------------------------------------------------- *
 * The software in this package is published under the terms of the GPL license       *
 * a copy of which has been included with this distribution in the license.txt file.  *
 **************************************************************************************/
package com.espertech.esper.pattern.observer;

import com.espertech.esper.pattern.MatchedEventMap;

/**
 * Observers observe and indicate other external events such as timing events.
 */
public interface EventObserver
{
    /**
     * Start observing.
     */
    public void startObserve();

    /**
     * Stop observing.
     */
    public void stopObserve();

    public void accept(EventObserverVisitor visitor);

    public MatchedEventMap getBeginState();
}
