/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.template;

import com.sforce.ws.template.JspNode;
import com.sforce.ws.template.JspTokenizer;
import com.sforce.ws.util.FileUtil;
import java.io.IOException;

class Text
implements JspNode {
    private String[] text;

    public Text(JspTokenizer tokeniser) throws IOException {
        String t = tokeniser.getText();
        this.text = t.split(FileUtil.EOL);
    }

    private String clean(String t) {
        if (t == null) {
            return null;
        }
        t = t.replace("\n", "");
        t = t.replace("\r", "");
        String[] split = t.split("\"");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < split.length - 1; ++i) {
            sb.append(split[i]);
            sb.append("\\\"");
        }
        sb.append(split[split.length - 1]);
        if (t.endsWith("\"")) {
            sb.append("\\\"");
        }
        return sb.toString();
    }

    @Override
    public void toJavaScript(StringBuilder sb) {
        for (int i = 0; i < this.text.length; ++i) {
            sb.append(FileUtil.EOL);
            if (i < this.text.length - 1) {
                sb.append("out.println(");
            } else {
                sb.append("out.print(");
            }
            sb.append("\"");
            sb.append(this.clean(this.text[i]));
            sb.append("\"");
            sb.append(");");
        }
    }
}

