/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.wsdl;

import com.sforce.ws.wsdl.Annotation;
import com.sforce.ws.wsdl.ComplexType;
import com.sforce.ws.wsdl.Constants;
import com.sforce.ws.wsdl.Element;
import com.sforce.ws.wsdl.SimpleType;
import com.sforce.ws.wsdl.WsdlParseException;
import com.sforce.ws.wsdl.WsdlParser;
import java.util.HashMap;
import java.util.Iterator;

public class Schema
implements Constants {
    private String targetNamespace;
    private String elementFormDefault;
    private String attributeFormDefault;
    private HashMap<String, ComplexType> complexTypes = new HashMap();
    private HashMap<String, SimpleType> simpleTypes = new HashMap();
    private HashMap<String, Element> elements = new HashMap();

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public boolean isElementFormQualified() {
        return "qualified".equals(this.elementFormDefault);
    }

    public boolean isAttributeFormQualified() {
        return "qualified".equals(this.attributeFormDefault);
    }

    public void addComplexType(ComplexType type) {
        this.complexTypes.put(type.getName(), type);
    }

    public void addSimpleType(SimpleType type) {
        this.simpleTypes.put(type.getName(), type);
    }

    public Iterator<ComplexType> getComplexTypes() {
        return this.complexTypes.values().iterator();
    }

    public Iterator<SimpleType> getSimpleTypes() {
        return this.simpleTypes.values().iterator();
    }

    public ComplexType getComplexType(String type) {
        return this.complexTypes.get(type);
    }

    public SimpleType getSimpleType(String type) {
        return this.simpleTypes.get(type);
    }

    public Element getGlobalElement(String name) {
        return this.elements.get(name);
    }

    public Iterator<Element> getGlobalElements() {
        return this.elements.values().iterator();
    }

    public String toString() {
        return "Schema{targetNamespace='" + this.targetNamespace + '\'' + ", elementFormDefault='" + this.elementFormDefault + '\'' + ", attributeFormDefault='" + this.attributeFormDefault + '\'' + ", complexTypes=" + this.complexTypes + '}';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void read(WsdlParser parser) throws WsdlParseException {
        this.targetNamespace = parser.getAttributeValue(null, "targetNamespace");
        this.elementFormDefault = parser.getAttributeValue(null, "elementFormDefault");
        this.attributeFormDefault = parser.getAttributeValue(null, "attributeFormDefault");
        int eventType = parser.getEventType();
        while (true) {
            if (eventType == 2) {
                String n = parser.getName();
                String ns = parser.getNamespace();
                if ("complexType".equals(n) && "http://www.w3.org/2001/XMLSchema".equals(ns)) {
                    ComplexType complexType = new ComplexType(this);
                    complexType.read(parser, null);
                    this.complexTypes.put(complexType.getName(), complexType);
                } else if ("element".equals(n) && "http://www.w3.org/2001/XMLSchema".equals(ns)) {
                    Element element = new Element(this);
                    element.read(parser);
                    this.elements.put(element.getName(), element);
                } else if ("simpleType".equals(n) && "http://www.w3.org/2001/XMLSchema".equals(ns)) {
                    SimpleType simpleType = new SimpleType(this);
                    simpleType.read(parser, null);
                    this.simpleTypes.put(simpleType.getName(), simpleType);
                } else if (!"schema".equals(n) || !"http://www.w3.org/2001/XMLSchema".equals(ns)) {
                    if ("import".equals(n) && "http://www.w3.org/2001/XMLSchema".equals(ns)) {
                        String location = parser.getAttributeValue(null, "schemaLocation");
                        if (location != null) {
                            throw new WsdlParseException("Found schema import from location " + location + ". External schema import not supported");
                        }
                    } else {
                        if (!"annotation".equals(n) || !"http://www.w3.org/2001/XMLSchema".equals(ns)) throw new WsdlParseException("Unsupported Schema element found " + ns + ":" + n + ". At: " + parser.getPositionDescription());
                        Annotation annotation = new Annotation();
                        annotation.read(parser);
                    }
                }
            } else if (eventType == 3) {
                String name = parser.getName();
                String namespace = parser.getNamespace();
                if ("schema".equals(name) && "http://www.w3.org/2001/XMLSchema".equals(namespace)) {
                    break;
                }
            } else if (eventType == 1) {
                throw new WsdlParseException("Failed to find end tag for 'schema'");
            }
            eventType = parser.next();
        }
        if (this.targetNamespace != null) return;
        throw new WsdlParseException("schema:targetNamespace can not be null");
    }
}

