/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.codegen;

import com.sforce.ws.codegen.ToolsJarClassLoader;
import com.sforce.ws.tools.ToolsException;
import com.sforce.ws.util.Verbose;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;

class Compiler {
    private Object main;
    private Method method;

    public Compiler() throws ToolsException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        try {
            this.findCompiler(loader);
        }
        catch (ClassNotFoundException e) {
            this.findCompilerInToolsJar(loader);
        }
        catch (NoSuchMethodException e) {
            this.throwToolsexception(e);
        }
        catch (IllegalAccessException e) {
            this.throwToolsexception(e);
        }
        catch (InstantiationException e) {
            this.throwToolsexception(e);
        }
    }

    private void findCompilerInToolsJar(ClassLoader loader) throws ToolsException {
        try {
            ToolsJarClassLoader tloader = new ToolsJarClassLoader(loader);
            this.findCompiler(tloader);
        }
        catch (MalformedURLException e) {
            this.throwToolsexception(e);
        }
        catch (NoSuchMethodException e) {
            this.throwToolsexception(e);
        }
        catch (IllegalAccessException e) {
            this.throwToolsexception(e);
        }
        catch (InstantiationException e) {
            this.throwToolsexception(e);
        }
        catch (ClassNotFoundException e) {
            this.throwToolsexception(e);
        }
        catch (IOException e) {
            this.throwToolsexception(e);
        }
    }

    private void findCompiler(ClassLoader loader) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException {
        Class<?> c = loader.loadClass("com.sun.tools.javac.Main");
        Class<?> arg = new String[0].getClass();
        this.main = c.newInstance();
        this.method = c.getMethod("compile", arg);
    }

    private void throwToolsexception(Exception e) throws ToolsException {
        e.printStackTrace();
        throw new ToolsException("Unable to find compiler. Make sure that tools.jar is in your classpath: " + e);
    }

    public void compile(String[] files, File dir) throws ToolsException {
        String target = System.getProperty("compileTarget");
        if (target == null) {
            target = "1.6";
        }
        Verbose.log("Compiling to target " + target + "... ");
        String[] args = new String[]{"-g", "-d", dir.getAbsolutePath(), "-sourcepath", dir.getAbsolutePath(), "-target", target, "-source", target};
        String[] call = new String[args.length + files.length];
        System.arraycopy(args, 0, call, 0, args.length);
        System.arraycopy(files, 0, call, args.length, files.length);
        try {
            Integer result = (Integer)this.method.invoke(this.main, new Object[]{call});
            if (result != 0) {
                throw new ToolsException("Failed to compile");
            }
        }
        catch (IllegalAccessException e) {
            throw new ToolsException("Failed to compile: " + e);
        }
        catch (InvocationTargetException e) {
            throw new ToolsException("Failed to compile: " + e);
        }
        Verbose.log("Compiled " + files.length + " java files.");
    }
}

