/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.WxMaShopAuditService;
import cn.binarywang.wx.miniapp.bean.shop.request.WxMaShopAuditBrandRequest;
import cn.binarywang.wx.miniapp.bean.shop.request.WxMaShopAuditCategoryRequest;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopAuditBrandResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopAuditCategoryResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopAuditResultResponse;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import com.google.gson.JsonObject;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.common.util.json.GsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMaShopAuditServiceImpl
implements WxMaShopAuditService {
    private static final Logger log = LoggerFactory.getLogger(WxMaShopAuditServiceImpl.class);
    private final WxMaService wxMaService;

    @Override
    public WxMaShopAuditBrandResponse auditBrand(WxMaShopAuditBrandRequest request) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/audit/audit_brand", request);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopAuditBrandResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopAuditBrandResponse.class);
    }

    @Override
    public WxMaShopAuditCategoryResponse auditCategory(WxMaShopAuditCategoryRequest request) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/audit/audit_category", request);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopAuditCategoryResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopAuditCategoryResponse.class);
    }

    @Override
    public WxMaShopAuditResultResponse getAuditResult(String auditId) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/audit/result", GsonHelper.buildJsonObject((Object[])new Object[]{"audit_id", auditId}));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopAuditResultResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopAuditResultResponse.class);
    }

    @Override
    public JsonObject getMiniappCertificate(int reqType) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/audit/get_miniapp_certificate", GsonHelper.buildJsonObject((Object[])new Object[]{"req_type", reqType}));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (JsonObject)WxMaGsonBuilder.create().fromJson(responseContent, JsonObject.class);
    }

    public WxMaShopAuditServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

