/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaInternetService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.internet.WxMaInternetResponse;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;

public class WxMaInternetServiceImpl
implements WxMaInternetService {
    private final WxMaService wxMaService;

    private String sha256(String data, String sessionKey) throws Exception {
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(sessionKey.getBytes("UTF-8"), "HmacSHA256");
        sha256_HMAC.init(secret_key);
        byte[] array = sha256_HMAC.doFinal(data.getBytes("UTF-8"));
        StringBuilder sb = new StringBuilder();
        for (byte item : array) {
            sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString().toUpperCase();
    }

    @Override
    public WxMaInternetResponse getUserEncryptKey(String openid, String signature, String sigMethod) throws WxErrorException {
        String url = "https://api.weixin.qq.com/wxa/business/getuserencryptkey?openid=" + openid + "&signature=" + signature + "&sig_method=" + sigMethod;
        return this.getWxMaInternetResponse(url);
    }

    @Override
    public WxMaInternetResponse getUserEncryptKey(String openid, String sessionKey) throws WxErrorException {
        String signature = null;
        try {
            signature = this.sha256("", sessionKey);
        }
        catch (Exception e) {
            throw new WxErrorException("\u7b7e\u540d\u9519\u8bef");
        }
        String url = "https://api.weixin.qq.com/wxa/business/getuserencryptkey?sig_method=hmac_sha256&openid=" + openid + "&signature=" + signature;
        return this.getWxMaInternetResponse(url);
    }

    private WxMaInternetResponse getWxMaInternetResponse(String url) throws WxErrorException {
        String responseContent = this.wxMaService.post(url, "");
        WxMaInternetResponse response = (WxMaInternetResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaInternetResponse.class);
        if (response.getErrcode() == -1) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return response;
    }

    public WxMaInternetServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

