/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.WxMaShopPayService;
import cn.binarywang.wx.miniapp.bean.shop.request.WxMaShopPayCreateOrderRequest;
import cn.binarywang.wx.miniapp.bean.shop.request.WxMaShopPayOrderRefundRequest;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopBaseResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopPayCreateOrderResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopPayGetOrderResponse;
import com.google.gson.JsonObject;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMaShopPayServiceImpl
implements WxMaShopPayService {
    private static final Logger log = LoggerFactory.getLogger(WxMaShopPayServiceImpl.class);
    private final WxMaService wxMaService;

    @Override
    public WxMaShopPayCreateOrderResponse createOrder(WxMaShopPayCreateOrderRequest request) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/shop/pay/createorder", request);
        return (WxMaShopPayCreateOrderResponse)WxGsonBuilder.create().fromJson(response, WxMaShopPayCreateOrderResponse.class);
    }

    @Override
    public WxMaShopPayGetOrderResponse getOrder(String tradeNo) throws WxErrorException {
        JsonObject request = GsonHelper.buildJsonObject((Object[])new Object[]{"trade_no", tradeNo});
        String response = this.wxMaService.post("https://api.weixin.qq.com/shop/pay/getorder", request);
        return (WxMaShopPayGetOrderResponse)WxGsonBuilder.create().fromJson(response, WxMaShopPayGetOrderResponse.class);
    }

    @Override
    public WxMaShopBaseResponse refundOrder(WxMaShopPayOrderRefundRequest request) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/shop/pay/refundorder", request);
        return (WxMaShopBaseResponse)WxGsonBuilder.create().fromJson(response, WxMaShopBaseResponse.class);
    }

    public WxMaShopPayServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

