/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.impl.BaseWxMaServiceImpl;
import cn.binarywang.wx.miniapp.bean.WxMaStableAccessTokenRequest;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.ProxyInfo;
import jodd.http.net.SocketHttpConnectionProvider;
import me.chanjar.weixin.common.util.http.HttpType;
import org.apache.commons.lang3.StringUtils;

public class WxMaServiceJoddHttpImpl
extends BaseWxMaServiceImpl<HttpConnectionProvider, ProxyInfo> {
    private HttpConnectionProvider httpClient;
    private ProxyInfo httpProxy;

    @Override
    public void initHttp() {
        WxMaConfig configStorage = this.getWxMaConfig();
        if (configStorage.getHttpProxyHost() != null && configStorage.getHttpProxyPort() > 0) {
            this.httpProxy = new ProxyInfo(ProxyInfo.ProxyType.HTTP, configStorage.getHttpProxyHost(), configStorage.getHttpProxyPort(), configStorage.getHttpProxyUsername(), configStorage.getHttpProxyPassword());
        }
        this.httpClient = new SocketHttpConnectionProvider();
    }

    public HttpConnectionProvider getRequestHttpClient() {
        return this.httpClient;
    }

    public ProxyInfo getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpType getRequestType() {
        return HttpType.JODD_HTTP;
    }

    @Override
    protected String doGetAccessTokenRequest() throws IOException {
        String url = StringUtils.isNotEmpty((CharSequence)this.getWxMaConfig().getAccessTokenUrl()) ? this.getWxMaConfig().getAccessTokenUrl() : (StringUtils.isNotEmpty((CharSequence)this.getWxMaConfig().getApiHostUrl()) ? "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s".replace("https://api.weixin.qq.com", this.getWxMaConfig().getApiHostUrl()) : "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s");
        url = String.format(url, this.getWxMaConfig().getAppid(), this.getWxMaConfig().getSecret());
        HttpRequest request = HttpRequest.get((String)url);
        if (this.getRequestHttpProxy() != null) {
            SocketHttpConnectionProvider provider = new SocketHttpConnectionProvider();
            provider.useProxy(this.getRequestHttpProxy());
            request.withConnectionProvider((HttpConnectionProvider)provider);
        }
        return request.send().bodyText();
    }

    @Override
    protected String doGetStableAccessTokenRequest(boolean forceRefresh) throws IOException {
        String url = StringUtils.isNotEmpty((CharSequence)this.getWxMaConfig().getAccessTokenUrl()) ? this.getWxMaConfig().getAccessTokenUrl() : (StringUtils.isNotEmpty((CharSequence)this.getWxMaConfig().getApiHostUrl()) ? "https://api.weixin.qq.com/cgi-bin/stable_token".replace("https://api.weixin.qq.com", this.getWxMaConfig().getApiHostUrl()) : "https://api.weixin.qq.com/cgi-bin/stable_token");
        WxMaStableAccessTokenRequest wxMaAccessTokenRequest = new WxMaStableAccessTokenRequest();
        wxMaAccessTokenRequest.setAppid(this.getWxMaConfig().getAppid());
        wxMaAccessTokenRequest.setSecret(this.getWxMaConfig().getSecret());
        wxMaAccessTokenRequest.setGrantType("client_credential");
        wxMaAccessTokenRequest.setForceRefresh(forceRefresh);
        HttpRequest request = (HttpRequest)((HttpRequest)HttpRequest.post((String)url).contentType("application/json", StandardCharsets.UTF_8.name())).body(wxMaAccessTokenRequest.toJson());
        if (this.getRequestHttpProxy() != null) {
            SocketHttpConnectionProvider provider = new SocketHttpConnectionProvider();
            provider.useProxy(this.getRequestHttpProxy());
            request.withConnectionProvider((HttpConnectionProvider)provider);
        }
        return request.send().bodyText();
    }
}

